/*
 * Decompiled with CFR 0.152.
 */
package paraselene.dyna;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.cyberneko.html.parsers.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import paraselene.Page;
import paraselene.Text;
import paraselene.Version;
import paraselene.dyna.DynamicPageException;
import paraselene.dyna.GrantTagProvider;
import paraselene.dyna.Handler;
import paraselene.dyna.InStream;
import paraselene.dyna.NameDefine;
import paraselene.dyna.URIResolver;
import paraselene.mockup.TagMap;
import paraselene.supervisor.Forward;
import paraselene.supervisor.PageID;
import paraselene.supervisor.RequestParameter;
import paraselene.tag.Attribute;
import paraselene.tag.Tag;

public class DynamicPage
extends Page {
    private static final long serialVersionUID = 2L;
    private static String[] simple = new String[]{"area", "base", "basefont", "bgsound", "br", "col", "frame", "hr", "img", "input", "isindex", "keygen", "link", "meta", "nextid", "param", "spacer", "wbr"};
    private static HashMap<String, String> simple_map = new HashMap();
    private Page page = null;
    private URIResolver resolve = null;
    private GrantTagProvider[] provider = null;
    private static final String START_XML = "<?xml";
    private static final String START_DOCTYPE = "<!DOCTYPE";
    private static final String START_HTML = "<html";
    private static final String XML_ENCODE = "encoding";
    private String xml_encode = null;
    private static final String JAVA_UNICODE = "UTF8";
    String parse_encode = null;

    public static boolean isSimpleTag(String name) {
        return simple_map.get(name = name.toLowerCase(Locale.ENGLISH)) != null;
    }

    public DynamicPage(URIResolver ur, GrantTagProvider[] gtp) {
        this.resolve = ur;
        this.provider = gtp;
    }

    public DynamicPage(URIResolver ur, Page p, GrantTagProvider[] gtp) {
        this(ur, gtp);
        this.page = p;
    }

    private void setXmlEncode(String str) {
        this.xml_encode = "UTF-8";
        int idx = str.indexOf(XML_ENCODE);
        if (idx < 0) {
            return;
        }
        if ((idx = (str = str.substring(idx + XML_ENCODE.length())).indexOf(34)) < 0) {
            return;
        }
        if ((idx = (str = str.substring(idx + 1)).indexOf(34)) < 0) {
            return;
        }
        this.xml_encode = str.substring(0, idx);
    }

    private boolean isXHTML(InputStream in) throws IOException {
        String line;
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        boolean xml = false;
        StringBuilder doc = null;
        StringBuilder xml_enc = null;
        while ((line = r.readLine()) != null) {
            int start;
            int end;
            if ((line = line.trim() + " ").isEmpty()) continue;
            int xml_loc = line.indexOf(START_XML);
            if (xml_loc >= 0) {
                xml = true;
                xml_enc = new StringBuilder();
            }
            if (xml_enc != null) {
                String sub = line;
                if (xml_loc > 0) {
                    sub = sub.substring(xml_loc);
                }
                if ((end = sub.indexOf(62)) < 0) {
                    xml_enc = xml_enc.append(sub);
                }
                if (end >= 0) {
                    xml_enc = xml_enc.append(sub.substring(0, end + 1));
                    this.setXmlEncode(xml_enc.toString());
                    xml_enc = null;
                }
            }
            if ((start = line.indexOf(START_DOCTYPE)) >= 0) {
                doc = new StringBuilder();
                xml_enc = null;
            }
            if (doc != null) {
                if (start > 0) {
                    line = line.substring(start);
                }
                if ((end = line.indexOf(62)) < 0) {
                    doc = doc.append(line);
                    continue;
                }
                doc = doc.append(line.substring(0, end + 1));
                break;
            }
            if (line.toLowerCase(Locale.ENGLISH).indexOf(START_HTML) < 0) continue;
            break;
        }
        r.close();
        this.setDoctype(xml, doc == null ? null : doc.toString());
        return xml;
    }

    public void create(String str) throws DynamicPageException {
        try {
            if (this.isXHTML(new InStream(str))) {
                this.createXML(new InStream(str));
            } else {
                this.createHTML(new InStream(str), JAVA_UNICODE);
            }
        }
        catch (DynamicPageException dpe) {
            throw dpe;
        }
        catch (Exception e) {
            throw new DynamicPageException(e);
        }
    }

    public void create(File f, String enc) throws DynamicPageException {
        try {
            if (this.isXHTML(new InStream(f))) {
                this.createXML(new InStream(f));
            } else {
                this.createHTML(new InStream(f), enc);
            }
        }
        catch (DynamicPageException dpe) {
            throw dpe;
        }
        catch (Exception e) {
            throw new DynamicPageException(e);
        }
    }

    private String getEncoding(String type) {
        if (type == null) {
            return null;
        }
        String[] part = type.split(";");
        for (int i = 0; i < part.length; ++i) {
            String[] sub = part[i].split("=");
            for (int j = 0; j < sub.length; ++j) {
                sub[j] = sub[j].trim();
                if (!"charset".equalsIgnoreCase(sub[j]) || j >= sub.length - 1) continue;
                return sub[j + 1].trim();
            }
        }
        return null;
    }

    public void create(URL url, RequestParameter.Method method, String enc) throws DynamicPageException {
        InputStream in = null;
        try {
            int len;
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setInstanceFollowRedirects(true);
            con.setRequestMethod(method == RequestParameter.Method.GET ? "GET" : "POST");
            con.connect();
            int retcd = con.getResponseCode();
            if (retcd / 100 != 2) {
                StringBuilder buf = new StringBuilder(Integer.toString(retcd));
                buf = buf.append(" ");
                buf = buf.append(con.getResponseMessage());
                throw new DynamicPageException(buf.toString());
            }
            if (enc == null) {
                enc = this.getEncoding(con.getContentType());
            }
            in = new BufferedInputStream(con.getInputStream());
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            byte[] data = new byte[4096];
            while ((len = in.read(data)) > 0) {
                buf.write(data, 0, len);
            }
            in.close();
            data = buf.toByteArray();
            if (this.isXHTML(new InStream(data))) {
                this.createXML(new InStream(data));
            } else {
                this.createHTML(new InStream(data), enc);
            }
        }
        catch (DynamicPageException dpe) {
            throw dpe;
        }
        catch (Exception e) {
            throw new DynamicPageException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private void createXML(InStream in) throws DynamicPageException {
        try {
            this.createHTML(in, null);
        }
        catch (Exception e) {
            throw new DynamicPageException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception ee) {}
        }
    }

    public String getParsingCharset() {
        return this.xml_encode == null ? this.parse_encode : this.xml_encode;
    }

    private void createHTML(InStream is, String enc) throws DynamicPageException {
        try {
            SAXParser parser = new SAXParser();
            if (enc != null) {
                parser.setProperty("http://cyberneko.org/html/properties/default-encoding", (Object)enc);
            }
            InputSource in = new InputSource();
            in.setByteStream(is);
            parser.setContentHandler((ContentHandler)new Handler(this));
            parser.parse(in);
            if (enc == null && (enc = this.getEncoding(this.parse_encode)) != null) {
                is.reload();
                this.clear();
                this.createHTML(is, enc);
            }
            this.parse_encode = enc;
            this.addVersionMeta(Version.getTitle(), new Date().toString());
        }
        catch (Exception e) {
            throw new DynamicPageException(e);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception ee) {}
        }
    }

    protected DynamicPage makePage() {
        return new DynamicPage(this.resolve, this, this.provider);
    }

    protected Tag makeTag(String name, ArrayList<Attribute> attr) throws Exception {
        return TagMap.makeTag(name, attr, this.getCharset(), this.resolve, this.provider);
    }

    protected Text makeText(String str) {
        return new Text(str);
    }

    @Override
    public void init() {
    }

    @Override
    public String getContentType() {
        if (this.page != null) {
            return this.page.getContentType();
        }
        return null;
    }

    @Override
    public String getCharset() {
        if (this.page != null) {
            return this.page.getCharset();
        }
        return "UTF-8";
    }

    @Override
    public PageID getID() {
        return null;
    }

    @Override
    public boolean isHistoryClear() {
        return false;
    }

    @Override
    public boolean isAllowHistoryAdd() {
        return false;
    }

    @Override
    public Forward input(RequestParameter req, Forward fw) throws Page.PageException {
        return fw;
    }

    @Override
    public Page output(Page from, RequestParameter req) throws Page.PageException {
        return this;
    }

    @Override
    public String getAliasURI() {
        return null;
    }

    @Override
    public int getUploadMaxBytes() {
        return -1;
    }

    @Override
    public boolean isCheckRepeatSameRequest() {
        return false;
    }

    @Override
    public Page.AjaxSupport getAjaxSupport() {
        return Page.AjaxSupport.NO;
    }

    @Override
    public void firstOutput(RequestParameter req) throws Page.PageException {
    }

    public static NameDefine[] inspectName(Page page, NameDefine[] define, String ... exclude) {
        if (define == null) {
            return null;
        }
        ArrayList<NameDefine> err = new ArrayList<NameDefine>();
        for (int i = 0; i < define.length; ++i) {
            define[i].setError("OK.");
            boolean flag = false;
            String name = define[i].getName();
            for (int j = 0; j < exclude.length; ++j) {
                if (!name.equals(exclude[j])) continue;
                define[i].setError("It is excluded.");
                flag = true;
                break;
            }
            if (flag) continue;
            Tag[] tag = page.getAllTag(name);
            if (tag == null || tag.length == 0) {
                define[i].setError("Name is undefined.");
                err.add(define[i]);
                continue;
            }
            Class<?> cls = define[i].getDefineClass();
            if (cls == null) continue;
            flag = false;
            for (int j = 0; j < tag.length; ++j) {
                if (!cls.equals(tag[j].getClass())) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            define[i].setError("Class is different.");
            err.add(define[i]);
        }
        if (err.size() == 0) {
            return null;
        }
        return err.toArray(new NameDefine[0]);
    }

    static {
        for (int i = 0; i < simple.length; ++i) {
            simple_map.put(simple[i], simple[i]);
        }
    }
}

