/*
 * Paraselene
 * Copyright (c) 2009, 2010  Akira Terasaki
 * このファイルは同梱されている License.txt に定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene;

import java.util.*;

/**
 * 文字参照。toString()の戻り値を、文字列として扱う事ができます。<br>
 * ブラウザへの応答や、JAVA実行中のString値として使用する場合は問題ありませんが、
 * 例えばデータベースへこのtoString()文字列を格納する場合には注意が必要です。
 * データベースがUTF-8であればほぼ問題ありませんが、例えばEUC-JP等の場合、
 * 文字によっては対応する文字コードが存在しない可能性があります。
 */
public enum WebChar {
#
	private static HashMap<Character, WebChar>	map = new HashMap<Character, WebChar>();
	static {
		WebChar[]	wc = values();
		for ( int i = 0; i < wc.length; i++ ) {
			map.put( wc[i].ch, wc[i] );
		}
		map.put( ' ', _nbsp );
	}

	private char ch;
	private String ref;
	private WebChar( char c, String s ) {
		ch = c;
		ref = s;
	}

	static WebChar getWebChar( char c ) {
		return map.get( c );
	}

	/**
	 * 文字列化。１文字のStringとして扱う事ができます。
	 * @return 文字列。
	 */
	public String toString() {
		return new String( new char[]{ ch } );
	}

	/**
	 * 文字化。１文字のcharとして扱う事ができます。
	 * @return 文字。
	 */
	public char toChar() {
		return ch;
	}

	/**
	 * 文字参照の取得。&amp;nbsp; のような文字列を返します。
	 * @return 文字参照。
	 */
	public String getReference() {
		return ref;
	}
}

