package #1.#x;

import paraselene.*;
import paraselene.supervisor.*;
import java.io.*;
import java.net.*;
import java.util.*;
import paraselene.dyna.*;

/**
 * リソース出力。
 */
public class Resource extends #1.SuperPage implements Downloadable {
	private static final long serialVersionUID = 1L;

	/**
	 * コンストラクタ。
	 */
	public Resource() {
		super();
		try {
			setInitialized( true );
		}
		catch( Exception e ) {
			Option.debug( e );
		}
	}
	/**
	 * ページIDの取得。
	 * @return ページID。
	 */
	public PageID getID() {
		return PageType.PARASELENE_RESOURCE;
	}
	/**
	 * ブラウザに403を返す。
	 * @param req リクエスト内容。
	 * @param fw デフォルト遷移先。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public Forward inputMain( RequestParameter req, Forward fw ) throws PageException {
		return new Forward( 403 );
	}
	public boolean isHistoryClear() { return false; }
	public boolean isAllowHistoryAdd() { return false; }
	/**
	 * 別名URI設定。
	 * @return paraselene.css.na
	 */
	public String getAliasURI() {
		return "paraselene.resource.na";
	}
	/**
	 * 初回outputの呼び出しメイン処理。
	 * @param req リクエスト内容。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public void firstOutputMain( RequestParameter req ) throws PageException{}

	private String file_name;

	/**
	 * 出力情報の設定を行う。
	 * @param from 遷移元ページ。直接呼ばれている場合はnullです。
	 * @param req リクエスト内容。
	 * @return 出力ページ。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public Page outputMain( Page from, RequestParameter req ) throws PageException {
		file_name = new File( req.getRelativeURI().getPath() ).getParent();
		if ( file_name.charAt( 0 ) == '/' )	file_name = file_name.substring( 1 );
		return this;
	}
	/**
	 * 出力コンテントタイプ。
	 * @return コンテントタイプ。
	 */
	public String getContentType() {
		return MimeType.getMimeType( file_name );
	}
	/**
	 * 更新日。
	 * @return 更新日。
	 */
	public HTTPDate getLastModified() {
		return Version.getLastModified( file_name );
	}
	/**
	 * 出力内容の取得。
	 * @return ストリーム。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public InputStream getInputStream() throws PageException {
		try {
			return Version.getResource( file_name );
		}
		catch( Exception e ) {
			throw new PageException( e );
		}
	}
	public NameDefine[] inspectName( Page page, String ... exclude ){ return null;}
}

