/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import java.io.File;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import paraselene.supervisor.PathData;
import paraselene.supervisor.RequestParameter;
import paraselene.supervisor.Supervisor;

public abstract class UploadableSupervisor
extends Supervisor {
    @Override
    RequestParameter parseRequest(HttpServletRequest request, PathData p) throws Exception {
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            return this.normalReq(request);
        }
        return this.fileReq(request, p);
    }

    private RequestParameter fileReq(HttpServletRequest req, PathData p) throws Exception {
        RequestParameter ret = new RequestParameter();
        DiskFileItemFactory fact = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)fact);
        int max = p.from.getUploadMaxBytes();
        if (max < 0) {
            max = -1;
        }
        upload.setSizeMax((long)max);
        upload.setHeaderEncoding(p.from.getCharset());
        List items = upload.parseRequest(req);
        for (Object o : items) {
            FileItem item = (FileItem)o;
            if (item.isFormField()) {
                ret.addItem(item.getFieldName(), item.getString(req.getCharacterEncoding()));
                continue;
            }
            File file = File.createTempFile("dog", null);
            file.deleteOnExit();
            item.write(file);
            String[] path = item.getName().split("[\\\\/]");
            ret.addItem(item.getFieldName(), path[path.length - 1], file, item.getContentType());
        }
        return ret;
    }
}

