/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.dyna;

/**
 * DynamicPage構築時のURI解決。
 * 解析中にURIを示す属性値が登場するとコールされます。
 */
public interface URIResolver {
	/**
	 * URI解決。次のようなものが呼び出されます。
	 * <ul>
	 * <li>img/back.jpg のような相対パス。正しいパスとなるよう返して下さい。
	 * <li>/page.css のような絶対パス。正しいパスとなるよう返して下さい。
	 * <li>http://www.host.com/next.cgi のような絶対パス。
	 * 通常はそのまま返せば良いでしょう。
	 * <li>mailto:user@mail.com のようなURLでないもの。
	 * 通常はそのまま返せば良いでしょう。
	 * </ul>
	 * 元のURIにエンコード文字列(%nn)が含まれている可能性があります。
	 * その場合はデコードした文字列を返して下さい。
	 * @param src 登場したURI文字列。
	 * @return 解決後のURI。これが設定されます。
	 * マルチバイト文字はそのまま渡して下さい。自動的にエンコードします。
	 */
	String resolve( String src );

	/**
	 * ParamタグのURI判定。
	 * Paramタグが登場すると、name属性値をこのメソッドに渡します。
	 * URIを表すnameであればtrueを返して下さい。
	 * @param name Paramタグname属性値。常に小文字に変換して渡します。
	 * @return true:URIを表す、false:URIではない。
	 */
	boolean isParamURIName( String name );
}

