/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.model;

import java.util.Calendar;
import java.util.Date;

import jp.sf.pal.blog.AbstractTestCase;
import jp.sf.pal.blog.dao.BlogMessageDao;
import junit.framework.Test;
import junit.framework.TestSuite;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.hibernate3.impl.S2SessionFactoryImpl;

public class BlogMessageTest extends AbstractTestCase
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(BlogMessageTest.class);

    public static Long testId = null;

    /* (non-Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception
    {
        if (log.isDebugEnabled())
        {
            log.debug("setUp() - start");
        }

        // TODO Auto-generated method stub
        super.setUp();

        if (log.isDebugEnabled())
        {
            log.debug("setUp() - end");
        }
    }

    /**
     * Create the test case
     *
     * @param testName name of the test case
     */
    public BlogMessageTest(String testName)
    {
        super(testName);
    }

    /**
     * @return the suite of tests being tested
     */
    public static Test suite()
    {
        if (log.isDebugEnabled())
        {
            log.debug("suite() - start");
        }

        TestSuite suite = new TestSuite();
        suite.addTest(new BlogMessageTest("addBlogMessage"));
        suite.addTest(new BlogMessageTest("deleteBlogMessage"));

        if (log.isDebugEnabled())
        {
            log.debug("suite() - end");
        }
        return suite;
    }

    public void addBlogMessage()
    {
        if (log.isDebugEnabled())
        {
            log.debug("addBlogmessage() - start");
        }

        SingletonS2ContainerFactory.setConfigPath("jp/sf/pal/blog/Blog.dicon");
        SingletonS2ContainerFactory.init();
        S2Container container = SingletonS2ContainerFactory.getContainer();

        BlogMessageDao blogMessageDao = (BlogMessageDao) container.getComponent(BlogMessageDao.class);

        BlogMessage blogMsg = new BlogMessage();
        blogMsg.setOwner("testuser");
        Date now = Calendar.getInstance().getTime();
        blogMsg.setCreatedtime(now);
        blogMsg.setUpdatedtime(now);
        blogMsg.setFormattype("TEXT");
        blogMsg.setTitle("TITLE");
        blogMsg.setMessage("FOO foo Foo!");

        blogMessageDao.save(blogMsg);

        testId = blogMsg.getId();

        SingletonS2ContainerFactory.destroy();

        assertNotNull(testId);

        if (log.isDebugEnabled())
        {
            log.debug("addBlogmessage() - end");
        }
    }

    public void deleteBlogMessage()
    {
        if (log.isDebugEnabled())
        {
            log.debug("deleteStatistics() - start");
        }

        SingletonS2ContainerFactory.setConfigPath("jp/sf/pal/blog/Blog.dicon");
        SingletonS2ContainerFactory.init();
        S2Container container = SingletonS2ContainerFactory.getContainer();

        BlogMessageDao blogMessageDao = (BlogMessageDao) container.getComponent(BlogMessageDao.class);
        S2SessionFactoryImpl s2SessionFactory = (S2SessionFactoryImpl) SingletonS2ContainerFactory.getContainer()
                .getComponent(S2SessionFactoryImpl.class);

        BlogMessage blogMsg = blogMessageDao.getBlogMessageById(testId.longValue());

        blogMessageDao.delete(blogMsg);

        s2SessionFactory.getSession().flush();

        assertNull(blogMessageDao.getBlogMessageById(testId.longValue()));

        SingletonS2ContainerFactory.destroy();

        if (log.isDebugEnabled())
        {
            log.debug("deleteStatistics() - end");
        }
    }
}
