/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.util;

import jp.sf.pal.blog.BlogRuntimeException;
import jp.sf.pal.blog.dao.BlogCategoryDao;
import jp.sf.pal.blog.dao.BlogCommentDao;
import jp.sf.pal.blog.dao.BlogMessageDao;
import jp.sf.pal.blog.dao.BlogTrackbackDao;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

public class BlogDaoUtil
{
    public static BlogCategoryDao getBlogCategoryDao() throws BlogRuntimeException
    {
        S2Container container = SingletonS2ContainerFactory.getContainer();

        return getBlogCategoryDao(container);
    }

    public static BlogCategoryDao getBlogCategoryDao(S2Container container) throws BlogRuntimeException
    {
        BlogCategoryDao btaDao = (BlogCategoryDao) container.getComponent(BlogCategoryDao.class);
        if (btaDao == null)
        {
            throw new BlogRuntimeException("BlogCategoryDao is null. Check the configuration for S2Container.");
        }
        return btaDao;
    }

    public static BlogCommentDao getBlogCommentDao() throws BlogRuntimeException
    {
        S2Container container = SingletonS2ContainerFactory.getContainer();

        return getBlogCommentDao(container);
    }

    public static BlogCommentDao getBlogCommentDao(S2Container container) throws BlogRuntimeException
    {
        BlogCommentDao bcoDao = (BlogCommentDao) container.getComponent(BlogCommentDao.class);
        if (bcoDao == null)
        {
            throw new BlogRuntimeException("BlogCommentDao is null. Check the configuration for S2Container.");
        }
        return bcoDao;
    }

    public static BlogMessageDao getBlogMessageDao() throws BlogRuntimeException
    {
        S2Container container = SingletonS2ContainerFactory.getContainer();

        return getBlogMessageDao(container);
    }

    public static BlogMessageDao getBlogMessageDao(S2Container container) throws BlogRuntimeException
    {
        BlogMessageDao bmDao = (BlogMessageDao) container.getComponent(BlogMessageDao.class);
        if (bmDao == null)
        {
            throw new BlogRuntimeException("BlogMessageDao is null. Check the configuration for S2Container.");
        }
        return bmDao;
    }

    public static BlogTrackbackDao getBlogTrackbackDao() throws BlogRuntimeException
    {
        S2Container container = SingletonS2ContainerFactory.getContainer();

        return getBlogTrackbackDao(container);
    }

    public static BlogTrackbackDao getBlogTrackbackDao(S2Container container) throws BlogRuntimeException
    {
        BlogTrackbackDao btDao = (BlogTrackbackDao) container.getComponent(BlogTrackbackDao.class);
        if (btDao == null)
        {
            throw new BlogRuntimeException("BlogTrackbackDao is null. Check the configuration for S2Container.");
        }
        return btDao;
    }

}
