/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.model.hatena;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.digester.BeanPropertySetterRule;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreateRule;
import org.apache.commons.digester.SetNextRule;
import org.apache.commons.digester.SetPropertiesRule;
import org.xml.sax.SAXException;

public class HatenaUtil
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(HatenaUtil.class);

    public static Diary parse(String filePath) throws FileNotFoundException
    {
        return parse(new FileInputStream(filePath));
    }

    public static Diary parse(File file) throws FileNotFoundException
    {
        return parse(new FileInputStream(file));
    }

    public static Diary parse(InputStream io)
    {
        Digester digester = new Digester();

        digester.addRule("diary", new ObjectCreateRule(Diary.class));
        digester.addRule("diary", new SetPropertiesRule());

        digester.addRule("diary/day", new ObjectCreateRule(Day.class));
        digester.addRule("diary/day", new SetPropertiesRule());
        digester.addRule("diary/day/body", new BeanPropertySetterRule("body"));

        digester.addRule("diary/day", new SetNextRule("addDay"));

        digester.addRule("diary/day/comments/comment", new ObjectCreateRule(Comment.class));
        digester.addRule("diary/day/comments/comment/username", new BeanPropertySetterRule("username"));
        digester.addRule("diary/day/comments/comment/body", new BeanPropertySetterRule("body"));
        digester.addRule("diary/day/comments/comment/timestamp", new BeanPropertySetterRule("timestamp"));

        digester.addRule("diary/day/comments/comment", new SetNextRule("addComment"));

        try
        {
            return (Diary) digester.parse(io);
        }
        catch (IOException e)
        {
            log.error(e);
        }
        catch (SAXException e)
        {
            log.error(e);
        }

        return null;
    }
}
