/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.bean;

import java.io.IOException;

import jp.sf.pal.blog.BlogConstants;

import com.marevol.utils.portlet.faces.PortletConfigUtil;
import com.marevol.utils.portlet.faces.PortletPreferencesUtil;

public class BlogViewSessionBean
{
    private Boolean commentEnabled;

    private Boolean trackbackEnabled;

    public BlogViewSessionBean()
    {
        super();
        String ce = PortletConfigUtil.getInitParameter(BlogConstants.COMMENT_ENABLED);
        if (ce.equalsIgnoreCase("true") || ce.equalsIgnoreCase("yes"))
        {
            commentEnabled = Boolean.TRUE;
        }
        else
        {
            commentEnabled = Boolean.FALSE;
        }
        String te = PortletConfigUtil.getInitParameter(BlogConstants.TRACKBACK_ENABLED);
        if (te.equalsIgnoreCase("true") || te.equalsIgnoreCase("yes"))
        {
            trackbackEnabled = Boolean.TRUE;
        }
        else
        {
            trackbackEnabled = Boolean.FALSE;
        }
    }

    /**
     * @return Returns the pageSize.
     */
    public Integer getPageSize()
    {

        return new Integer(PortletPreferencesUtil.getValue(BlogConstants.VIEW_PAGE_SIZE, Integer
                .toString(BlogConstants.DEFAULT_PAGE_SIZE)));
    }

    /**
     * @param pageSize The pageSize to set.
     */
    public void setPageSize(Integer maxResults) throws IOException
    {

        PortletPreferencesUtil.setValue(BlogConstants.VIEW_PAGE_SIZE, maxResults.toString());

    }

    /**
     * @return Returns the owner.
     */
    public String getOwner()
    {

        return PortletPreferencesUtil.getValue(BlogConstants.VIEW_OWNER, "");
    }

    /**
     * @param owner The owner to set.
     */
    public void setOwner(String owner) throws IOException
    {

        PortletPreferencesUtil.setValue(BlogConstants.VIEW_OWNER, owner);

    }

    /**
     * @return Returns the commentEnabled.
     */
    public Boolean getCommentEnabled()
    {
        return commentEnabled;
    }

    /**
     * @param commentEnabled The commentEnabled to set.
     */
    public void setCommentEnabled(Boolean commentEnabled)
    {
        this.commentEnabled = commentEnabled;
    }

    /**
     * @return Returns the trackbackEnabled.
     */
    public Boolean getTrackbackEnabled()
    {
        return trackbackEnabled;
    }

    /**
     * @param trackbackEnabled The trackbackEnabled to set.
     */
    public void setTrackbackEnabled(Boolean trackbackEnabled)
    {
        this.trackbackEnabled = trackbackEnabled;
    }
}
