package jp.sf.pal.blog.bean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

import jp.sf.pal.blog.BlogConstants;
import jp.sf.pal.blog.model.hatena.HatenaImporter;

import org.apache.myfaces.custom.fileupload.UploadedFile;

import com.marevol.utils.faces.application.FacesMessageUtil;

public class BlogMigrationPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(BlogMigrationPageBean.class);

    private String formattype;

    private UploadedFile uploadedFile;

    public String importFile()
    {
        if (log.isDebugEnabled())
        {
            log.debug("importFile() - start ");
            log.debug("importFile() - getUploadedFile()=" + getUploadedFile());
        }

        try
        {
            if (getUploadedFile() != null && getUploadedFile().getInputStream() != null)
            {
                File importFile = File.createTempFile("export", ".xml");

                BufferedInputStream bis = null;
                BufferedOutputStream bos = null;
                try
                {
                    bis = new BufferedInputStream(getUploadedFile().getInputStream());
                    bos = new BufferedOutputStream(new FileOutputStream(importFile));

                    byte buf[] = new byte[256];
                    int len;
                    while ((len = bis.read(buf)) != -1)
                    {
                        bos.write(buf, 0, len);
                    }
                }
                catch (FileNotFoundException e)
                {
                    log.error("importFile()", e);

                    //TODO i18n
                    FacesMessageUtil.addErrorMessage("System error occurred.", e.toString());

                    if (log.isDebugEnabled())
                    {
                        log.debug("importFile() - end");
                    }
                    return null;
                }
                catch (IOException e)
                {
                    log.error("importFile()", e);

                    //TODO i18n
                    FacesMessageUtil.addErrorMessage("System error occurred.", e.toString());

                    if (log.isDebugEnabled())
                    {
                        log.debug("importFile() - end");
                    }
                    return null;
                }
                finally
                {
                    try
                    {
                        if (bos != null)
                        {
                            bos.flush();
                            bos.close();
                        }
                    }
                    catch (IOException e)
                    {
                        log.error("importFile()", e);

                        //TODO i18n
                        FacesMessageUtil.addErrorMessage("System error occurred.", e.toString());

                        if (log.isDebugEnabled())
                        {
                            log.debug("importFile() - end");
                        }
                        return null;
                    }
                    try
                    {
                        if (bis != null)
                        {
                            bis.close();
                        }
                    }
                    catch (IOException e)
                    {
                        log.error("importFile()", e);

                        //TODO i18n
                        FacesMessageUtil.addErrorMessage("System error occurred.", e.toString());

                        if (log.isDebugEnabled())
                        {
                            log.debug("importFile() - end");
                        }
                        return null;
                    }
                }

                String username = FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
                if (username != null)
                {
                    HatenaImporter importer = new HatenaImporter(importFile, username);
                    importer.start();

                    //TODO i18n
                    FacesMessageUtil.addInfoMessage("Start importing..");
                }
                else
                {
                    //TODO i18n
                    FacesMessageUtil.addErrorMessage("Unknown user.");

                    if (log.isDebugEnabled())
                    {
                        log.debug("importFile() - end");
                    }
                    return null;
                }
            }
            else
            {
                // uploaded file is null
                //TODO i18n
                FacesMessageUtil.addErrorMessage("The uploaded file is null.");
            }
        }
        catch (IOException e)
        {
            log.error("importFile()", e);

            //TODO i18n
            FacesMessageUtil.addErrorMessage("The upload process might fail.");
        }

        if (log.isDebugEnabled())
        {
            log.debug("importFile() - end");
        }
        return null;
    }

    /**
     * @return Returns the formattype.
     */
    public String getFormattype()
    {
        if (formattype == null)
        {
            return BlogConstants.HATENA_FORMAT_TYPE;
        }
        return formattype;
    }

    /**
     * @param formattype The formattype to set.
     */
    public void setFormattype(String format)
    {
        this.formattype = format;
    }

    /**
     * @return Returns the uploadedFile.
     */
    public UploadedFile getUploadedFile()
    {
        return uploadedFile;
    }

    /**
     * @param uploadedFile The uploadedFile to set.
     */
    public void setUploadedFile(UploadedFile uploadedFile)
    {
        this.uploadedFile = uploadedFile;
    }

    public SelectItem[] getFormattypeItems()
    {
        //TODO i18n
        return new SelectItem[] { new SelectItem(BlogConstants.HATENA_FORMAT_TYPE, "Hatena") };
    }
}
