/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.bean;

import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.Map;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;

import jp.sf.pal.blog.BlogConstants;
import jp.sf.pal.blog.model.BlogComment;
import jp.sf.pal.blog.util.BlogMessaging;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.marevol.utils.hibernate.faces.model.S2HibernateDataModel;

public class BlogCommentTitleViewPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(BlogCommentTitleViewPageBean.class);

    private BlogCommentTitleViewSessionBean commentTitleViewSession;

    public BlogCommentTitleViewPageBean()
    {
    }

    public String select()
    {
        if (log.isDebugEnabled())
        {
            log.debug("select() - start");
        }

        ExternalContext exContext = FacesContext.getCurrentInstance().getExternalContext();
        Map map = exContext.getRequestMap();
        Map blogMap = (Map) map.get("blogComment");
        BlogComment blogMsg = (BlogComment) blogMap.get("0");
        if (blogMsg != null)
        {
            try
            {
                BlogMessaging.publishToAll(BlogConstants.BLOG_MESSAGE_ID, blogMsg.getBlogMessage().getId());
            }
            catch (NotSerializableException e)
            {
                log.error(e);
            }
            catch (ClassCastException e)
            {
                log.error(e);
            }
        }
        else
        {
            log.error("Selected BlogMessage is null.");
        }

        if (log.isDebugEnabled())
        {
            log.debug("select() - end");
        }
        return null;
    }

    private String getSortColumn()
    {
        String column = getCommentTitleViewSession().getSortColumn();
        if (log.isDebugEnabled())
        {
            log.debug("getSortColumn() -  : column=" + column);
        }
        if (column.equalsIgnoreCase(BlogComment.CREATEDTIME))
        {
            return "comment." + BlogComment.CREATEDTIME;
            //        }
            //        else if (column.equalsIgnoreCase(BlogMessage.UPDATEDTIME))
            //        {
            //            return "msg." + BlogMessage.UPDATEDTIME;
        }

        if (log.isDebugEnabled())
        {
            log.debug("getSortColumn() - : column does not match..");
        }
        return "comment." + BlogComment.CREATEDTIME;
    }

    // Getter and Setter

    /**
     * @return Returns the commentTitleViewSession.
     */
    public BlogCommentTitleViewSessionBean getCommentTitleViewSession()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getTitleViewPortlet() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getTitleViewPortlet() - end");
        }
        return commentTitleViewSession;
    }

    /**
     * @param commentTitleViewSession The commentTitleViewSession to set.
     */
    public void setCommentTitleViewSession(BlogCommentTitleViewSessionBean titleViewPortlet)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setTitleViewPortlet(BlogCommentTitleViewSessionBean) - start");
        }

        this.commentTitleViewSession = titleViewPortlet;

        if (log.isDebugEnabled())
        {
            log.debug("setTitleViewPortlet(BlogCommentTitleViewSessionBean) - end");
        }
    }

    /**
     * @return Returns the blogMessages.
     */
    public DataModel getBlogComments()
    {
        StringBuffer query = new StringBuffer("select comment from BlogComment comment ");
        String param = "where ";
        ArrayList paramList = new ArrayList();

        if (!getCommentTitleViewSession().getOwner().equals(""))
        {
            query.append(param);
            query.append("comment.blogMessage.owner = ? ");
            param = "and ";
            paramList.add(getCommentTitleViewSession().getOwner());
        }

        String sortColumn = getSortColumn();
        if (sortColumn != null && !sortColumn.equals(""))
        {
            query.append("order by " + getSortColumn() + " desc");
        }

        if (log.isDebugEnabled())
        {
            log.debug("query=" + query.toString());
        }

        Object[] params = new Object[paramList.size()];
        for (int i = 0; i < paramList.size(); i++)
        {
            params[i] = paramList.get(i);
        }

        return new S2HibernateDataModel(query.toString(), params);
    }

}
