/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.hsqldb.lib.java.JavaSystem;

public class FileUtil {
    public static final boolean fsIsIgnoreCase = new File("A").equals(new File("a"));
    public static final boolean fsNormalizesPosixSeparator = new File("/").getPath().endsWith(File.separator);
    static final Random random = new Random(System.currentTimeMillis());

    public static void delete(String string) throws IOException {
        try {
            new File(string).delete();
        }
        catch (Throwable throwable) {
            throw FileUtil.toIOException(throwable);
        }
    }

    public static void deleteOnExit(File file) {
        JavaSystem.deleteOnExit(file);
    }

    public static boolean exists(String string) {
        return new File(string).exists();
    }

    public static boolean exists(String string, boolean bl, Class clazz) throws IOException {
        if (string == null || string.length() == 0) {
            return false;
        }
        return bl ? null != clazz.getResource(string) : FileUtil.exists(string);
    }

    public static void renameOverwrite(String string, String string2) throws IOException {
        try {
            if (FileUtil.exists(string)) {
                FileUtil.delete(string2);
                File file = new File(string);
                file.renameTo(new File(string2));
            }
        }
        catch (Throwable throwable) {
            throw FileUtil.toIOException(throwable);
        }
    }

    static IOException toIOException(Throwable throwable) {
        if (throwable instanceof IOException) {
            return (IOException)throwable;
        }
        return new IOException(throwable.getMessage());
    }

    public static String absolutePath(String string) {
        return new File(string).getAbsolutePath();
    }

    public static File canonicalFile(File file) throws IOException {
        return new File(file.getCanonicalPath());
    }

    public static File canonicalFile(String string) throws IOException {
        return new File(new File(string).getCanonicalPath());
    }

    public static String canonicalPath(File file) throws IOException {
        return file.getCanonicalPath();
    }

    public static String canonicalPath(String string) throws IOException {
        return new File(string).getCanonicalPath();
    }

    public static String canonicalOrAbsolutePath(String string) {
        try {
            return FileUtil.canonicalPath(string);
        }
        catch (Exception exception) {
            return FileUtil.absolutePath(string);
        }
    }
}

