/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.CachedRow;
import org.hsqldb.HsqlException;
import org.hsqldb.Node;
import org.hsqldb.PointerNode;
import org.hsqldb.Row;
import org.hsqldb.Table;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

class CachedDataRow
extends CachedRow {
    CachedDataRow(Table table, Object[] objectArray) throws HsqlException {
        super(table, objectArray);
        Node node = this.nPrimaryNode;
        while (node != null) {
            ((PointerNode)node).iData = this.iPos;
            node = node.nNext;
        }
    }

    CachedDataRow(Table table, RowInputInterface rowInputInterface) throws IOException, HsqlException {
        this.tTable = table;
        this.iPos = rowInputInterface.getPos();
        this.storageSize = rowInputInterface.getSize();
        this.oData = rowInputInterface.readData(this.tTable.getColumnTypes(), this.tTable.columnCount);
        this.setPos(this.iPos);
    }

    Row getUpdatedRow() throws HsqlException {
        return this.tTable.getRow(this.iPos, this.nPrimaryNode);
    }

    void setNewNodes() {
        int n = this.tTable.getIndexCount();
        Node node = this.nPrimaryNode = Node.newNode(this, 0, this.tTable);
        for (int i = 1; i < n; ++i) {
            node = node.nNext = Node.newNode(this, i, this.tTable);
        }
    }

    void setPrimaryNode(Node node) {
        this.nPrimaryNode = node;
    }

    void write(RowOutputInterface rowOutputInterface) throws IOException, HsqlException {
        rowOutputInterface.writeSize(this.storageSize);
        rowOutputInterface.writeData(this.oData, this.tTable);
        rowOutputInterface.writeEnd();
        this.hasChanged = false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof CachedDataRow)) {
            return false;
        }
        return ((CachedDataRow)object).iPos == this.iPos && ((CachedDataRow)object).tTable == this.tTable;
    }
}

