c     Kernel function for default format
      real*8 function Kernel(M,x,y)
      use kernel_params
      implicit real*8(a-h,o-z)

      integer M
      real*8  x(M),y(M),d

#ifdef Linear
      Kernel=ddot(M,x,1,y,1)
#else
      d=0.d0
      do i=1,M
        d=d+(x(i)-y(i))*(x(i)-y(i))
      end do
      Kernel=exp(-gamma*d)
#endif
      
      return
      end

c     Kernel function for sparse format
      real*8 function Kernel_s(nx,x,px,mx,ny,y,py,my,imax)
      use kernel_params
      implicit real*8(a-h,o-z)

      integer M,mx,my,imax,lx,ly
      integer px(nx),py(ny)
      real*8  x(nx),y(ny),d

      d=0.d0
      lx=1
      ly=1
#ifdef Linear
      do while (lx .le. mx .or. ly .le. my)
        if (lx .gt. mx) then
          ly=ly+1
        else if (ly .gt. my) then
          lx=lx+1
        else 
          if (px(lx) .lt. py(ly)) then
            lx=lx+1
          else if (px(lx) .eq. py(ly)) then
            d=d+x(lx)*y(ly)
            lx=lx+1
            ly=ly+1
          else if (px(lx) .gt. py(ly)) then
            ly=ly+1
          end if
        end if
      end do
      Kernel_s=d
#else
      do while (lx .le. mx .or. ly .le. my)
        if (lx .gt. mx) then
          d=d+y(ly)*y(ly)
          ly=ly+1
        else if (ly .gt. my) then
          d=d+x(lx)*x(lx)
          lx=lx+1
        else 
          if (px(lx) .lt. py(ly)) then
            d=d+x(lx)*x(lx)
            lx=lx+1
          else if (px(lx) .eq. py(ly)) then
            d=d+(x(lx)-y(ly))*(x(lx)-y(ly))
            lx=lx+1
            ly=ly+1
          else if (px(lx) .gt. py(ly)) then
            d=d+y(ly)*y(ly)
            ly=ly+1
          end if
        end if
      end do
      Kernel_s=exp(-gamma*d)
#endif

      return
      end
      
