/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.handlers;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import jp.sf.orangesignal.csv.CsvReader;
import jp.sf.orangesignal.csv.CsvWriter;
import jp.sf.orangesignal.csv.handlers.BeanListHandlerSupport;

public class ColumnPositionMappingBeanListHandler<T>
extends BeanListHandlerSupport<T> {
    private SortedMap<Integer, String> positionMap = new TreeMap<Integer, String>();

    public ColumnPositionMappingBeanListHandler(Class<T> type) {
        super(type);
    }

    public ColumnPositionMappingBeanListHandler<T> addColumn(String field) {
        return this.addColumn(this.getMaxColumnPosition() + 1, field);
    }

    public ColumnPositionMappingBeanListHandler<T> addColumn(int position, String field) {
        this.positionMap.put(position, field);
        return this;
    }

    public ColumnPositionMappingBeanListHandler<T> columnMapping(Map<Integer, String> columnMapping) {
        if (columnMapping == null) {
            throw new IllegalArgumentException("Column mapping must not be null");
        }
        this.positionMap = new TreeMap<Integer, String>(columnMapping);
        return this;
    }

    private String getFieldName(int columnPosition) {
        return (String)this.positionMap.get(columnPosition);
    }

    private int getColumnPosition(String fieldName) {
        for (Map.Entry<Integer, String> e : this.positionMap.entrySet()) {
            if (!fieldName.equals(e.getValue())) continue;
            return e.getKey();
        }
        return -1;
    }

    private int getMaxColumnPosition() {
        if (this.positionMap.size() > 0) {
            return this.positionMap.lastKey();
        }
        return -1;
    }

    @Override
    public List<T> load(CsvReader reader) throws IOException {
        List<String> values;
        if (this.positionMap.size() == 0) {
            List<String> columnNames = reader.readValues();
            if (columnNames == null) {
                throw new IOException("No header is available");
            }
            for (String name : columnNames) {
                this.addColumn(name);
            }
        }
        ArrayList results = new ArrayList();
        while ((values = reader.readValues()) != null) {
            Object obj = this.createBean();
            int len = values.size();
            for (int pos = 0; pos < len; ++pos) {
                String fieldName = this.getFieldName(pos);
                if (fieldName == null) continue;
                Field f = ColumnPositionMappingBeanListHandler.getField(this.getType(), fieldName);
                Object o = this.getConverter().convert(values.get(pos), f.getType());
                if (o == null) continue;
                ColumnPositionMappingBeanListHandler.setFieldValue(obj, f, o);
            }
            results.add(obj);
        }
        return results;
    }

    @Override
    public void save(List<T> list, CsvWriter writer) throws IOException {
        if (this.positionMap.size() == 0) {
            for (Field f : this.getType().getDeclaredFields()) {
                this.addColumn(f.getName());
            }
        }
        int columnCount = this.getMaxColumnPosition() + 1;
        String[] names = new String[columnCount];
        for (Map.Entry<Integer, String> e : this.positionMap.entrySet()) {
            names[e.getKey().intValue()] = e.getValue();
        }
        writer.writeValues(Arrays.asList(names));
        for (Map.Entry<Integer, String> obj : list) {
            if (obj == null) {
                writer.writeValues(null);
                continue;
            }
            String[] values = new String[columnCount];
            for (Field f : obj.getClass().getDeclaredFields()) {
                int pos = this.getColumnPosition(f.getName());
                if (pos == -1) continue;
                values[pos] = this.getConverter().convert(ColumnPositionMappingBeanListHandler.getFieldValue(obj, f));
            }
            writer.writeValues(Arrays.asList(values));
        }
    }
}

