/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.handlers;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.sf.orangesignal.csv.CsvReader;
import jp.sf.orangesignal.csv.CsvWriter;
import jp.sf.orangesignal.csv.handlers.BeanListHandlerSupport;

public class ColumnNameMappingBeanListHandler<T>
extends BeanListHandlerSupport<T> {
    private LinkedHashMap<String, String> nameMap = new LinkedHashMap();

    public ColumnNameMappingBeanListHandler(Class<T> type) {
        super(type);
    }

    public ColumnNameMappingBeanListHandler<T> addColumn(String column, String field) {
        this.nameMap.put(column, field);
        return this;
    }

    public ColumnNameMappingBeanListHandler<T> columnMapping(Map<String, String> columnMapping) {
        if (columnMapping == null) {
            throw new IllegalArgumentException("Column mapping must not be null");
        }
        this.nameMap = new LinkedHashMap<String, String>(columnMapping);
        return this;
    }

    private String getFieldName(String column) {
        return this.nameMap.get(column);
    }

    @Override
    public List<T> load(CsvReader reader) throws IOException {
        List<String> values;
        this.prepare();
        List<String> columnNames = reader.readValues();
        if (columnNames == null) {
            throw new IOException("No header is available");
        }
        ArrayList results = new ArrayList();
        int columnCount = columnNames.size();
        while ((values = reader.readValues()) != null) {
            Object obj = this.createBean();
            int len = Math.min(columnCount, values.size());
            for (int pos = 0; pos < len; ++pos) {
                String fieldName = this.getFieldName(columnNames, pos);
                if (fieldName == null) continue;
                Field f = ColumnNameMappingBeanListHandler.getField(this.getType(), fieldName);
                Object o = this.getConverter().convert(values.get(pos), f.getType());
                if (o == null) continue;
                ColumnNameMappingBeanListHandler.setFieldValue(obj, f, o);
            }
            results.add(obj);
        }
        return results;
    }

    @Override
    public void save(List<T> list, CsvWriter writer) throws IOException {
        this.prepare();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.nameMap.entrySet()) {
            columnNames.add(entry.getKey());
        }
        writer.writeValues(columnNames);
        int columnCount = columnNames.size();
        for (T obj : list) {
            if (obj == null) {
                writer.writeValues(null);
                continue;
            }
            String[] values = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                String fieldName = this.getFieldName(columnNames, i);
                if (fieldName == null) continue;
                Field f = ColumnNameMappingBeanListHandler.getField(obj.getClass(), fieldName);
                values[i] = this.getConverter().convert(ColumnNameMappingBeanListHandler.getFieldValue(obj, f));
            }
            writer.writeValues(Arrays.asList(values));
        }
    }

    private void prepare() {
        if (this.nameMap.size() == 0) {
            for (Field f : this.getType().getDeclaredFields()) {
                String name = f.getName();
                this.addColumn(name, name);
            }
        }
    }

    private String getFieldName(List<String> columnNames, int position) {
        String columnName = columnNames.get(position);
        if (columnName != null) {
            return this.getFieldName(columnName);
        }
        return null;
    }
}

