/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.handlers;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.sf.orangesignal.csv.CsvReader;
import jp.sf.orangesignal.csv.CsvWriter;
import jp.sf.orangesignal.csv.handlers.BeanListHandlerSupport;

public class BeanListHandler<T>
extends BeanListHandlerSupport<T> {
    private String[] includeNames;
    private String[] excludeNames;

    public BeanListHandler(Class<T> type) {
        super(type);
    }

    public BeanListHandler<T> includes(String ... names) {
        if (this.excludeNames != null && this.excludeNames.length > 0) {
            throw new IllegalArgumentException("Only includes or excludes may be specified.");
        }
        this.includeNames = names;
        return this;
    }

    public BeanListHandler<T> excludes(String ... names) {
        if (this.includeNames != null && this.includeNames.length > 0) {
            throw new IllegalArgumentException("Only includes or excludes may be specified.");
        }
        this.excludeNames = names;
        return this;
    }

    private boolean isTargetName(String name) {
        if (this.excludeNames != null && this.excludeNames.length > 0) {
            for (String propertyName : this.excludeNames) {
                if (!propertyName.equals(name)) continue;
                return false;
            }
            return true;
        }
        if (this.includeNames != null && this.includeNames.length > 0) {
            for (String propertyName : this.includeNames) {
                if (!propertyName.equals(name)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public List<T> load(CsvReader reader) throws IOException {
        List<String> values;
        List<String> columnNames = reader.readValues();
        if (columnNames == null) {
            throw new IOException("No header is available");
        }
        ArrayList results = new ArrayList();
        int columnCount = columnNames.size();
        while ((values = reader.readValues()) != null) {
            Object obj = this.createBean();
            int len = Math.min(columnCount, values.size());
            for (int pos = 0; pos < len; ++pos) {
                String name = columnNames.get(pos);
                if (!this.isTargetName(name)) continue;
                Field f = BeanListHandler.getField(this.getType(), name);
                Object o = this.getConverter().convert(values.get(pos), f.getType());
                if (o == null) continue;
                BeanListHandler.setFieldValue(obj, f, o);
            }
            results.add(obj);
        }
        return results;
    }

    @Override
    public void save(List<T> list, CsvWriter writer) throws IOException {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Field f : this.getType().getDeclaredFields()) {
            String name = f.getName();
            if (!this.isTargetName(name)) continue;
            columnNames.add(name);
        }
        writer.writeValues(columnNames);
        int columnCount = columnNames.size();
        for (T obj : list) {
            if (obj == null) {
                writer.writeValues(null);
                continue;
            }
            String[] values = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                String name = (String)columnNames.get(i);
                if (name == null) continue;
                Field f = BeanListHandler.getField(obj.getClass(), name);
                values[i] = this.getConverter().convert(BeanListHandler.getFieldValue(obj, f));
            }
            writer.writeValues(Arrays.asList(values));
        }
    }
}

