/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.trading.strategy.systems;

import static jp.sf.orangesignal.ta.TechnicalAnalysis.lowest;
import static jp.sf.orangesignal.trading.order.OrderTiming.NEXT_STOP;
import jp.sf.orangesignal.ta.result.FourPrice;
import jp.sf.orangesignal.trading.strategy.TradingStrategySupport;

public class ChannelBreakoutShortEntry extends TradingStrategySupport {

	/**
	 * 4本値の種類を保持します。
	 */
	private FourPrice price = FourPrice.LOW;

	/**
	 * 4本値の種類を返します。
	 * 
	 * @return 4本値の種類
	 */
	public FourPrice getPrice() { return price; }

	/**
	 * 4本値の種類を設定します。
	 * 
	 * @param price 4本値の種類
	 */
	public void setPrice(final FourPrice price) { this.price = price; }

	/**
	 * 期間を保持します。
	 */
	private int period = 20;

	/**
	 * 期間を返します。
	 * 
	 * @return 期間
	 */
	public int getPeriod() { return period; }

	/**
	 * 期間を設定します。
	 * 
	 * @param period 期間
	 */
	public void setPeriod(final int period) { this.period = period; }

	// ----------------------------------------------------------------------

	protected Number[] lowest;

	@Override
	public void prepare() {
		this.lowest = lowest(getDataset().getTechnicalPrice(this.price), this.period);
	}

	@Override
	public boolean execute() {
		final int i = getCurrentDataIndex();
		if (lowest[i] != null)
			sellShort(getStrategyName(), NEXT_STOP, lowest[i].doubleValue() - 1);
		return false;
	}

	@Override
	public void close() {
		this.lowest = null;
	}

}
