/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.trading.order;

import java.util.Date;

/**
 * 注文情報の基底のインターフェースを提供します。
 * 
 * @author 杉澤 浩二
 */
public interface Order extends Comparable<Order> {

	/**
	 * シンボルを返します。
	 * 
	 * @return シンボル
	 */
	public String getSymbol();

	/**
	 * 注文の種類を返します。
	 * 
	 * @return 注文の種類
	 */
	public OrderType getOrderType();

	/**
	 * ラベルを返します。
	 * 
	 * @return ラベル。又は <code>null</code>
	 */
	public String getLabel();

	/**
	 * 注文日時を返します。
	 * 
	 * @return 注文日時
	 */
	public Date getDate();

	/**
	 * 注文数量を返します。
	 * 
	 * @return 注文数量。デフォルトの数量の場合は <code>0</code>
	 */
	public int getQuantity();

	/**
	 * 決済注文IDを返します。
	 * 
	 * @return 決済注文ID。又は <code>null</code>
	 */
	public Integer getFindId();

	/**
	 * 決済注文ラベルを返します。
	 * 
	 * @return 決済注文ラベル。又は <code>null</code>
	 */
	public String getFindLabel();

	/**
	 * <p>注文日時から実際に注文が受付けられる日時までの期間を返します。</p>
	 * 実装は必ず <code>0</code> 以上の値を返す必要があります。
	 * 
	 * @return 期間
	 */
	public int getPeriod();

}
