/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.trading.stats;

import java.util.LinkedList;
import jp.sf.orangesignal.trading.Position;
import jp.sf.orangesignal.trading.stats.AbstractStats;

public abstract class WinLossStats
extends AbstractStats {
    private static final long serialVersionUID = 1L;
    protected AbstractStats winStats;
    protected AbstractStats lossStats;

    protected WinLossStats() {
    }

    public WinLossStats(LinkedList<Position> positions, double initialCapital, boolean discard) {
        this.statistics(positions, initialCapital, discard);
    }

    @Override
    protected void statistics(LinkedList<Position> positions, double initialCapital, boolean discard) {
        super.statistics(positions, initialCapital, discard);
        final WinLossStats parent = this;
        this.winStats = new AbstractStats(positions, initialCapital, discard){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean isStatistics(Position p) {
                return parent.isStatistics(p) && p.getNetProfit() > 0.0;
            }
        };
        this.lossStats = new AbstractStats(positions, initialCapital, discard){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean isStatistics(Position p) {
                return parent.isStatistics(p) && p.getNetProfit() <= 0.0;
            }
        };
    }

    public AbstractStats getWinStats() {
        return this.winStats;
    }

    public AbstractStats getLossStats() {
        return this.lossStats;
    }

    public int getMaxWinPeriod() {
        return this.winStats.getMaxHold();
    }

    public int getMaxLossPeriod() {
        return this.lossStats.getMaxHold();
    }

    public double getAverageWinPeriod() {
        return this.winStats.getAverageHold();
    }

    public double getAverageLossPeriod() {
        return this.lossStats.getAverageHold();
    }

    public double getGrossProfit() {
        return this.winStats.getNetProfit();
    }

    public double getPercentGrossProfit() {
        return this.getPercent(this.getGrossProfit());
    }

    public double getGrossLoss() {
        return this.lossStats.getNetProfit();
    }

    public double getPercentGrossLoss() {
        return this.getPercent(this.getGrossLoss());
    }

    public double getAdjustedNetProfit() {
        return this.getAdjustedGrossProfit() + this.getAdjustedGrossLoss();
    }

    public double getPercentAdjustedNetProfit() {
        return this.getPercent(this.getAdjustedNetProfit());
    }

    public double getAdjustedGrossProfit() {
        int count = this.winStats.getCount();
        return ((double)count - Math.sqrt(count)) * this.winStats.getAverageNetProfit();
    }

    public double getPercentAdjustedGrossProfit() {
        return this.getPercent(this.getAdjustedGrossProfit());
    }

    public double getAdjustedGrossLoss() {
        int count = this.lossStats.getCount();
        return ((double)count + Math.sqrt(count)) * this.lossStats.getAverageNetProfit();
    }

    public double getPercentAdjustedGrossLoss() {
        return this.getPercent(this.getAdjustedGrossLoss());
    }

    public double getAverageGrossProfit() {
        return this.winStats.getAverageNetProfit();
    }

    public double getAverageGrossLoss() {
        return this.lossStats.getAverageNetProfit();
    }

    public double getPayoffRatio() {
        double profit = this.getAverageGrossProfit();
        double loss = this.getAverageGrossLoss();
        if (profit == 0.0 || loss == 0.0) {
            return 0.0;
        }
        return profit / Math.abs(loss);
    }

    public double getProfitFactor() {
        if (this.getGrossProfit() == 0.0 || this.getGrossLoss() == 0.0) {
            return 0.0;
        }
        return Math.abs(this.getGrossProfit() / this.getGrossLoss());
    }

    public double getAdjustedProfitFactor() {
        double profit = this.getAdjustedGrossProfit();
        double loss = this.getAdjustedGrossLoss();
        if (profit == 0.0 || loss == 0.0) {
            return 0.0;
        }
        return Math.abs(profit / loss);
    }

    public double getPercentProfitable() {
        return this.getProfitable();
    }

    public double getProfitable() {
        int sum = this.getWinTrades() + this.getLossTrades();
        if (this.getWinTrades() == 0 || sum == 0) {
            return 0.0;
        }
        return (double)this.getWinTrades() / (double)sum;
    }

    public double getExpectation() {
        double profitable = this.getProfitable();
        return this.getAverageGrossProfit() * profitable + this.getAverageGrossLoss() * (1.0 - profitable);
    }

    public double getKelly() {
        double payoff = this.getPayoffRatio();
        double num = (payoff + 1.0) * this.getProfitable() - 1.0;
        if (payoff == 0.0 || num == 0.0) {
            return 0.0;
        }
        return num / payoff;
    }

    public int getTrades() {
        return this.getCount();
    }

    public int getWinTrades() {
        return this.winStats.getCount();
    }

    public double getPercentWinTrades() {
        if (this.getWinTrades() == 0 || this.getTrades() == 0) {
            return 0.0;
        }
        return (double)this.getWinTrades() / (double)this.getTrades();
    }

    public int getLossTrades() {
        return this.lossStats.getCount();
    }

    public double getPercentLossTrades() {
        if (this.getLossTrades() == 0 || this.getTrades() == 0) {
            return 0.0;
        }
        return (double)this.getLossTrades() / (double)this.getTrades();
    }

    public int getMaxConsecutiveWinner() {
        return this.winStats.getMaxConsecutiveCount();
    }

    public int getMaxConsecutiveLoser() {
        return this.lossStats.getMaxConsecutiveCount();
    }
}

