/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.trading;

import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import jp.sf.orangesignal.trading.Position;
import jp.sf.orangesignal.trading.PositionType;

@XmlRootElement(name="position")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"id", "symbol", "type", "entryLabel", "entryDate", "entryPrice", "entryQuantity", "entryCommission", "entrySlippage", "exitLabel", "exitDate", "exitPrice", "exitQuantity", "exitCommission", "exitSlippage", "hold"})
public class DefaultPosition
implements Position,
Serializable,
Comparable<DefaultPosition> {
    private static final long serialVersionUID = -5406781383133951498L;
    @XmlElement(name="id", nillable=false, required=true)
    protected int id;
    @XmlElement(name="symbol", nillable=false, required=true)
    protected String symbol;
    @XmlElement(name="type", nillable=false, required=true)
    protected PositionType type;
    @XmlElement(name="entry_label", nillable=true, required=true)
    protected String entryLabel;
    @XmlElement(name="entry_date", nillable=false, required=true)
    protected Date entryDate;
    @XmlElement(name="entry_price", nillable=false, required=true)
    protected double entryPrice;
    @XmlElement(name="entry_quantity", nillable=false, required=true)
    protected int entryQuantity;
    @XmlElement(name="entry_commission", nillable=false, required=true)
    protected double entryCommission;
    @XmlElement(name="entry_slippage", nillable=false, required=true)
    protected double entrySlippage;
    @XmlElement(name="exit_label", nillable=true, required=false)
    protected String exitLabel;
    @XmlElement(name="exit_date", nillable=true, required=false)
    protected Date exitDate;
    @XmlElement(name="exit_price", nillable=true, required=false)
    protected double exitPrice;
    @XmlElement(name="exit_quantity", nillable=true, required=false)
    protected int exitQuantity;
    @XmlElement(name="exit_commission", nillable=true, required=false)
    protected double exitCommission;
    @XmlElement(name="exit_slippage", nillable=true, required=false)
    protected double exitSlippage;
    @Deprecated
    protected transient boolean stoped;
    @XmlElement(name="hold", nillable=true, required=false)
    protected int hold;

    protected DefaultPosition() {
    }

    protected DefaultPosition(int id, String symbol, PositionType type, String entryLabel, Date entryDate, double entryPrice, int entryQuantity, double entryCommission, double entrySlippage) {
        if (symbol == null) {
            throw new NullPointerException("Symbol is null.");
        }
        if (type == null) {
            throw new NullPointerException("PositionType is null.");
        }
        if (entryDate == null) {
            throw new NullPointerException("EntryDate is null.");
        }
        if (entryPrice <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (entryQuantity <= 0) {
            throw new IllegalArgumentException();
        }
        if (entryCommission < 0.0) {
            throw new IllegalArgumentException();
        }
        if (entrySlippage < 0.0) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.symbol = symbol;
        this.entryLabel = entryLabel;
        this.type = type;
        this.entryDate = entryDate;
        this.entryPrice = entryPrice;
        this.entryQuantity = entryQuantity;
        this.entryCommission = entryCommission;
        this.entrySlippage = entrySlippage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefaultPosition close(int id, String exitLabel, Date exitDate, double exitPrice, int exitQuantity, double exitCommission, double exitSlippage, int hold) {
        if (this.isClosed()) {
            return null;
        }
        if (exitDate == null) {
            throw new NullPointerException("ExitDate is null.");
        }
        if (exitPrice <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (exitQuantity <= 0) {
            throw new IllegalArgumentException();
        }
        if (exitCommission < 0.0) {
            throw new IllegalArgumentException();
        }
        if (exitSlippage < 0.0) {
            throw new IllegalArgumentException();
        }
        if (hold < 0) {
            throw new IllegalArgumentException();
        }
        if (this.entryDate.compareTo(exitDate) > 0) {
            throw new IllegalArgumentException();
        }
        if (this.entryQuantity < exitQuantity) {
            throw new IllegalArgumentException();
        }
        this.exitLabel = exitLabel;
        this.exitDate = exitDate;
        this.exitPrice = exitPrice;
        this.exitQuantity = exitQuantity;
        this.exitCommission = exitCommission;
        this.exitSlippage = exitSlippage;
        this.hold = hold;
        if (this.entryQuantity != this.exitQuantity) {
            try {
                DefaultPosition defaultPosition = new DefaultPosition(id, this.symbol, this.type, this.entryLabel, this.entryDate, this.entryPrice, this.entryQuantity - this.exitQuantity, 0.0, this.entrySlippage);
                return defaultPosition;
            }
            finally {
                this.entryQuantity = this.exitQuantity;
            }
        }
        return null;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public PositionType getType() {
        return this.type;
    }

    @Override
    public String getEntryLabel() {
        return this.entryLabel;
    }

    @Override
    public Date getEntryDate() {
        return this.entryDate;
    }

    @Override
    public double getEntryPrice() {
        return this.entryPrice;
    }

    @Override
    public int getEntryQuantity() {
        return this.entryQuantity;
    }

    @Override
    public double getEntryAmount() {
        return this.getEntryPrice() * (double)this.getEntryQuantity();
    }

    @Override
    public double getEntryCommission() {
        return this.entryCommission;
    }

    @Override
    public double getEntrySlippage() {
        return this.entrySlippage;
    }

    @Override
    public String getExitLabel() {
        return this.exitLabel;
    }

    @Override
    public Date getExitDate() {
        return this.exitDate;
    }

    @Override
    public double getExitPrice() {
        return this.exitPrice;
    }

    @Override
    public int getExitQuantity() {
        return this.exitQuantity;
    }

    @Override
    public double getExitAmount() {
        return this.getExitPrice() * (double)this.getExitQuantity();
    }

    @Override
    public double getExitCommission() {
        return this.exitCommission;
    }

    @Override
    public double getExitSlippage() {
        return this.exitSlippage;
    }

    @Override
    public int getHold() {
        return this.hold;
    }

    @Override
    public boolean isClosed() {
        return this.exitDate != null;
    }

    @Override
    public int getDays() {
        if (this.isClosed()) {
            return this.getDays(this.exitDate);
        }
        return 0;
    }

    @Override
    public double getGrossSales(double amount) {
        switch (this.type) {
            case LONG: {
                return amount - this.getEntryAmount();
            }
            case SHORT: {
                return this.getEntryAmount() - amount;
            }
        }
        return 0.0;
    }

    @Override
    public double getNetProfit(double amount, double commission) {
        return this.getGrossSales(amount) - (this.getEntryCommission() + commission);
    }

    @Override
    public double getPercent(double amount) {
        double entryAmount = this.getEntryAmount();
        if (amount == 0.0 || entryAmount == 0.0) {
            return 0.0;
        }
        return amount / entryAmount;
    }

    @Override
    public int getDays(Date date) {
        long one_date_time = 86400000L;
        long diffDays = (date.getTime() - this.entryDate.getTime()) / 86400000L;
        return (int)diffDays;
    }

    @Override
    public double getGrossSales() {
        if (this.isClosed()) {
            return this.getGrossSales(this.getExitAmount());
        }
        return 0.0;
    }

    @Override
    public double getCommission() {
        return this.getEntryCommission() + this.getExitCommission();
    }

    @Override
    public double getSlippage() {
        return this.getEntrySlippage() + this.getExitSlippage();
    }

    @Override
    public double getNetProfit() {
        if (this.isClosed()) {
            return this.getGrossSales() - (this.getCommission() + this.getSlippage());
        }
        return 0.0;
    }

    @Override
    public double getGrossProfit() {
        return Math.max(this.getNetProfit(), 0.0);
    }

    @Override
    public double getGrossLoss() {
        return Math.min(this.getNetProfit(), 0.0);
    }

    @Override
    public double getPercentCommission() {
        return this.getPercent(this.getCommission());
    }

    @Override
    public double getPercentNetProfit() {
        return this.getPercent(this.getNetProfit());
    }

    @Override
    public double getPercentGrossProfit() {
        return this.getPercent(this.getGrossProfit());
    }

    @Override
    public double getPercentGrossLoss() {
        return this.getPercent(this.getGrossLoss());
    }

    @Override
    public int compareTo(DefaultPosition o) {
        int c = this.exitDate == null && o.getExitDate() == null ? 0 : (this.exitDate != null && o.getExitDate() == null ? 1 : (this.exitDate == null && o.getExitDate() != null ? -1 : this.exitDate.compareTo(o.getExitDate())));
        if (c != 0) {
            return c;
        }
        return this.entryDate.compareTo(o.getEntryDate());
    }
}

