/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.strategy.systems;

import static jp.sourceforge.orangesignal.ta.candle.CandlestickColor.WHITE;
import jp.sourceforge.orangesignal.ta.candle.Candlestick;
import jp.sourceforge.orangesignal.trading.strategy.TradingStrategySupport;

public class OutsideBarLongEntry extends TradingStrategySupport {

	protected Candlestick[] c;

	@Override
	public void prepare() {
		this.c = getDataset().getCandlestick();
	}

	@Override
	public boolean execute() {
		final int i = getCurrentDataIndex();
		if (i <= 0 || c[i - 1] == null || c[i] == null)
			return false;
		if (c[i].contains(c[i - 1]) && c[i].getColor() == WHITE)
			buy(getStrategyName());
		return false;
	}

	@Override
	public void close() {
		this.c = null;
	}

}
