/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.strategy.systems;

import static jp.sourceforge.orangesignal.ta.TechnicalAnalysis.ma;
import jp.sourceforge.orangesignal.ta.MovingAverage;
import jp.sourceforge.orangesignal.ta.result.FourPrice;
import jp.sourceforge.orangesignal.trading.strategy.TradingStrategySupport;

/**
 * 価格と短期移動平均、中期移動平均、長期移動平均の交差をシグナルとするストラテジーの基底クラスを提供します。
 */
public abstract class MovingAverage3LineCross extends TradingStrategySupport {

	/**
	 * 価格の種類を保持します。
	 */
	private FourPrice price = FourPrice.CLOSE;

	/**
	 * 価格の種類を返します。
	 * 
	 * @return 価格の種類
	 */
	public FourPrice getPrice() { return price; }

	/**
	 * 価格の種類を設定します。
	 * 
	 * @param price 価格の種類
	 */
	public void setPrice(FourPrice price) { this.price = price; }

	/**
	 * 短期移動平均の期間を保持します。
	 */
	private int fast = 4;

	/**
	 * 短期移動平均の期間を返します。
	 * 
	 * @return 短期移動平均の期間
	 */
	public int getFast() { return fast; }

	/**
	 * 短期移動平均の期間を設定します。
	 * 
	 * @param fast 短期移動平均の期間
	 */
	public void setFast(int fast) { this.fast = fast; }

	/**
	 * 中期移動平均の期間を保持します。
	 */
	private int mid = 9;

	/**
	 * 中期移動平均の期間を返します。
	 * 
	 * @return 中期移動平均の期間
	 */
	public int getMid() { return mid; }

	/**
	 * 中期移動平均の期間を設定します。
	 * 
	 * @param mid 中期移動平均の期間
	 */
	public void setMid(int mid) { this.mid = mid; }

	/**
	 * 長期移動平均の期間を保持します。
	 */
	private int slow = 18;

	/**
	 * 長期移動平均の期間を返します。
	 * 
	 * @return 長期移動平均の期間
	 */
	public int getSlow() { return slow; }

	/**
	 * 長期移動平均の期間を設定します。
	 * 
	 * @param slow 長期移動平均の期間
	 */
	public void setSlow(int slow) { this.slow = slow; }

	/**
	 * 移動平均の種類を保持します。
	 */
	private MovingAverage type = MovingAverage.SMA;

	/**
	 * 移動平均の種類を返します。
	 * 
	 * @return 移動平均の種類
	 */
	public MovingAverage getType() { return type; }

	/**
	 * 移動平均の種類を設定します。
	 * 
	 * @param type 移動平均の種類
	 */
	public void setType(MovingAverage type) { this.type = type; }

	// ----------------------------------------------------------------------

	/**
	 * 価格データを保持します。
	 */
	protected Number[] prices;

	/**
	 * 短期移動平均データを保持します。
	 */
	protected Number[] ma_fast;

	/**
	 * 中期移動平均データを保持します。
	 */
	protected Number[] ma_mid;

	/**
	 * 長期移動平均データを保持します。
	 */
	protected Number[] ma_slow;

	@Override
	public void prepare() {
		this.prices = getDataset().getTechnicalPrice(this.price);
		this.ma_fast = ma(this.prices, this.fast, this.type);
		this.ma_mid = ma(this.prices, this.mid, this.type);
		this.ma_slow = ma(this.prices, this.slow, this.type);
	}

	@Override
	public void close() {
		this.prices = null;
		this.ma_fast = null;
		this.ma_mid = null;
		this.ma_slow = null;
	}

}
