/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.strategy.stop;

import static jp.sourceforge.orangesignal.trading.PositionType.LONG;
import static jp.sourceforge.orangesignal.trading.PositionType.SHORT;
import static jp.sourceforge.orangesignal.trading.order.OrderTiming.NEXT_LIMIT;

import java.util.List;

import jp.sourceforge.orangesignal.ta.PercentageScale;
import jp.sourceforge.orangesignal.trading.Position;
import jp.sourceforge.orangesignal.trading.strategy.TradingStrategySupport;

/**
 * ポジションが目標利益に達した場合に、指値注文するストラテジーを提供します。
 * 
 * @author 杉澤 浩二
 */
public class ProfitTarget extends TradingStrategySupport {

	private double profit;

	public double getProfit() { return profit; }

	public void setProfit(final double profit) { this.profit = profit; }

	private PercentageScale scale;

	public PercentageScale getScale() { return scale; }

	public void setScale(final PercentageScale scale) { this.scale = scale; }

	@Override
	public boolean execute() {
		final List<Position> positions = getCurrentPositions();
		for (final Position p : positions) {
			final double profit = (this.scale == null) ? this.profit : Math.ceil(p.getEntryPrice() * (this.profit / this.scale.scale()));
			if (p.getType() == LONG)
				sell(getStrategyName(), NEXT_LIMIT, p.getEntryPrice() + profit, p.getEntryLabel());
			else if (p.getType() == SHORT)
				buyToCover(getStrategyName(), NEXT_LIMIT, p.getEntryPrice() - profit, p.getEntryLabel());
		}
		return false;
	}

}
