/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.stats.report;

import java.io.IOException;

import jp.sourceforge.orangesignal.trading.backtest.Backtester;
import jp.sourceforge.orangesignal.trading.stats.Stats;
import jp.sourceforge.orangesignal.trading.stats.Summary;

/**
 * パフォーマンス情報出力機能のインターフェースを提供します。
 * 
 * @author 杉澤 浩二
 */
public interface Reporter {

	/**
	 * パフォーマンス概要情報を出力します。
	 * 
	 * @param summary パフォーマンス概要情報
	 * @param backtester バックテスト実行オブジェクト
	 * @throws IOException 入出力操作で例外が発生した場合
	 */
	public void report(Summary summary, Backtester backtester) throws IOException;

	/**
	 * パフォーマンス統計情報を出力します。
	 * 
	 * @param stats パフォーマンス統計情報
	 * @throws IOException 入出力操作で例外が発生した場合
	 */
	public void report(Stats stats) throws IOException;

}
