/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.commission;

import java.io.Serializable;

/**
 * 手数料なしの手数料情報を提供します。
 * 
 * @author 杉澤 浩二
 */
public final class FreeCommission implements Commission, Serializable {

	private static final long serialVersionUID = 2206456865231531074L;

	/**
	 * デフォルトコンストラクタです。
	 */
	public FreeCommission() {}

	/**
	 * この実装は必ず <code>0</code> を返します。
	 */
	@Override public double calcCommission(final double price, final int quantity) { return 0; }

}
