/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.backtest;

/**
 * バックテスト進行状況イベントを受け取る為のリスナーインタフェースを提供します。
 * 
 * @author 杉澤 浩二
 */
public interface BacktesterListener {

	/**
	 * データセット毎のバックテスト開始前に呼出されます。
	 * 
	 * @param event バックテスト進行状況イベント情報
	 */
	public void backtestStart(BacktesterEvent event);

	/**
	 * データセット毎のバックテスト完了後に呼出されます。
	 * 
	 * @param event バックテスト進行状況イベント情報
	 */
	public void backtestProcessed(BacktesterEvent event);

//	/**
//	 * 全てのデータセットのバックテスト完了後に呼び出されます。
//	 * 
//	 * @param event バックテスト進行状況イベント情報
//	 * @param summary パフォーマンス概要情報
//	 */
//	public void backtestComplete(BacktesterEvent event, Summary summary);

}
