/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.backtest;

/**
 * バックテスト実行時にスローされる例外を提供します。
 * 
 * @author 杉澤 浩二
 * @since 2.0.1
 */
public class BacktestException extends RuntimeException {

	private static final long serialVersionUID = 388179405595347507L;

	/**
	 * デフォルトコンストラクタです。
	 */
	public BacktestException() {
		super();
	}

	/**
	 * コンストラクタです。
	 * 
	 * @param message 詳細なエラーメッセージ
	 */
	public BacktestException(final String message) {
		super(message);
	}

	/**
	 * コンストラクタです。
	 * 
	 * @param message 詳細なエラーメッセージ
	 * @param cause 原因
	 */
	public BacktestException(final String message, final Throwable cause) {
		super(message, cause);
	}

	/**
	 * コンストラクタです。
	 * 
	 * @param cause 原因
	 */
	public BacktestException(final Throwable cause) {
		super(cause);
	}

}
