/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.converter.impl;

import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.seasar.extension.dxo.annotation.AnnotationReader;
import org.seasar.extension.dxo.converter.ConversionContext;
import org.seasar.extension.dxo.converter.Converter;
import org.seasar.extension.dxo.converter.ConverterFactory;
import org.seasar.extension.dxo.converter.DatePropertyInfo;
import org.seasar.extension.dxo.converter.NestedPropertyInfo;
import org.seasar.extension.dxo.util.DxoUtil;
import org.seasar.extension.dxo.util.Expression;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.CaseInsensitiveMap;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;
import org.seasar.framework.util.MapUtil;
import org.seasar.framework.util.StringUtil;

public class ConversionContextImpl
implements ConversionContext {
    protected static final String JAVA = "java.";
    protected static final String JAVAX = "javax.";
    protected static final Object NOT_FOUND = new Object();
    protected static boolean initialized;
    protected static final Map contextInfoCache;
    protected static Map convertersCache;
    protected static final Map nestedPropertyInfoCache;
    protected static final Map datePropertyInfoCache;
    protected static final ThreadLocal dateFormatCache;
    protected Class dxoClass;
    protected Method method;
    protected ConverterFactory converterFactory;
    protected AnnotationReader annotationReader;
    protected Map contextInfo;
    protected Map evaluatedValues = new CaseInsensitiveMap();
    protected Map convertedObjects = new IdentityHashMap();
    protected boolean excludeNull;
    protected String sourcePrefix;
    static /* synthetic */ Class class$java$lang$String;

    public static void initialize() {
        if (initialized) {
            return;
        }
        DisposableUtil.add((Disposable)new Disposable(){

            public void dispose() {
                ConversionContextImpl.destroy();
            }
        });
        initialized = true;
    }

    public static void destroy() {
        contextInfoCache.clear();
        convertersCache.clear();
        nestedPropertyInfoCache.clear();
        datePropertyInfoCache.clear();
        initialized = false;
    }

    public ConversionContextImpl(Class dxoClass, Method method, ConverterFactory converterFactory, AnnotationReader annotationReader, Object source) {
        ConversionContextImpl.initialize();
        this.dxoClass = dxoClass;
        this.method = method;
        this.converterFactory = converterFactory;
        this.annotationReader = annotationReader;
        this.contextInfo = this.getContextInfo(annotationReader);
        Expression conversionRule = (Expression)this.getContextInfo("CONVERSION_RULE");
        if (conversionRule != null) {
            this.evaluatedValues = conversionRule.evaluate(source);
        }
        this.excludeNull = (Boolean)this.getContextInfo("EXCLUDE_NULL");
        this.sourcePrefix = (String)this.getContextInfo("SOURCE_PREFIX");
    }

    public ConverterFactory getConverterFactory() {
        return this.converterFactory;
    }

    public Converter getConverter(Class destClass, String destPropertyName) {
        Map cachedConverters = (Map)convertersCache.get(destClass);
        if (cachedConverters != null) {
            return (Converter)cachedConverters.get(destPropertyName);
        }
        Map converters = this.annotationReader.getConverters(destClass);
        convertersCache.put(destClass, converters);
        return (Converter)converters.get(destPropertyName);
    }

    public Object getConvertedObject(Object source) {
        return this.convertedObjects.get(source);
    }

    public void addConvertedObject(Object source, Object dest) {
        this.convertedObjects.put(source, dest);
    }

    public Object getContextInfo(String key) {
        return this.contextInfo.get(key);
    }

    public DateFormat getDateFormat() {
        String format = (String)this.contextInfo.get("DATE_PATTERN");
        return format == null ? null : this.getDateFormat(format);
    }

    public DateFormat getTimeFormat() {
        String format = (String)this.contextInfo.get("TIME_PATTERN");
        return format == null ? null : this.getDateFormat(format);
    }

    public DateFormat getTimestampFormat() {
        String format = (String)this.contextInfo.get("TIMESTAMP_PATTERN");
        return format == null ? null : this.getDateFormat(format);
    }

    public boolean hasEvalueatedValue(String name) {
        return this.evaluatedValues.containsKey(name);
    }

    public Object getEvaluatedValue(String name) {
        return this.evaluatedValues.get(name);
    }

    public void addEvaluatedValue(String name, Object value) {
        this.evaluatedValues.put(name, value);
    }

    public boolean isIncludeNull() {
        return !this.excludeNull;
    }

    public boolean isExcludeNull() {
        return this.excludeNull;
    }

    public NestedPropertyInfo getNestedPropertyInfo(Class srcClass, String propertyName) {
        String key = srcClass.getName() + "::" + propertyName;
        Object value = nestedPropertyInfoCache.get(key);
        if (value != null) {
            return value == NOT_FOUND ? null : (NestedPropertyInfo)value;
        }
        return this.createNestedPropertyInfo(srcClass, propertyName, key);
    }

    public DatePropertyInfo getDatePropertyInfo(Class srcClass, String propertyName) {
        String key = srcClass.getName() + "::" + propertyName;
        Object value = datePropertyInfoCache.get(key);
        if (value != null) {
            return value == NOT_FOUND ? null : (DatePropertyInfo)value;
        }
        return this.createDatePropertyInfo(srcClass, propertyName + "_", key);
    }

    public DateFormat getDateFormat(String format) {
        Map formatters = (Map)dateFormatCache.get();
        DateFormat formatter = (DateFormat)formatters.get(format);
        if (formatter == null) {
            formatter = new SimpleDateFormat(format);
            formatters.put(format, formatter);
        }
        return formatter;
    }

    public String getSourcePrefix() {
        return this.sourcePrefix;
    }

    public String getSourcePropertyName(String destPropertyName) {
        if (StringUtil.isEmpty((String)this.sourcePrefix)) {
            return destPropertyName;
        }
        if (this.sourcePrefix.endsWith("_")) {
            return this.sourcePrefix + destPropertyName;
        }
        return this.sourcePrefix + StringUtil.capitalize((String)destPropertyName);
    }

    protected Map getContextInfo(AnnotationReader reader) {
        Map contextInfo = (Map)contextInfoCache.get(this.method);
        if (contextInfo != null) {
            return contextInfo;
        }
        return this.createContextInfo(reader);
    }

    protected Map createContextInfo(AnnotationReader reader) {
        String conversionRule;
        String timestampPattern;
        String timePattern;
        HashMap<String, Object> contextInfo = new HashMap<String, Object>();
        String datePattern = reader.getDatePattern(this.dxoClass, this.method);
        if (!StringUtil.isEmpty((String)datePattern)) {
            contextInfo.put("DATE_PATTERN", datePattern);
        }
        if (!StringUtil.isEmpty((String)(timePattern = reader.getTimePattern(this.dxoClass, this.method)))) {
            contextInfo.put("TIME_PATTERN", timePattern);
        }
        if (!StringUtil.isEmpty((String)(timestampPattern = reader.getTimestampPattern(this.dxoClass, this.method)))) {
            contextInfo.put("TIMESTAMP_PATTERN", timestampPattern);
        }
        if (!StringUtil.isEmpty((String)(conversionRule = reader.getConversionRule(this.dxoClass, this.method)))) {
            contextInfo.put("CONVERSION_RULE", DxoUtil.parseRule(conversionRule));
        }
        contextInfo.put("EXCLUDE_NULL", this.annotationReader.isExcludeNull(this.dxoClass, this.method));
        contextInfo.put("SOURCE_PREFIX", this.annotationReader.getSourcePrefix(this.dxoClass, this.method));
        contextInfoCache.put(this.method, contextInfo);
        return contextInfo;
    }

    protected NestedPropertyInfo createNestedPropertyInfo(Class srcClass, String propertyName, String key) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)srcClass);
        int propertyDefSize = beanDesc.getPropertyDescSize();
        for (int i = 0; i < propertyDefSize; ++i) {
            PropertyDesc nestedPropertyDesc;
            BeanDesc nestedBeanDesc;
            PropertyDesc propertyDesc = beanDesc.getPropertyDesc(i);
            Class propertyType = propertyDesc.getPropertyType();
            if (!propertyDesc.isReadable() || this.isBasicType(propertyType) || !(nestedBeanDesc = BeanDescFactory.getBeanDesc((Class)propertyType)).hasPropertyDesc(propertyName) || !(nestedPropertyDesc = nestedBeanDesc.getPropertyDesc(propertyName)).isReadable()) continue;
            NestedPropertyInfo info = new NestedPropertyInfo(propertyDesc, nestedPropertyDesc);
            nestedPropertyInfoCache.put(key, info);
            return info;
        }
        nestedPropertyInfoCache.put(key, NOT_FOUND);
        return null;
    }

    protected boolean isBasicType(Class clazz) {
        if (clazz.isPrimitive() || clazz.isArray()) {
            return true;
        }
        String className = clazz.getName();
        return className.startsWith(JAVA) || className.startsWith(JAVAX);
    }

    protected DatePropertyInfo createDatePropertyInfo(Class srcClass, String prefix, String key) {
        int pos = prefix.length();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)srcClass);
        StringBuffer formatBuffer = new StringBuffer();
        ArrayList<PropertyDesc> propertyDescs = new ArrayList<PropertyDesc>();
        int size = beanDesc.getPropertyDescSize();
        for (int i = 0; i < size; ++i) {
            String propertyName;
            PropertyDesc propertyDesc = beanDesc.getPropertyDesc(i);
            if (propertyDesc.getPropertyType() != (class$java$lang$String == null ? ConversionContextImpl.class$("java.lang.String") : class$java$lang$String) || !(propertyName = propertyDesc.getPropertyName()).startsWith(prefix)) continue;
            formatBuffer.append(propertyName.substring(pos));
            propertyDescs.add(propertyDesc);
        }
        if (formatBuffer.length() == 0) {
            datePropertyInfoCache.put(key, NOT_FOUND);
            return null;
        }
        String format = new String(formatBuffer);
        PropertyDesc[] array = propertyDescs.toArray(new PropertyDesc[propertyDescs.size()]);
        DatePropertyInfo info = new DatePropertyInfo(this, format, array);
        datePropertyInfoCache.put(key, info);
        return info;
    }

    static {
        contextInfoCache = MapUtil.createHashMap((int)1024);
        convertersCache = MapUtil.createHashMap((int)1024);
        nestedPropertyInfoCache = MapUtil.createHashMap((int)1024);
        datePropertyInfoCache = MapUtil.createHashMap((int)1024);
        dateFormatCache = new ThreadLocal(){

            protected Object initialValue() {
                return new HashMap();
            }
        };
        ConversionContextImpl.initialize();
    }
}

