/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.sql.cache;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.ConcurrentHashMap;
import org.seasar.extension.sql.Node;
import org.seasar.extension.sql.parser.SqlParserImpl;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;
import org.seasar.framework.util.InputStreamReaderUtil;
import org.seasar.framework.util.ReaderUtil;
import org.seasar.framework.util.ResourceUtil;

public final class NodeCache {
    private static volatile boolean initialized;
    private static ConcurrentHashMap<String, Node> nodeCache;

    public static Node getNode(String path, String dbmsName) {
        if (!initialized) {
            NodeCache.initialize();
        }
        if (path.endsWith(".sql")) {
            path = path.substring(0, path.length() - 4);
        }
        String s = null;
        Node node = null;
        if (dbmsName != null) {
            s = path + "_" + dbmsName;
            node = nodeCache.get(s);
            if (node != null) {
                return node;
            }
            node = NodeCache.createNode(s);
            if (node != null) {
                Node current = nodeCache.putIfAbsent(s, node);
                return current != null ? current : node;
            }
        }
        if ((node = nodeCache.get(path)) != null) {
            return node;
        }
        node = NodeCache.createNode(path);
        if (node != null) {
            Node current = nodeCache.putIfAbsent(s != null ? s : path, node);
            return current != null ? current : node;
        }
        return null;
    }

    private static Node createNode(String path) {
        InputStream is = ResourceUtil.getResourceAsStreamNoException((String)path, (String)"sql");
        if (is == null) {
            return null;
        }
        InputStreamReader reader = InputStreamReaderUtil.create((InputStream)is, (String)"UTF-8");
        String sql = ReaderUtil.readText((Reader)reader);
        return new SqlParserImpl(sql).parse();
    }

    public static void initialize() {
        DisposableUtil.add((Disposable)new Disposable(){

            public void dispose() {
                NodeCache.clear();
            }
        });
        initialized = true;
    }

    public static void clear() {
        nodeCache.clear();
        initialized = false;
    }

    static {
        nodeCache = new ConcurrentHashMap(200);
        NodeCache.initialize();
    }
}

