/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.meta;

import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Entity;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.EntityMetaFactory;
import org.seasar.extension.jdbc.JoinColumnMeta;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.PropertyMetaFactory;
import org.seasar.extension.jdbc.RelationshipType;
import org.seasar.extension.jdbc.TableMeta;
import org.seasar.extension.jdbc.TableMetaFactory;
import org.seasar.extension.jdbc.exception.JoinColumnAutoConfigurationRuntimeException;
import org.seasar.extension.jdbc.exception.JoinColumnNotFoundRuntimeException;
import org.seasar.extension.jdbc.exception.ManyToOneFKNotFoundRuntimeException;
import org.seasar.extension.jdbc.exception.NonEntityRuntimeException;
import org.seasar.extension.jdbc.exception.OneToOneFKNotFoundRuntimeException;
import org.seasar.extension.jdbc.exception.ReferencedColumnNameNotFoundRuntimeException;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.container.annotation.tiger.InitMethod;
import org.seasar.framework.convention.PersistenceConvention;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;
import org.seasar.framework.util.ModifierUtil;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityMetaFactoryImpl
implements EntityMetaFactory {
    protected ConcurrentHashMap<String, EntityMeta> entityMetaMap = new ConcurrentHashMap(200);
    protected TableMetaFactory tableMetaFactory;
    protected PropertyMetaFactory propertyMetaFactory;
    protected volatile boolean initialized;
    protected PersistenceConvention persistenceConvention;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntityMeta getEntityMeta(Class<?> entityClass) {
        EntityMeta entityMeta;
        if (entityClass == null) {
            throw new NullPointerException("entityClass");
        }
        if (!this.initialized) {
            this.initialize();
        }
        if (!(entityMeta = this.getEntityMetaInternal(entityClass)).isRelationshipResolved()) {
            EntityMeta entityMeta2 = entityMeta;
            synchronized (entityMeta2) {
                if (!entityMeta.isRelationshipResolved()) {
                    this.resolveRelationship(entityMeta);
                }
            }
        }
        return entityMeta;
    }

    protected EntityMeta getEntityMetaInternal(Class<?> entityClass) {
        String className = entityClass.getName();
        EntityMeta entityMeta = this.entityMetaMap.get(className);
        if (entityMeta != null) {
            return entityMeta;
        }
        entityMeta = this.createEntityMeta(entityClass);
        EntityMeta entityMeta2 = this.entityMetaMap.putIfAbsent(className, entityMeta);
        return entityMeta2 != null ? entityMeta2 : entityMeta;
    }

    protected EntityMeta createEntityMeta(Class<?> entityClass) throws NonEntityRuntimeException {
        Entity entity = entityClass.getAnnotation(Entity.class);
        if (entity == null) {
            throw new NonEntityRuntimeException(entityClass);
        }
        EntityMeta entityMeta = new EntityMeta();
        this.doEntityClass(entityMeta, entityClass);
        this.doName(entityMeta, entityClass, entity);
        this.doTableMeta(entityMeta, entityClass);
        this.doPropertyMeta(entityMeta, entityClass);
        this.doCustomize(entityMeta, entityClass);
        return entityMeta;
    }

    protected void doEntityClass(EntityMeta entityMeta, Class<?> entityClass) {
        entityMeta.setEntityClass(entityClass);
    }

    protected void doName(EntityMeta entityMeta, Class<?> entityClass, Entity entity) {
        if (!StringUtil.isEmpty((String)entity.name())) {
            entityMeta.setName(entity.name());
        } else {
            String entityName = this.fromClassToEntityName(entityClass);
            entityMeta.setName(entityName);
        }
    }

    protected String fromClassToEntityName(Class<?> entityClass) {
        return ClassUtil.getShortClassName(entityClass);
    }

    protected void doTableMeta(EntityMeta entityMeta, Class<?> entityClass) {
        TableMeta tableMeta = this.tableMetaFactory.createTableMeta(entityClass, entityMeta);
        entityMeta.setTableMeta(tableMeta);
    }

    protected void doPropertyMeta(EntityMeta entityMeta, Class<?> entityClass) {
        Field[] fields;
        for (Field f : fields = entityClass.getDeclaredFields()) {
            if (!ModifierUtil.isInstanceField((Field)f)) continue;
            f.setAccessible(true);
            entityMeta.addPropertyMeta(this.propertyMetaFactory.createPropertyMeta(f, entityMeta));
        }
    }

    protected void doCustomize(EntityMeta entityMeta, Class<?> entityClass) {
    }

    protected void resolveRelationship(EntityMeta entityMeta) {
        int size = entityMeta.getPropertyMetaSize();
        for (int i = 0; i < size; ++i) {
            PropertyMeta propertyMeta = entityMeta.getPropertyMeta(i);
            if (!propertyMeta.isRelationship() || propertyMeta.getRelationshipType() != RelationshipType.MANY_TO_ONE && (propertyMeta.getRelationshipType() != RelationshipType.ONE_TO_ONE || propertyMeta.getMappedBy() != null)) continue;
            this.resolveJoinColumn(entityMeta, propertyMeta);
        }
        entityMeta.setRelationshipResolved(true);
    }

    protected void resolveJoinColumn(EntityMeta entityMeta, PropertyMeta propertyMeta) {
        List<JoinColumnMeta> jcmList = propertyMeta.getJoinColumnMetaList();
        EntityMeta inverseEntityMeta = this.getEntityMetaInternal(propertyMeta.getRelationshipClass());
        if (jcmList.size() == 0) {
            if (inverseEntityMeta.getIdPropertyMetaList().size() != 1) {
                throw new JoinColumnNotFoundRuntimeException(entityMeta.getName(), propertyMeta.getName());
            }
            propertyMeta.addJoinColumnMeta(new JoinColumnMeta());
        }
        if (jcmList.size() == 1) {
            JoinColumnMeta joinColumnMeta = jcmList.get(0);
            PropertyMeta inverseIdPropertyMeta = null;
            if (inverseEntityMeta.getIdPropertyMetaList().size() == 1) {
                inverseIdPropertyMeta = inverseEntityMeta.getIdPropertyMetaList().get(0);
            }
            if (joinColumnMeta.getName() == null) {
                if (inverseIdPropertyMeta == null) {
                    throw new JoinColumnAutoConfigurationRuntimeException(entityMeta.getName(), propertyMeta.getName(), inverseEntityMeta.getName());
                }
                joinColumnMeta.setName(this.persistenceConvention.fromPropertyNameToColumnName(propertyMeta.getName()) + "_" + inverseIdPropertyMeta.getColumnMeta().getName());
            }
            if (joinColumnMeta.getReferencedColumnName() == null) {
                if (inverseIdPropertyMeta == null) {
                    throw new JoinColumnAutoConfigurationRuntimeException(entityMeta.getName(), propertyMeta.getName(), inverseEntityMeta.getName());
                }
                joinColumnMeta.setReferencedColumnName(inverseIdPropertyMeta.getColumnMeta().getName());
            }
        }
        for (JoinColumnMeta jcm : jcmList) {
            if (!entityMeta.hasColumnPropertyMeta(jcm.getName())) {
                if (propertyMeta.getRelationshipType() == RelationshipType.MANY_TO_ONE) {
                    throw new ManyToOneFKNotFoundRuntimeException(entityMeta.getName(), propertyMeta.getName(), jcm.getName());
                }
                throw new OneToOneFKNotFoundRuntimeException(entityMeta.getName(), propertyMeta.getName(), jcm.getName());
            }
            if (inverseEntityMeta.hasColumnPropertyMeta(jcm.getReferencedColumnName())) continue;
            throw new ReferencedColumnNameNotFoundRuntimeException(entityMeta.getName(), propertyMeta.getName(), inverseEntityMeta.getName(), jcm.getReferencedColumnName());
        }
    }

    @Binding(bindingType=BindingType.MUST)
    public void setTableMetaFactory(TableMetaFactory tableMetaFactory) {
        this.tableMetaFactory = tableMetaFactory;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setPropertyMetaFactory(PropertyMetaFactory propertyMetaFactory) {
        this.propertyMetaFactory = propertyMetaFactory;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setPersistenceConvention(PersistenceConvention persistenceConvention) {
        this.persistenceConvention = persistenceConvention;
    }

    @InitMethod
    public void initialize() {
        DisposableUtil.add((Disposable)new Disposable(){

            public void dispose() {
                EntityMetaFactoryImpl.this.clear();
            }
        });
        this.initialized = true;
    }

    public void clear() {
        this.entityMetaMap.clear();
        this.initialized = false;
    }
}

