/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.mapper;

import java.util.ArrayList;
import java.util.List;
import org.seasar.extension.jdbc.MappingContext;
import org.seasar.extension.jdbc.PropertyMapper;
import org.seasar.extension.jdbc.RelationshipEntityMapper;
import org.seasar.extension.jdbc.mapper.AbstractRelationshipEntityMapper;
import org.seasar.extension.jdbc.mapper.KeyItems;
import org.seasar.framework.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEntityMapper {
    protected Class<?> entityClass;
    protected PropertyMapper[] propertyMappers;
    protected int[] idIndices;
    protected List<RelationshipEntityMapper> relationshipEntityMapperList = new ArrayList<RelationshipEntityMapper>();

    public AbstractEntityMapper(Class<?> entityClass, PropertyMapper[] propertyMappers, int[] idIndices) {
        this.entityClass = entityClass;
        this.propertyMappers = propertyMappers;
        this.idIndices = idIndices;
    }

    protected Object getKey(Object[] values) {
        if (this.idIndices.length == 1) {
            return values[this.idIndices[0]];
        }
        if (this.idIndices.length > 1) {
            Object[] objs = new Object[this.idIndices.length];
            for (int i = 0; i < this.idIndices.length; ++i) {
                objs[i] = values[this.idIndices[i]];
                if (objs[i] != null) continue;
                return null;
            }
            return new KeyItems(objs);
        }
        return null;
    }

    protected Object getEntity(Object[] values, MappingContext mappingContext, Object key) {
        Object entity = null;
        if (key != null) {
            entity = mappingContext.getCache(this.entityClass, key);
        } else if (this.idIndices.length > 0) {
            return null;
        }
        if (entity == null) {
            entity = this.createEntity(values, mappingContext, key);
        }
        return entity;
    }

    protected Object createEntity(Object[] values, MappingContext mappingContext, Object key) {
        Object entity = ClassUtil.newInstance(this.entityClass);
        for (PropertyMapper propertyMapper : this.propertyMappers) {
            propertyMapper.map(entity, values);
        }
        if (key != null) {
            mappingContext.setCache(this.entityClass, key, entity);
        }
        return entity;
    }

    protected void mapRelationships(Object entity, Object[] values, MappingContext mappingContext) {
        if (entity == null) {
            return;
        }
        for (RelationshipEntityMapper mapper : this.relationshipEntityMapperList) {
            mapper.map(entity, values, mappingContext);
        }
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public int[] getIdIndices() {
        return this.idIndices;
    }

    public PropertyMapper[] getPropertyMappers() {
        return this.propertyMappers;
    }

    public RelationshipEntityMapper[] getRelationshipEntityMappers() {
        return this.relationshipEntityMapperList.toArray(new AbstractRelationshipEntityMapper[this.relationshipEntityMapperList.size()]);
    }

    public void addRelationshipEntityMapper(RelationshipEntityMapper relationshipEntityMapper) {
        this.relationshipEntityMapperList.add(relationshipEntityMapper);
    }
}

