/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.handler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.seasar.extension.jdbc.EntityMapper;
import org.seasar.extension.jdbc.MappingContext;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.handler.AbstractBeanAutoResultSetHandler;

public class BeanListSupportLimitAutoResultSetHandler
extends AbstractBeanAutoResultSetHandler {
    protected int limit;

    public BeanListSupportLimitAutoResultSetHandler(ValueType[] valueTypes, EntityMapper entityMapper, String sql, int limit) {
        super(valueTypes, entityMapper, sql);
        this.setLimit(limit);
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) throws IllegalArgumentException {
        if (limit <= 0) {
            throw new IllegalArgumentException("limit must be greater than 0.");
        }
        this.limit = limit;
    }

    public Object handle(ResultSet rs) throws SQLException {
        ArrayList<Object> list = new ArrayList<Object>(100);
        MappingContext mappingContext = new MappingContext();
        for (int i = 0; i < this.limit && rs.next(); ++i) {
            Object entity = this.createEntity(rs, mappingContext);
            if (entity == null) continue;
            list.add(entity);
        }
        return list;
    }
}

