/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.handler;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.persistence.Column;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.seasar.extension.jdbc.DbmsDialect;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.impl.PropertyTypeImpl;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.util.CaseInsensitiveMap;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBeanResultSetHandler
implements ResultSetHandler {
    protected Class<?> beanClass;
    protected BeanDesc beanDesc;
    protected DbmsDialect dialect;
    protected String sql;

    public AbstractBeanResultSetHandler(Class<?> beanClass, DbmsDialect dialect, String sql) {
        this.beanClass = beanClass;
        this.beanDesc = BeanDescFactory.getBeanDesc(beanClass);
        this.dialect = dialect;
        this.sql = sql;
    }

    protected PropertyType[] createPropertyTypes(ResultSetMetaData rsmd) throws SQLException {
        int count = rsmd.getColumnCount();
        PropertyType[] propertyTypes = new PropertyType[count];
        CaseInsensitiveMap pdWithColumn = this.createPropertyDescMapWithColumn();
        for (int i = 0; i < count; ++i) {
            String columnName = rsmd.getColumnLabel(i + 1);
            PropertyDesc propertyDesc = (PropertyDesc)pdWithColumn.get((Object)columnName);
            if (propertyDesc == null) {
                String propertyName = StringUtil.replace((String)columnName, (String)"_", (String)"");
                if (!this.beanDesc.hasPropertyDesc(propertyName)) continue;
                propertyDesc = this.beanDesc.getPropertyDesc(propertyName);
            }
            ValueType valueType = this.getValueType(propertyDesc);
            propertyTypes[i] = new PropertyTypeImpl(propertyDesc, valueType, columnName);
        }
        return propertyTypes;
    }

    protected CaseInsensitiveMap createPropertyDescMapWithColumn() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        int size = this.beanDesc.getPropertyDescSize();
        for (int i = 0; i < size; ++i) {
            Column column;
            PropertyDesc pd = this.beanDesc.getPropertyDesc(i);
            Field field = pd.getField();
            if (field == null || (column = field.getAnnotation(Column.class)) == null) continue;
            String name = column.name();
            if (StringUtil.isEmpty((String)name)) {
                throw new EmptyRuntimeException("name");
            }
            map.put((Object)name, (Object)pd);
        }
        return map;
    }

    protected Object createRow(ResultSet rs, PropertyType[] propertyTypes) throws SQLException {
        Object row = ClassUtil.newInstance(this.beanClass);
        for (int i = 0; i < propertyTypes.length; ++i) {
            PropertyType pt = propertyTypes[i];
            if (pt == null) continue;
            ValueType valueType = pt.getValueType();
            Object value = valueType.getValue(rs, i + 1);
            PropertyDesc pd = pt.getPropertyDesc();
            pd.setValue(row, value);
        }
        return row;
    }

    protected ValueType getValueType(PropertyDesc propertyDesc) {
        Field field = propertyDesc.getField();
        if (field == null) {
            return this.dialect.getValueType(propertyDesc.getPropertyType(), false, null);
        }
        boolean lob = field.isAnnotationPresent(Lob.class);
        Temporal temporal = field.getAnnotation(Temporal.class);
        TemporalType temporalType = temporal != null ? temporal.value() : null;
        return this.dialect.getValueType(propertyDesc.getPropertyType(), lob, temporalType);
    }
}

