/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.annotation.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.seasar.extension.dxo.annotation.AnnotationReader;
import org.seasar.extension.dxo.annotation.ConversionRule;
import org.seasar.extension.dxo.annotation.DatePattern;
import org.seasar.extension.dxo.annotation.DxoConverter;
import org.seasar.extension.dxo.annotation.ExcludeNull;
import org.seasar.extension.dxo.annotation.SourcePrefix;
import org.seasar.extension.dxo.annotation.TimePattern;
import org.seasar.extension.dxo.annotation.TimestampPattern;
import org.seasar.extension.dxo.converter.Converter;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.beans.util.BeanUtil;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.util.tiger.AnnotationUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TigerAnnotationReader
implements AnnotationReader {
    protected S2Container container;
    protected AnnotationReader next;
    protected Map<Class<?>, Map<String, Converter>> convertersCache = CollectionsUtil.newConcurrentHashMap();

    public TigerAnnotationReader(S2Container container) {
        this(container, null);
    }

    public TigerAnnotationReader(S2Container container, AnnotationReader next) {
        this.container = container.getRoot();
        this.next = next;
    }

    public String getDatePattern(Class dxoClass, Method method) {
        DatePattern datePattern = this.getAnnotation(dxoClass, method, DatePattern.class);
        if (datePattern != null) {
            return datePattern.value();
        }
        if (this.next != null) {
            return this.next.getDatePattern(dxoClass, method);
        }
        return null;
    }

    public String getTimePattern(Class dxoClass, Method method) {
        TimePattern timePattern = this.getAnnotation(dxoClass, method, TimePattern.class);
        if (timePattern != null) {
            return timePattern.value();
        }
        if (this.next != null) {
            return this.next.getTimePattern(dxoClass, method);
        }
        return null;
    }

    public String getTimestampPattern(Class dxoClass, Method method) {
        TimestampPattern timestampPattern = this.getAnnotation(dxoClass, method, TimestampPattern.class);
        if (timestampPattern != null) {
            return timestampPattern.value();
        }
        if (this.next != null) {
            return this.next.getTimestampPattern(dxoClass, method);
        }
        return null;
    }

    public String getConversionRule(Class dxoClass, Method method) {
        ConversionRule mapConversion = method.getAnnotation(ConversionRule.class);
        if (mapConversion != null) {
            return mapConversion.value();
        }
        if (this.next != null) {
            return this.next.getConversionRule(dxoClass, method);
        }
        return null;
    }

    public boolean isExcludeNull(Class dxoClass, Method method) {
        ExcludeNull excludeNull = this.getAnnotation(dxoClass, method, ExcludeNull.class);
        if (excludeNull != null) {
            return true;
        }
        if (this.next != null) {
            return this.next.isExcludeNull(dxoClass, method);
        }
        return false;
    }

    public String getSourcePrefix(Class dxoClass, Method method) {
        SourcePrefix sourcePrefix = this.getAnnotation(dxoClass, method, SourcePrefix.class);
        if (sourcePrefix != null) {
            return sourcePrefix.value();
        }
        if (this.next != null) {
            return this.next.getSourcePrefix(dxoClass, method);
        }
        return null;
    }

    public Map getConverters(Class destClass) {
        Map<String, Converter> converters = this.convertersCache.get(destClass);
        if (converters != null) {
            return converters;
        }
        return this.createConverters(destClass);
    }

    protected <T extends Annotation> T getAnnotation(Class<?> dxoClass, Method method, Class<T> annotationType) {
        T annotation = method.getAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        return dxoClass.getAnnotation(annotationType);
    }

    protected Map<String, Converter> createConverters(Class<?> destClass) {
        HashMap<String, Converter> converters = CollectionsUtil.newHashMap();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(destClass);
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            Annotation[] annotations;
            Converter converter;
            PropertyDesc propertyDesc = beanDesc.getPropertyDesc(i);
            if (!propertyDesc.isWritable() || (converter = this.detectConverter(annotations = propertyDesc.hasWriteMethod() ? propertyDesc.getWriteMethod().getDeclaredAnnotations() : propertyDesc.getField().getDeclaredAnnotations())) == null) continue;
            converters.put(propertyDesc.getPropertyName(), converter);
        }
        this.convertersCache.put(destClass, converters);
        return converters;
    }

    protected Converter detectConverter(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            DxoConverter metaAnnotation = annotationType.getAnnotation(DxoConverter.class);
            if (metaAnnotation == null) continue;
            DxoConverter dxoConverterAnnotation = (DxoConverter)DxoConverter.class.cast(metaAnnotation);
            String converterName = dxoConverterAnnotation.value();
            Converter converter = (Converter)Converter.class.cast(this.container.getComponent((Object)converterName));
            Map<String, Object> props = AnnotationUtil.getProperties(annotation);
            BeanUtil.copyProperties(props, (Object)converter);
            return converter;
        }
        return null;
    }
}

