/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.orangesignal.trading.strategy.stop;

import java.util.LinkedList;
import jp.sourceforge.orangesignal.ta.PercentageScale;
import jp.sourceforge.orangesignal.trading.Position;
import jp.sourceforge.orangesignal.trading.PositionType;
import jp.sourceforge.orangesignal.trading.order.OrderTiming;
import jp.sourceforge.orangesignal.trading.strategy.TradingStrategySupport;

public class StopLoss
extends TradingStrategySupport {
    private double loss;
    private PercentageScale scale;

    public double getLoss() {
        return this.loss;
    }

    public void setLoss(double loss) {
        this.loss = loss;
    }

    public PercentageScale getScale() {
        return this.scale;
    }

    public void setScale(PercentageScale scale) {
        this.scale = scale;
    }

    @Override
    public boolean execute() {
        LinkedList<Position> positions = this.getCurrentPositions();
        for (Position p : positions) {
            double loss;
            double d = loss = this.scale == null ? this.loss : Math.ceil(p.getEntryPrice() * (this.loss / this.scale.scale()));
            if (p.getType() == PositionType.LONG) {
                this.sell(this.getStrategyName(), OrderTiming.NEXT_STOP, p.getEntryPrice() - loss, p.getEntryLabel());
                continue;
            }
            if (p.getType() != PositionType.SHORT) continue;
            this.buyToCover(this.getStrategyName(), OrderTiming.NEXT_STOP, p.getEntryPrice() + loss, p.getEntryLabel());
        }
        return false;
    }
}

