/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.orangesignal.trading.stats;

import jp.sourceforge.orangesignal.trading.DefaultPosition;
import jp.sourceforge.orangesignal.trading.Position;

public class Trade
extends DefaultPosition {
    private static final long serialVersionUID = 1L;
    protected double cumNetProfit;
    protected double equity;
    protected double drawdown;
    protected double maxEquity;
    protected double maxDrawdown;

    protected Trade() {
    }

    protected Trade(Position position) {
        this.id = position.getId();
        this.symbol = position.getSymbol();
        this.type = position.getType();
        this.entryLabel = position.getEntryLabel();
        this.entryDate = position.getEntryDate();
        this.entryPrice = position.getEntryPrice();
        this.entryQuantity = position.getEntryQuantity();
        this.entryCommission = position.getEntryCommission();
        this.entrySlippage = position.getEntrySlippage();
        this.exitLabel = position.getExitLabel();
        this.exitDate = position.getExitDate();
        this.exitPrice = position.getExitPrice();
        this.exitQuantity = position.getExitQuantity();
        this.exitCommission = position.getExitCommission();
        this.exitSlippage = position.getExitSlippage();
        this.hold = position.getHold();
    }

    public double getCumNetProfit() {
        return this.cumNetProfit;
    }

    public double getPercentCumNetProfit() {
        if (this.cumNetProfit == 0.0 || this.equity == 0.0) {
            return 0.0;
        }
        return this.cumNetProfit / this.equity;
    }

    public double getEquity() {
        return this.equity;
    }

    public double getDrawdown() {
        return this.drawdown;
    }

    public double getPercentDrawdown() {
        if (this.equity == 0.0 || this.drawdown == 0.0) {
            return 0.0;
        }
        return this.drawdown / this.equity;
    }

    public double getMaxEquity() {
        return this.maxEquity;
    }

    public double getMaxDrawdown() {
        return this.maxDrawdown;
    }

    public double getPercentMaxDrawdown() {
        if (this.maxEquity == 0.0 || this.maxDrawdown == 0.0) {
            return 0.0;
        }
        return this.maxDrawdown / this.maxEquity;
    }
}

