/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.orangesignal.trading.stats;

import java.util.Date;
import java.util.LinkedList;
import jp.sourceforge.orangesignal.ta.dataset.TimeSeriesDataset;
import jp.sourceforge.orangesignal.trading.Position;
import jp.sourceforge.orangesignal.trading.PositionType;
import jp.sourceforge.orangesignal.trading.stats.WinLossStats;

public class Stats
extends WinLossStats {
    private static final long serialVersionUID = 1L;
    protected String symbol;
    protected String symbolName;
    protected Date startDate;
    protected Date endDate;
    protected int period;
    private TimeSeriesDataset.Interval interval;
    protected WinLossStats longStats;
    protected WinLossStats shortStats;

    protected Stats() {
    }

    public Stats(LinkedList<Position> positions, double initialCapital) {
        this.statistics(positions, initialCapital, false);
    }

    public Stats(LinkedList<Position> positions, double initialCapital, TimeSeriesDataset dataset, int start, int end) {
        this.statistics(positions, initialCapital, false);
        if (dataset != null) {
            this.statistics(dataset, start, end);
        }
    }

    @Override
    protected void statistics(LinkedList<Position> positions, double initialCapital, boolean discard) {
        super.statistics(positions, initialCapital, discard);
        final Stats parent = this;
        this.longStats = new WinLossStats(positions, initialCapital, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean isStatistics(Position p) {
                return parent.isStatistics(p) && p.getType() == PositionType.LONG;
            }
        };
        this.shortStats = new WinLossStats(positions, initialCapital, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean isStatistics(Position p) {
                return parent.isStatistics(p) && p.getType() == PositionType.SHORT;
            }
        };
    }

    protected void statistics(TimeSeriesDataset dataset, int start, int end) {
        if (start < 0 || end < 0 || start > end) {
            throw new IllegalArgumentException();
        }
        this.symbol = dataset.getSymbol();
        this.symbolName = dataset.getSymbolName();
        this.startDate = dataset.getDate(start);
        this.endDate = dataset.getDate(end);
        this.period = end - start + 1;
        this.interval = dataset.getInterval();
    }

    @Override
    protected boolean isStatistics(Position p) {
        return p.isClosed();
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public double getPercentHold() {
        if (this.hold == 0 || this.period == 0) {
            return 0.0;
        }
        return (double)this.hold / (double)this.period;
    }

    public double getPercentLongHold() {
        if (this.longStats.hold == 0 || this.period == 0) {
            return 0.0;
        }
        return (double)this.winStats.hold / (double)this.period;
    }

    public double getPercentShortHold() {
        if (this.shortStats.hold == 0 || this.period == 0) {
            return 0.0;
        }
        return (double)this.lossStats.hold / (double)this.period;
    }

    public int getPeriod() {
        return this.period;
    }

    public TimeSeriesDataset.Interval getInterval() {
        return this.interval;
    }

    public WinLossStats getLongStats() {
        return this.longStats;
    }

    public WinLossStats getShortStats() {
        return this.shortStats;
    }

    public int getLongTrades() {
        return this.getLongStats().getCount();
    }

    public int getShortTrades() {
        return this.getShortStats().getCount();
    }
}

