/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.orangesignal.trading.commission;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jp.sourceforge.orangesignal.trading.commission.Commission;
import jp.sourceforge.orangesignal.trading.commission.CommissionUnit;

public class CommissionSystem
implements Commission,
Serializable {
    private static final long serialVersionUID = 6836911131954296597L;
    private List<CommissionUnit> commissionList = new ArrayList<CommissionUnit>();

    public CommissionSystem() {
    }

    public CommissionSystem(CommissionUnit unit) {
        this.addCommission(unit);
    }

    public CommissionSystem(List<CommissionUnit> list) {
        this.setCommissionList(list);
    }

    public List<CommissionUnit> getCommissionList() {
        return this.commissionList;
    }

    public void setCommissionList(List<CommissionUnit> commissionList) {
        this.commissionList = new ArrayList<CommissionUnit>();
        this.commissionList.addAll(commissionList);
        Collections.sort(this.commissionList);
    }

    public void addCommission(CommissionUnit unit) {
        this.commissionList.add(unit);
        Collections.sort(this.commissionList);
    }

    @Override
    public double calcCommission(double price, int quantity) {
        return this.getCommission(price, quantity).calcCommission(price, quantity);
    }

    private CommissionUnit getCommission(double price, int quantity) {
        return this.getCommission(new CommissionUnit(price * (double)quantity){

            @Override
            public double calcCommission(double price, int quantity) {
                return 0.0;
            }
        });
    }

    private CommissionUnit getCommission(CommissionUnit commission) {
        int index = Collections.binarySearch(this.commissionList, commission);
        if (index >= 0) {
            return this.commissionList.get(index);
        }
        index = -(index + 1);
        return this.commissionList.get(Math.min(index, this.commissionList.size() - 1));
    }
}

