/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.ta.result;

import java.io.Serializable;
import java.util.Date;

/**
 * 非時系列データの値幅情報を提供します。
 * 
 * @author 杉澤 浩二
 */
public class Step implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 初日を保持します。
	 */
	public Date openDate;

	/**
	 * 高値日を保持します。
	 */
	public Date highDate;

	/**
	 * 安値日を保持します。
	 */
	public Date lowDate;

	/**
	 * 終日を保持します。
	 */
	public Date closeDate;

	/**
	 * 始値を保持します。
	 */
	public double open;

	/**
	 * 高値を保持します。
	 */
	public double high;

	/**
	 * 安値を保持します。
	 */
	public double low;

	/**
	 * 終値を保持します。
	 */
	public double close;

	/**
	 * 期間を保持します。
	 */
	public int period;

	/**
	 * デフォルトコンストラクタです。
	 */
	protected Step() {}

	/**
	 * コンストラクタです。
	 * 
	 * @param date 日時
	 * @param price 価格
	 */
	public Step(final Date date, final double price) {
		this(date, price, 1);
	}

	/**
	 * コンストラクタです。
	 * 
	 * @param date 日時
	 * @param price 価格
	 * @param period 期間
	 */
	public Step(final Date date, final double price, final int period) {
		this.openDate	= date;
		this.highDate	= date;
		this.lowDate	= date;
		this.closeDate	= date;
		this.open		= price;
		this.high		= price;
		this.low		= price;
		this.close		= price;
		this.period		= period;
	}

}
