/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.ta.dataset;

import java.util.Date;

/**
 * 価格データのインターフェースを提供します。
 * 
 * @author 杉澤 浩二
 */
public interface PriceData {

	/**
	 * <p>日時を返します。</p>
	 * 
	 * @return 日時
	 */
	public Date getDate();

	/**
	 * 始値を返します。
	 * 
	 * @return 始値
	 */
	public Number getOpen();

	/**
	 * 高値を返します。
	 * 
	 * @return 高値
	 */
	public Number getHigh();

	/**
	 * 安値を返します。
	 * 
	 * @return 安値
	 */
	public Number getLow();

	/**
	 * 終値を返します。
	 * 
	 * @return 終値
	 */
	public Number getClose();

}
