/*
 * Copyright (c) 2008-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.ta.candle.generator;

import java.util.List;

import jp.sourceforge.orangesignal.ta.candle.TrendType;
import jp.sourceforge.orangesignal.ta.result.Step;

/**
 * 練行足(練り足)データからトレンド情報を処理するトレンドプロセッサークラスを提供します。
 * 
 * @author 杉澤 浩二
 */
public final class RenkohTrendProcessor extends StepTrendProcessor {

	/**
	 * コンストラクタです。
	 * 
	 * @param renkoh 練行足(練り足)データ
	 */
	public RenkohTrendProcessor(final List<Step> renkoh) {
		super(renkoh);
	}

	@Override
	protected TrendType getTrend(final Step renkoh) {
		if (renkoh.open < renkoh.close)
			return TrendType.UP;
		return TrendType.DOWN;
	}

}
