/*
 * Copyright (c) 2008-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.ta.candle.generator;

import jp.sourceforge.orangesignal.ta.candle.TrendType;

/**
 * パラボリック SAR データからトレンド情報を処理するトレンドプロセッサークラスを提供します。
 * 
 * @author 杉澤 浩二
 */
public final class ParabolicSarTrendProcessor implements TrendProcessor {

	/**
	 * パラボリック SAR データ
	 */
	private Number[] sar;

	/**
	 * コンストラクタです。
	 * 
	 * @param sar パラボリック SAR データ
	 */
	public ParabolicSarTrendProcessor(final Number[] sar) {
		this.sar = sar;
	}

	/**
	 * この実装は単にパラボリック SAR データとローソク足の終値を比較して判断します。
	 * <p>
	 * 判断基準は以下の通りです。
	 * <ul>
	 * <li>終値の方が低い場合は下降トレンド</li>
	 * <li>終値の方が高い場合は上昇トレンド</li>
	 * </ul>
	 * </p>
	 */
	@Override
	public void execute(final DefaultCandlestick[] c) {
		final int len = Math.min(sar.length, c.length);
		for (int i = 0; i < len; i++) {
			if (sar[i] == null || c[i] == null)
				continue;
			final double x = sar[i].doubleValue();
			if (c[i].getClose() < x)
				c[i].trend = TrendType.DOWN;
			else if (c[i].getClose() > x)
				c[i].trend = TrendType.UP;
		}
	}

}
