/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.orangesignal.ta.dataset.loader;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.orangesignal.ta.dataset.PriceData;
import jp.sourceforge.orangesignal.ta.dataset.loader.LoadException;
import jp.sourceforge.orangesignal.ta.dataset.loader.OHLCV;
import jp.sourceforge.orangesignal.ta.dataset.loader.PriceDataColumnType;
import jp.sourceforge.orangesignal.ta.dataset.loader.TextDataUtils;

public final class PriceDataLoader {
    protected static final String DEFAULT_SEPARATOR = ",";
    protected static final String DEFAULT_ENCODING = "Windows-31J";
    protected static final Map<PriceDataColumnType, Integer> DEFAULT_COLUMN_MAP = new EnumMap<PriceDataColumnType, Integer>(PriceDataColumnType.class);
    protected static final Map<String, PriceDataColumnType> DEFAULT_TITLE_MAP;
    protected static final String[] DEFAULT_DATE_PATTERNS;
    private String separator = ",";
    private String encoding = "Windows-31J";
    private Map<PriceDataColumnType, Integer> columnMap = DEFAULT_COLUMN_MAP;
    private int titleRow = 0;
    private Map<String, PriceDataColumnType> titleMap = DEFAULT_TITLE_MAP;
    private int startRow = 1;
    private String[] datePatterns = DEFAULT_DATE_PATTERNS;
    private String[] numberPatterns = null;
    private boolean ignore = true;

    public PriceDataLoader() {
    }

    public PriceDataLoader(Map<PriceDataColumnType, Integer> columnMap) {
        this.setColumnMap(columnMap);
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Map<PriceDataColumnType, Integer> getColumnMap() {
        return this.columnMap;
    }

    public void setColumnMap(Map<PriceDataColumnType, Integer> columnMap) {
        this.columnMap = columnMap;
    }

    public int getTitleRow() {
        return this.titleRow;
    }

    public void setTitleRow(int titleRow) {
        this.titleRow = titleRow;
    }

    public Map<String, PriceDataColumnType> getTitleMap() {
        return this.titleMap;
    }

    public void setTitleMap(Map<String, PriceDataColumnType> titleMap) {
        this.titleMap = titleMap;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public String[] getDatePatterns() {
        return this.datePatterns;
    }

    public void setDatePatterns(String[] datePatterns) {
        this.datePatterns = datePatterns;
    }

    public String[] getNumberPatterns() {
        return this.numberPatterns;
    }

    public void setNumberPatterns(String[] numberPatterns) {
        this.numberPatterns = numberPatterns;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public List<PriceData> load(String filename) throws IOException, IllegalStateException, LoadException {
        Map<PriceDataColumnType, Integer> map;
        List<String[]> data = TextDataUtils.read(filename, this.encoding, this.separator);
        if (this.columnMap != null) {
            map = this.columnMap;
        } else if (this.titleRow >= 0) {
            map = this.parseTitle(data.get(this.titleRow));
        } else {
            throw new IllegalStateException();
        }
        return this.toPrices(data, map, this.ignore);
    }

    private Map<PriceDataColumnType, Integer> parseTitle(String[] title) {
        EnumMap<PriceDataColumnType, Integer> results = new EnumMap<PriceDataColumnType, Integer>(PriceDataColumnType.class);
        if (title != null) {
            int length = title.length;
            for (int i = 0; i < length; ++i) {
                PriceDataColumnType key;
                String item = title[i];
                if (item == null || item.isEmpty() || (key = this.titleMap.get(item)) == null) continue;
                results.put(key, i);
            }
        }
        return results;
    }

    private List<PriceData> toPrices(List<String[]> data, Map<PriceDataColumnType, Integer> columnMap, boolean ignore) throws LoadException {
        Integer date = columnMap.get((Object)PriceDataColumnType.DATE);
        Integer open = columnMap.get((Object)PriceDataColumnType.OPEN);
        Integer high = columnMap.get((Object)PriceDataColumnType.HIGH);
        Integer low = columnMap.get((Object)PriceDataColumnType.LOW);
        Integer close = columnMap.get((Object)PriceDataColumnType.CLOSE);
        Integer volume = columnMap.get((Object)PriceDataColumnType.VOLUME);
        return this.toPrices(data, this.startRow, date, open, high, low, close, volume != null ? volume : -1, ignore);
    }

    private List<PriceData> toPrices(List<String[]> data, int start, int date, int open, int high, int low, int close, int volume, boolean ignore) throws LoadException {
        ArrayList<PriceData> results = new ArrayList<PriceData>(data.size());
        int length = data.size();
        for (int i = start; i < length; ++i) {
            try {
                PriceData price = this.toPrice(data.get(i), date, open, high, low, close, volume);
                if (price == null) continue;
                results.add(price);
                continue;
            }
            catch (Exception e) {
                if (ignore) continue;
                throw new LoadException(e.getMessage(), e);
            }
        }
        return results;
    }

    private PriceData toPrice(String[] items, int date, int open, int high, int low, int close, int volume) throws IllegalArgumentException, ParseException {
        OHLCV result = new OHLCV();
        if (items[date] == null || items[date].isEmpty()) {
            return null;
        }
        result.date = this.datePatterns != null && this.datePatterns.length > 0 ? PriceDataLoader.parseDate(items[date], this.datePatterns) : new SimpleDateFormat().parse(items[date]);
        if (this.numberPatterns != null && this.numberPatterns.length > 0) {
            result.open = PriceDataLoader.parseNumber(items[open], this.numberPatterns);
            result.high = PriceDataLoader.parseNumber(items[high], this.numberPatterns);
            result.low = PriceDataLoader.parseNumber(items[low], this.numberPatterns);
            result.close = PriceDataLoader.parseNumber(items[close], this.numberPatterns);
            if (volume >= 0) {
                result.volume = PriceDataLoader.parseNumber(items[volume], this.numberPatterns);
            }
        } else {
            result.open = Double.parseDouble(items[open]);
            result.high = Double.parseDouble(items[high]);
            result.low = Double.parseDouble(items[low]);
            result.close = Double.parseDouble(items[close]);
            if (volume >= 0) {
                result.volume = Double.parseDouble(items[volume]);
            }
        }
        return result;
    }

    private static Date parseDate(String str, String[] parsePatterns) throws IllegalArgumentException, ParseException {
        if (str == null || parsePatterns == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        SimpleDateFormat parser = null;
        ParsePosition pos = new ParsePosition(0);
        for (int i = 0; i < parsePatterns.length; ++i) {
            if (i == 0) {
                parser = new SimpleDateFormat(parsePatterns[0]);
            } else {
                parser.applyPattern(parsePatterns[i]);
            }
            pos.setIndex(0);
            Date date = parser.parse(str, pos);
            if (date == null || pos.getIndex() != str.length()) continue;
            return date;
        }
        throw new ParseException("Unable to parse the date: " + str, -1);
    }

    private static Number parseNumber(String str, String[] parsePatterns) throws IllegalArgumentException, ParseException {
        if (str == null || parsePatterns == null) {
            throw new IllegalArgumentException("Number and Patterns must not be null");
        }
        DecimalFormat parser = null;
        ParsePosition pos = new ParsePosition(0);
        for (int i = 0; i < parsePatterns.length; ++i) {
            if (i == 0) {
                parser = new DecimalFormat(parsePatterns[0]);
            } else {
                parser.applyPattern(parsePatterns[i]);
            }
            pos.setIndex(0);
            Number number = parser.parse(str, pos);
            if (number == null || pos.getIndex() != str.length()) continue;
            return number;
        }
        throw new ParseException("Unable to parse the number: " + str, -1);
    }

    static {
        DEFAULT_COLUMN_MAP.put(PriceDataColumnType.DATE, 0);
        DEFAULT_COLUMN_MAP.put(PriceDataColumnType.OPEN, 1);
        DEFAULT_COLUMN_MAP.put(PriceDataColumnType.HIGH, 2);
        DEFAULT_COLUMN_MAP.put(PriceDataColumnType.LOW, 3);
        DEFAULT_COLUMN_MAP.put(PriceDataColumnType.CLOSE, 4);
        DEFAULT_COLUMN_MAP.put(PriceDataColumnType.VOLUME, 5);
        DEFAULT_TITLE_MAP = new HashMap<String, PriceDataColumnType>();
        DEFAULT_TITLE_MAP.put("\u65e5\u6642", PriceDataColumnType.DATE);
        DEFAULT_TITLE_MAP.put("\u59cb\u5024", PriceDataColumnType.OPEN);
        DEFAULT_TITLE_MAP.put("\u9ad8\u5024", PriceDataColumnType.HIGH);
        DEFAULT_TITLE_MAP.put("\u5b89\u5024", PriceDataColumnType.LOW);
        DEFAULT_TITLE_MAP.put("\u7d42\u5024", PriceDataColumnType.CLOSE);
        DEFAULT_TITLE_MAP.put("\u51fa\u6765\u9ad8", PriceDataColumnType.VOLUME);
        DEFAULT_TITLE_MAP.put("\u65e5", PriceDataColumnType.DATE);
        DEFAULT_TITLE_MAP.put("\u59cb", PriceDataColumnType.OPEN);
        DEFAULT_TITLE_MAP.put("\u9ad8", PriceDataColumnType.HIGH);
        DEFAULT_TITLE_MAP.put("\u5b89", PriceDataColumnType.LOW);
        DEFAULT_TITLE_MAP.put("\u7d42", PriceDataColumnType.CLOSE);
        DEFAULT_TITLE_MAP.put("\u51fa", PriceDataColumnType.VOLUME);
        DEFAULT_TITLE_MAP.put("D", PriceDataColumnType.DATE);
        DEFAULT_TITLE_MAP.put("O", PriceDataColumnType.OPEN);
        DEFAULT_TITLE_MAP.put("H", PriceDataColumnType.HIGH);
        DEFAULT_TITLE_MAP.put("L", PriceDataColumnType.LOW);
        DEFAULT_TITLE_MAP.put("C", PriceDataColumnType.CLOSE);
        DEFAULT_TITLE_MAP.put("V", PriceDataColumnType.VOLUME);
        DEFAULT_TITLE_MAP.put("d", PriceDataColumnType.DATE);
        DEFAULT_TITLE_MAP.put("o", PriceDataColumnType.OPEN);
        DEFAULT_TITLE_MAP.put("h", PriceDataColumnType.HIGH);
        DEFAULT_TITLE_MAP.put("l", PriceDataColumnType.LOW);
        DEFAULT_TITLE_MAP.put("c", PriceDataColumnType.CLOSE);
        DEFAULT_TITLE_MAP.put("v", PriceDataColumnType.VOLUME);
        DEFAULT_DATE_PATTERNS = new String[]{"yyyy/MM/dd", "yyyy/M/d"};
    }
}

