/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.orangesignal.ta.dataset;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.orangesignal.ta.ArrayDataUtils;
import jp.sourceforge.orangesignal.ta.TechnicalAnalysis;
import jp.sourceforge.orangesignal.ta.dataset.DataType;
import jp.sourceforge.orangesignal.ta.dataset.DateTruncater;
import jp.sourceforge.orangesignal.ta.dataset.DefaultDataType;
import jp.sourceforge.orangesignal.ta.dataset.MarginData;
import jp.sourceforge.orangesignal.ta.dataset.PriceData;
import jp.sourceforge.orangesignal.ta.dataset.PriceVolumeData;
import jp.sourceforge.orangesignal.ta.dataset.SplitData;
import jp.sourceforge.orangesignal.ta.result.FourPrice;

public class TimeSeriesDataset {
    private String symbol;
    private String symbolName;
    private final Interval interval;
    private Date[] date;
    private Map<DataType, Number[]> dataset = new HashMap<DataType, Number[]>();
    private boolean splited = false;

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    public void setSymbolName(String symbolName) {
        this.symbolName = symbolName;
    }

    protected TimeSeriesDataset(Interval interval) {
        if (interval == null) {
            throw new NullPointerException("Interval is null.");
        }
        this.interval = interval;
    }

    public TimeSeriesDataset(Interval interval, PriceData[] price) {
        this(interval, price, null, null);
    }

    public TimeSeriesDataset(Interval interval, PriceData[] price, MarginData[] margin, SplitData[] split) {
        this(interval);
        if (price == null) {
            throw new NullPointerException("Price is null.");
        }
        this.setupPrice(price);
        if (margin != null) {
            this.setupMargin(margin);
        }
        if (split != null) {
            this.setupSplit(split);
        }
    }

    public TimeSeriesDataset(TimeSeriesDataset dataset) {
        this.symbol = dataset.symbol;
        this.symbolName = dataset.symbolName;
        this.interval = dataset.interval;
        this.date = (Date[])dataset.date.clone();
        this.dataset.putAll(dataset.dataset);
        this.splited = dataset.splited;
    }

    private void setupPrice(PriceData[] price) {
        int length = price.length;
        Date[] date = new Date[length];
        Number[] open = new Number[length];
        Number[] high = new Number[length];
        Number[] low = new Number[length];
        Number[] close = new Number[length];
        Number[] volume = new Number[length];
        boolean use_volume = false;
        for (int i = 0; i < length; ++i) {
            PriceVolumeData v;
            PriceData o = price[i];
            if (o == null) continue;
            if (o.getDate() == null) {
                throw new NullPointerException("Date is null.");
            }
            date[i] = o.getDate();
            open[i] = o.getOpen();
            high[i] = o.getHigh();
            low[i] = o.getLow();
            close[i] = o.getClose();
            if (!(o instanceof PriceVolumeData) || (v = (PriceVolumeData)o).getVolume() == null) continue;
            volume[i] = v.getVolume();
            use_volume = true;
        }
        this.setDate(date);
        this.setOpen(open);
        this.setHigh(high);
        this.setLow(low);
        this.setClose(close);
        if (use_volume) {
            this.setVolume(volume);
        }
    }

    private void setupMargin(MarginData[] margin) {
        int length = this.getLength();
        Number[] sold = new Number[length];
        Number[] bought = new Number[length];
        int pos = 0;
        Number prev_sold = null;
        Number prev_bought = null;
        for (MarginData o : margin) {
            if (o == null || o.getDate() == null) continue;
            while (pos < length && this.getDate(pos).compareTo(o.getDate()) < 0) {
                sold[pos] = prev_sold;
                bought[pos] = prev_bought;
                ++pos;
            }
            prev_sold = o.getSold();
            prev_bought = o.getBought();
        }
        while (pos < length) {
            sold[pos] = prev_sold;
            bought[pos] = prev_bought;
            ++pos;
        }
        this.setSold(sold);
        this.setBought(bought);
    }

    private void setupSplit(SplitData[] split) {
        int length = this.getLength();
        Number[] results = new Number[length];
        int pos = 0;
        block0: for (SplitData o : split) {
            if (o == null || o.getDate() == null || o.getSplit() == null) continue;
            for (int i = pos; i < length; ++i) {
                int c = this.getDate(i).compareTo(o.getDate());
                if (c == 0) {
                    results[i] = o.getSplit().doubleValue();
                    pos = i + 1;
                    continue block0;
                }
                if (c > 0) continue block0;
            }
        }
        this.setSplit(results);
    }

    public final Interval getInterval() {
        return this.interval;
    }

    public final int getLength() {
        return this.date == null ? 0 : this.date.length;
    }

    public final Date[] getDate() {
        return this.date;
    }

    private final void setDate(Date[] date) {
        this.date = date;
    }

    public final Date getDate(int i) {
        return this.date[i];
    }

    public final int indexOf(Date find) {
        return ArrayDataUtils.indexOf(this.date, find);
    }

    public final int lastIndexOf(Date find) {
        return ArrayDataUtils.lastIndexOf(this.date, find);
    }

    public final int defaultIndexOf(Date find) {
        int result = -1;
        if (find != null) {
            result = ArrayDataUtils.indexOf(this.date, find);
        }
        if (result != -1) {
            return result;
        }
        return ArrayDataUtils.indexOfNotNull(this.date);
    }

    public final int defaultLastIndexOf(Date find) {
        int result = -1;
        if (find != null) {
            result = ArrayDataUtils.lastIndexOf(this.date, find);
        }
        if (result != -1) {
            return result;
        }
        return ArrayDataUtils.lastIndexOfNotNull(this.date);
    }

    public final int getPeriod(Date start, Date end) {
        int startIndex = this.indexOf(start);
        int endIndex = this.lastIndexOf(end);
        if (startIndex != -1 && endIndex != -1) {
            return endIndex - startIndex + 1;
        }
        return 0;
    }

    public final Number[] getPrice(FourPrice type) {
        switch (type) {
            case OPEN: {
                return this.getOpen();
            }
            case HIGH: {
                return this.getHigh();
            }
            case LOW: {
                return this.getLow();
            }
            case CLOSE: {
                return this.getClose();
            }
        }
        return null;
    }

    public final Number[] getOpen() {
        return this.getData(DefaultDataType.OPEN);
    }

    private final void setOpen(Number[] open) {
        this.dataset.put(DefaultDataType.OPEN, open);
    }

    public final Number getOpen(int i) {
        return this.getData(DefaultDataType.OPEN)[i];
    }

    public final Number[] getHigh() {
        return this.getData(DefaultDataType.HIGH);
    }

    private final void setHigh(Number[] high) {
        this.setData(DefaultDataType.HIGH, high);
    }

    public final Number getHigh(int i) {
        return this.getData(DefaultDataType.HIGH)[i];
    }

    public final Number[] getLow() {
        return this.getData(DefaultDataType.LOW);
    }

    private final void setLow(Number[] low) {
        this.setData(DefaultDataType.LOW, low);
    }

    public final Number getLow(int i) {
        return this.getData(DefaultDataType.LOW)[i];
    }

    public final Number[] getClose() {
        return this.getData(DefaultDataType.CLOSE);
    }

    private final void setClose(Number[] close) {
        this.setData(DefaultDataType.CLOSE, close);
    }

    public final Number getClose(int i) {
        return this.getData(DefaultDataType.CLOSE)[i];
    }

    public final Number[] getVolume() {
        return this.getData(DefaultDataType.VOLUME);
    }

    private final void setVolume(Number[] volume) {
        this.setData(DefaultDataType.VOLUME, volume);
    }

    public final Number getVolume(int i) {
        return this.getData(DefaultDataType.VOLUME)[i];
    }

    public final Number[] getSold() {
        return this.getData(DefaultDataType.SOLD);
    }

    private final void setSold(Number[] sold) {
        this.setData(DefaultDataType.SOLD, sold);
    }

    public final Number getSold(int i) {
        return this.getData(DefaultDataType.SOLD)[i];
    }

    public final Number[] getBought() {
        return this.getData(DefaultDataType.BOUGHT);
    }

    private final void setBought(Number[] bought) {
        this.setData(DefaultDataType.BOUGHT, bought);
    }

    public final Number getBought(int i) {
        return this.getData(DefaultDataType.BOUGHT)[i];
    }

    public final Number[] getSplit() {
        return this.getData(DefaultDataType.SPLIT);
    }

    private final void setSplit(Number[] split) {
        this.setData(DefaultDataType.SPLIT, split);
    }

    public final Number getSplit(int i) {
        return this.getData(DefaultDataType.SPLIT)[i];
    }

    protected Number[] getData(DataType type) {
        return this.dataset.get(type);
    }

    protected final void setData(DataType type, Number[] data) {
        if (!ArrayDataUtils.isSameLength(this.getDate(), data)) {
            throw new IllegalArgumentException();
        }
        this.dataset.put(type, data);
    }

    public final boolean isSplited() {
        return this.splited;
    }

    public final TimeSeriesDataset split() {
        if (this.isSplited() || this.getSplit() == null) {
            return this;
        }
        TimeSeriesDataset result = new TimeSeriesDataset(this);
        Map<FourPrice, Number[]> prices = TechnicalAnalysis.split(this.getOpen(), this.getHigh(), this.getLow(), this.getClose(), this.getSplit());
        result.setOpen(prices.get((Object)FourPrice.OPEN));
        result.setHigh(prices.get((Object)FourPrice.HIGH));
        result.setLow(prices.get((Object)FourPrice.LOW));
        result.setClose(prices.get((Object)FourPrice.CLOSE));
        result.splited = true;
        return result;
    }

    public void extend(int space) {
        if (space == 0) {
            return;
        }
        HashMap<DataType, Number[]> dataset = new HashMap<DataType, Number[]>((int)Math.ceil((double)this.dataset.size() * 1.5));
        for (Map.Entry<DataType, Number[]> entry : this.dataset.entrySet()) {
            dataset.put(entry.getKey(), ArrayDataUtils.extend(entry.getValue(), space));
        }
        this.date = ArrayDataUtils.extend(this.date, space);
        this.dataset = dataset;
    }

    public TimeSeriesDataset compress(Interval target) {
        return this.compress(target, Calendar.getInstance());
    }

    public TimeSeriesDataset compress(Interval target, Calendar calendar) {
        return this.compress(target, calendar, new DateTruncater());
    }

    public TimeSeriesDataset compress(Interval target, Calendar calendar, DateTruncater truncater) {
        if (this.interval.ordinal() > target.ordinal()) {
            throw new IllegalArgumentException();
        }
        if (this.interval == target) {
            return this;
        }
        int mapCapacity = (int)Math.ceil((double)this.dataset.size() * 1.5);
        ArrayList<Date> compress_date = new ArrayList<Date>();
        HashMap<DataType, List<Number>> compress_values = new HashMap<DataType, List<Number>>(mapCapacity);
        boolean init = false;
        Date _date = null;
        HashMap<DataType, Double> _values = null;
        Calendar term = truncater.truncate(calendar, 1);
        Calendar c = (Calendar)calendar.clone();
        int truncate = TimeSeriesDataset.getTruncate(target);
        int max = this.getLength();
        Number[] open = this.getOpen();
        Number[] high = this.getHigh();
        Number[] low = this.getLow();
        Number[] close = this.getClose();
        for (int i = 0; i < max; ++i) {
            Date date = this.date[i];
            if (date == null) continue;
            c.setTime(date);
            Calendar current = truncater.truncate(c, truncate);
            if (init && current.after(term)) {
                compress_date.add(_date);
                TimeSeriesDataset.add(_values, compress_values);
                init = false;
            }
            if (!init) {
                _date = (Date)date.clone();
                _values = new HashMap<DataType, Double>(mapCapacity);
                term = current;
                init = true;
            }
            if (open[i] == null || high[i] == null || low[i] == null || close[i] == null) continue;
            block8: for (Map.Entry<DataType, Number[]> entry : this.dataset.entrySet()) {
                DataType type = entry.getKey();
                Number[] data = entry.getValue();
                if (type == null || data == null) continue;
                if (_values.get(type) == null) {
                    _values.put(type, data[i] != null ? Double.valueOf(data[i].doubleValue()) : null);
                    continue;
                }
                if (data[i] == null) continue;
                switch (type.getCompressType()) {
                    case FIRST: {
                        continue block8;
                    }
                    case HIGHEST: {
                        if (!(((Number)_values.get(type)).doubleValue() < data[i].doubleValue())) continue block8;
                        _values.put(type, data[i].doubleValue());
                        continue block8;
                    }
                    case LOWEST: {
                        if (!(((Number)_values.get(type)).doubleValue() > data[i].doubleValue())) continue block8;
                        _values.put(type, data[i].doubleValue());
                        continue block8;
                    }
                    case LAST: {
                        _values.put(type, data[i].doubleValue());
                        continue block8;
                    }
                    case SUM: {
                        _values.put(type, ((Number)_values.get(type)).doubleValue() + data[i].doubleValue());
                        continue block8;
                    }
                }
                throw new RuntimeException();
            }
        }
        if (_date != null) {
            compress_date.add(_date);
            TimeSeriesDataset.add(_values, compress_values);
        }
        TimeSeriesDataset result = new TimeSeriesDataset(target);
        result.date = compress_date.toArray(new Date[0]);
        for (Map.Entry entry : compress_values.entrySet()) {
            result.setData((DataType)entry.getKey(), ((List)entry.getValue()).toArray(new Number[0]));
        }
        result.splited = this.splited;
        return result;
    }

    private static void add(Map<DataType, Number> row, Map<DataType, List<Number>> rows) {
        for (Map.Entry<DataType, Number> entry : row.entrySet()) {
            DataType key = entry.getKey();
            List<Number> list = rows.get(key);
            if (list == null) {
                list = new ArrayList<Number>();
            }
            list.add(entry.getValue());
            rows.put(key, list);
        }
    }

    private static int getTruncate(Interval target) {
        switch (target) {
            case MONTHLY: {
                return 5;
            }
            case WEEKLY: {
                return 7;
            }
            case DAILY: {
                return 11;
            }
            case HOURLY: {
                return 12;
            }
        }
        throw new IllegalArgumentException();
    }

    public static enum Interval {
        MINUTELY{

            @Override
            public int getMaxPeriod() {
                return 60;
            }
        }
        ,
        HOURLY{

            @Override
            public int getMaxPeriod() {
                return 24;
            }
        }
        ,
        DAILY{

            @Override
            public int getMaxPeriod() {
                return 365;
            }
        }
        ,
        WEEKLY{

            @Override
            public int getMaxPeriod() {
                return 52;
            }
        }
        ,
        MONTHLY{

            @Override
            public int getMaxPeriod() {
                return 12;
            }
        };


        public abstract int getMaxPeriod();
    }
}

