/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.orangesignal.ta.candle;

import jp.sourceforge.orangesignal.ta.candle.Candlestick;
import jp.sourceforge.orangesignal.ta.candle.TrendSignal;
import jp.sourceforge.orangesignal.ta.candle.TrendType;

public class ChartPatterns {
    protected ChartPatterns() {
    }

    public static TrendSignal[] openCloseReversal(Candlestick[] c, boolean trend) {
        int length = c.length;
        TrendSignal[] results = new TrendSignal[length];
        for (int i = 1; i < length; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null) continue;
            if (!trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_2].isNearOpen(c[_2].getHigh()) && c[_2].isNearClose(c[_2].getLow()) && c[_1].getClose() < c[_2].getClose()) {
                results[i] = TrendSignal.BULLISH;
                continue;
            }
            if (!(!trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN) || !c[_2].isNearOpen(c[_2].getLow()) || !c[_2].isNearClose(c[_2].getHigh()) || !(c[_1].getClose() > c[_2].getClose())) continue;
            results[i] = TrendSignal.BEARLISH;
        }
        return results;
    }

    public static TrendSignal[] closingPriceReversal(Candlestick[] c, boolean trend) {
        int length = c.length;
        TrendSignal[] results = new TrendSignal[length];
        for (int i = 2; i < length; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            if (c[_1].getLow() > c[_2].getLow() && c[_1].getClose() < c[_2].getClose() && c[_3].isCloseInTopQuarter()) {
                results[i] = TrendSignal.BULLISH;
                continue;
            }
            if (!(c[_1].getHigh() <= c[_2].getHigh()) || !(c[_1].getClose() >= c[_2].getClose()) || !c[_3].isCloseInBottomQuarter()) continue;
            results[i] = TrendSignal.BEARLISH;
        }
        return results;
    }

    public static TrendSignal[] hookReversal(Candlestick[] c, boolean trend) {
        int length = c.length;
        TrendSignal[] results = new TrendSignal[length];
        for (int i = 1; i < length; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null || !(c[_1].getHigh() > c[_2].getHigh()) || !(c[_1].getLow() < c[_2].getLow())) continue;
            if (!trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_2].isNearHigh(c[_2].getOpen()) && c[_2].isNearLow(c[_2].getClose())) {
                results[i] = TrendSignal.BEARLISH;
                continue;
            }
            if (!(!trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN) || !c[_2].isNearHigh(c[_2].getClose()) || !c[_2].isNearLow(c[_2].getOpen())) continue;
            results[i] = TrendSignal.BULLISH;
        }
        return results;
    }

    public static TrendSignal[] keyReversal(Candlestick[] c, boolean trend) {
        int length = c.length;
        TrendSignal[] results = new TrendSignal[length];
        for (int i = 1; i < length; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null || !(c[_1].getHigh() < c[_2].getHigh()) || !(c[_1].getLow() > c[_2].getLow())) continue;
            if (!trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].getClose() < c[_2].getOpen() && c[_1].getLow() >= c[_2].getClose()) {
                results[i] = TrendSignal.BEARLISH;
                continue;
            }
            if (!(!trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN) || !(c[_1].getClose() > c[_2].getOpen()) || !(c[_1].getHigh() <= c[_2].getClose())) continue;
            results[i] = TrendSignal.BULLISH;
        }
        return results;
    }

    public static TrendSignal[] islandReversal(Candlestick[] c, boolean trend) {
        int length = c.length;
        TrendSignal[] results = new TrendSignal[length];
        for (int i = 2; i < length; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            if (!trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.UP && c[_1].gapUp(c[_2]) && c[_2].gapDown(c[_3])) {
                results[i] = TrendSignal.BULLISH;
                continue;
            }
            if (!(!trend | c[_1].getTrend() == null | c[_1].getTrend() == TrendType.DOWN) || !c[_1].gapDown(c[_2]) || !c[_2].gapUp(c[_3])) continue;
            results[i] = TrendSignal.BEARLISH;
        }
        return results;
    }

    public static TrendSignal[] threeBarRule(Candlestick[] c) {
        int length = c.length;
        TrendSignal[] results = new TrendSignal[length];
        for (int i = 2; i < length; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            if (c[_1].getClose() >= c[_1].median() && c[_2].getClose() >= c[_2].median() && c[_3].isCloseInTopQuarter()) {
                results[i] = TrendSignal.BULLISH;
                continue;
            }
            if (!(c[_1].getClose() <= c[_1].median()) || !(c[_2].getClose() <= c[_2].median()) || !c[_3].isCloseInBottomQuarter()) continue;
            results[i] = TrendSignal.BEARLISH;
        }
        return results;
    }

    public static TrendSignal[] gapRule(Candlestick[] c) {
        int length = c.length;
        TrendSignal[] results = new TrendSignal[length];
        for (int i = 2; i < length; ++i) {
            int _1 = i - 2;
            int _2 = i - 1;
            int _3 = i;
            if (c[_1] == null || c[_2] == null || c[_3] == null) continue;
            if (c[_1].getHigh() < c[_2].getLow() && c[_2].isCloseInTopQuarter() && c[_3].isCloseInTopQuarter()) {
                results[i] = TrendSignal.BULLISH;
                continue;
            }
            if (!(c[_1].getLow() > c[_2].getHigh()) || !c[_2].isCloseInBottomQuarter() || !c[_3].isCloseInBottomQuarter()) continue;
            results[i] = TrendSignal.BEARLISH;
        }
        return results;
    }

    public static TrendSignal[] highLowReversal(Candlestick[] c) {
        double diff = 0.05;
        int length = c.length;
        TrendSignal[] results = new TrendSignal[length];
        for (int i = 1; i < length; ++i) {
            int _1 = i - 1;
            int _2 = i;
            if (c[_1] == null || c[_2] == null) continue;
            if (c[_1].getClose() >= c[_1].getHigh() - 0.05 && c[_2].getClose() <= c[_2].getLow() + 0.05) {
                results[i] = TrendSignal.BEARLISH;
                continue;
            }
            if (!(c[_2].getClose() >= c[_2].getHigh() - 0.05) || !(c[_1].getClose() <= c[_1].getLow() + 0.05)) continue;
            results[i] = TrendSignal.BULLISH;
        }
        return results;
    }
}

