/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.orangesignal.ta;

import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.orangesignal.ta.ArrayDataUtils;
import jp.sourceforge.orangesignal.ta.CrossSignal;
import jp.sourceforge.orangesignal.ta.MovingAverage;
import jp.sourceforge.orangesignal.ta.PercentageScale;
import jp.sourceforge.orangesignal.ta.result.Aroon;
import jp.sourceforge.orangesignal.ta.result.Bands2;
import jp.sourceforge.orangesignal.ta.result.Bands5;
import jp.sourceforge.orangesignal.ta.result.Bands7;
import jp.sourceforge.orangesignal.ta.result.Changes;
import jp.sourceforge.orangesignal.ta.result.DMI;
import jp.sourceforge.orangesignal.ta.result.FourPrice;
import jp.sourceforge.orangesignal.ta.result.Histogram;
import jp.sourceforge.orangesignal.ta.result.Ichimoku;
import jp.sourceforge.orangesignal.ta.result.MESA;
import jp.sourceforge.orangesignal.ta.result.Shinohara;
import jp.sourceforge.orangesignal.ta.result.Step;
import jp.sourceforge.orangesignal.ta.result.Stochastics;

public class TechnicalAnalysis {
    protected TechnicalAnalysis() {
    }

    public static Number[] add(Number[] a, Number[] b) {
        int length = ArrayDataUtils.getMinLength(a, b);
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (a[i] == null || b[i] == null) continue;
            results[i] = a[i].doubleValue() + b[i].doubleValue();
        }
        return results;
    }

    public static Number[] add(Number[] a, Number b) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{a});
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (a[i] == null) continue;
            results[i] = a[i].doubleValue() + b.doubleValue();
        }
        return results;
    }

    public static Number[] sub(Number[] a, Number[] b) {
        int length = ArrayDataUtils.getMinLength(a, b);
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (a[i] == null || b[i] == null) continue;
            results[i] = a[i].doubleValue() - b[i].doubleValue();
        }
        return results;
    }

    public static Number[] sub(Number[] a, Number b) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{a});
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (a[i] == null) continue;
            results[i] = a[i].doubleValue() - b.doubleValue();
        }
        return results;
    }

    public static Number[] mult(Number[] a, Number[] b) {
        int length = ArrayDataUtils.getMinLength(a, b);
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (a[i] == null || b[i] == null) continue;
            results[i] = a[i].doubleValue() * b[i].doubleValue();
        }
        return results;
    }

    public static Number[] mult(Number[] a, Number b) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{a});
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (a[i] == null) continue;
            results[i] = a[i].doubleValue() * b.doubleValue();
        }
        return results;
    }

    public static Number[] div(Number[] a, Number[] b) {
        int length = ArrayDataUtils.getMinLength(a, b);
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (a[i] == null || b[i] == null) continue;
            double _a = a[i].doubleValue();
            double _b = b[i].doubleValue();
            results[i] = _a == 0.0 || _b == 0.0 ? Double.valueOf(0.0) : Double.valueOf(_a / _b);
        }
        return results;
    }

    public static Number[] div(Number[] a, Number b) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{a});
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (a[i] == null) continue;
            double _a = a[i].doubleValue();
            double _b = b.doubleValue();
            results[i] = _a == 0.0 || _b == 0.0 ? Double.valueOf(0.0) : Double.valueOf(_a / _b);
        }
        return results;
    }

    public static Number[] avg(Number[] a, Number[] b) {
        int length = ArrayDataUtils.getMinLength(a, b);
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (a[i] == null || b[i] == null) continue;
            results[i] = (a[i].doubleValue() + b[i].doubleValue()) * 0.5;
        }
        return results;
    }

    public static Number[] avg(Number[] a, Number[] b, Number[] c) {
        int length = ArrayDataUtils.getMinLength(a, b, c);
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (a[i] == null || b[i] == null || c[i] == null) continue;
            double sum = a[i].doubleValue() + b[i].doubleValue() + c[i].doubleValue();
            results[i] = sum == 0.0 ? Double.valueOf(0.0) : Double.valueOf(sum / 3.0);
        }
        return results;
    }

    public static Number[] avg(Number[] a, Number[] b, Number[] c, Number[] d) {
        int length = ArrayDataUtils.getMinLength(a, b, c, d);
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (a[i] == null || b[i] == null || c[i] == null || d[i] == null) continue;
            results[i] = (a[i].doubleValue() + b[i].doubleValue() + c[i].doubleValue() + d[i].doubleValue()) * 0.25;
        }
        return results;
    }

    public static Number[] sin(Number[] a) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{a});
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (a[i] == null) continue;
            results[i] = Math.sin(a[i].doubleValue());
        }
        return results;
    }

    public static Number[] cos(Number[] a) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{a});
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (a[i] == null) continue;
            results[i] = Math.cos(a[i].doubleValue());
        }
        return results;
    }

    public static Number[] tan(Number[] a) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{a});
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (a[i] == null) continue;
            results[i] = Math.tan(a[i].doubleValue());
        }
        return results;
    }

    public static Number[] asin(Number[] a) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{a});
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (a[i] == null) continue;
            results[i] = Math.asin(a[i].doubleValue());
        }
        return results;
    }

    public static Number[] acos(Number[] a) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{a});
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (a[i] == null) continue;
            results[i] = Math.acos(a[i].doubleValue());
        }
        return results;
    }

    public static Number[] atan(Number[] a) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{a});
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (a[i] == null) continue;
            results[i] = Math.atan(a[i].doubleValue());
        }
        return results;
    }

    public static Number[] exp(Number[] a) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{a});
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (a[i] == null) continue;
            results[i] = Math.exp(a[i].doubleValue());
        }
        return results;
    }

    public static Number[] log(Number[] a) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{a});
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (a[i] == null) continue;
            results[i] = Math.log(a[i].doubleValue());
        }
        return results;
    }

    public static Number[] log10(Number[] a) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{a});
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (a[i] == null) continue;
            results[i] = Math.log10(a[i].doubleValue());
        }
        return results;
    }

    public static Number[] sqrt(Number[] a) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{a});
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (a[i] == null) continue;
            results[i] = Math.sqrt(a[i].doubleValue());
        }
        return results;
    }

    public static Number[] ceil(Number[] a) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{a});
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (a[i] == null) continue;
            results[i] = Math.ceil(a[i].doubleValue());
        }
        return results;
    }

    public static Number[] floor(Number[] a) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{a});
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (a[i] == null) continue;
            results[i] = Math.floor(a[i].doubleValue());
        }
        return results;
    }

    public static Number[] round(Number[] a) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{a});
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (a[i] == null) continue;
            results[i] = Math.round(a[i].doubleValue());
        }
        return results;
    }

    public static Number[] abs(Number[] a) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{a});
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (a[i] == null) continue;
            results[i] = Math.abs(a[i].doubleValue());
        }
        return results;
    }

    public static Number[] max(Number[] a, Number[] b) {
        int length = ArrayDataUtils.getMinLength(a, b);
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (a[i] == null || b[i] == null) continue;
            results[i] = Math.max(a[i].doubleValue(), b[i].doubleValue());
        }
        return results;
    }

    public static Number[] min(Number[] a, Number[] b) {
        int length = ArrayDataUtils.getMinLength(a, b);
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (a[i] == null || b[i] == null) continue;
            results[i] = Math.min(a[i].doubleValue(), b[i].doubleValue());
        }
        return results;
    }

    public static Number[] sinh(Number[] x) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (x[i] == null) continue;
            results[i] = Math.sinh(x[i].doubleValue());
        }
        return results;
    }

    public static Number[] cosh(Number[] x) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (x[i] == null) continue;
            results[i] = Math.cosh(x[i].doubleValue());
        }
        return results;
    }

    public static Number[] tanh(Number[] x) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (x[i] == null) continue;
            results[i] = Math.tanh(x[i].doubleValue());
        }
        return results;
    }

    public static Number[] sum(Number[] x, int period) {
        if (period <= 0) {
            throw new IllegalArgumentException();
        }
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        for (int i = period - 1; i < length; ++i) {
            if (x[i] == null) continue;
            double sum = 0.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (x[j] == null) continue;
                sum += x[j].doubleValue();
            }
            results[i] = sum;
        }
        return results;
    }

    public static Number[] highest(Number[] x, int period) {
        if (period <= 0) {
            throw new IllegalArgumentException();
        }
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        for (int i = period - 1; i < length; ++i) {
            if (x[i] == null) continue;
            Number high = null;
            for (int j = i - period + 1; j <= i; ++j) {
                if (x[j] == null || high != null && !(high.doubleValue() < x[j].doubleValue())) continue;
                high = x[j];
            }
            results[i] = high;
        }
        return results;
    }

    public static Number[] lowest(Number[] x, int period) {
        if (period <= 0) {
            throw new IllegalArgumentException();
        }
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        for (int i = period - 1; i < length; ++i) {
            if (x[i] == null) continue;
            Number low = null;
            for (int j = i - period + 1; j <= i; ++j) {
                if (x[j] == null || low != null && !(low.doubleValue() > x[j].doubleValue())) continue;
                low = x[j];
            }
            results[i] = low;
        }
        return results;
    }

    public static Number[] periodsSinceHighest(Number[] x, int period) {
        if (period <= 0) {
            throw new IllegalArgumentException();
        }
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        for (int i = period - 1; i < length; ++i) {
            if (x[i] == null) continue;
            Number high = null;
            int since = 0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (x[j] == null || high != null && !(high.doubleValue() < x[j].doubleValue())) continue;
                high = x[j];
                since = j;
            }
            results[i] = i - since;
        }
        return results;
    }

    public static Number[] periodsSinceLowest(Number[] x, int period) {
        if (period <= 0) {
            throw new IllegalArgumentException();
        }
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        for (int i = period - 1; i < length; ++i) {
            if (x[i] == null) continue;
            Number low = null;
            int since = 0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (x[j] == null || low != null && !(low.doubleValue() > x[j].doubleValue())) continue;
                low = x[j];
                since = j;
            }
            results[i] = i - since;
        }
        return results;
    }

    public static Number[] midpoint(Number[] x, int period) {
        return TechnicalAnalysis.avg(TechnicalAnalysis.highest(x, period), TechnicalAnalysis.lowest(x, period));
    }

    public static Number[] midprice(Number[] high, Number[] low, int period) {
        return TechnicalAnalysis.avg(TechnicalAnalysis.highest(high, period), TechnicalAnalysis.lowest(low, period));
    }

    protected static Number[] var(Number[] x, int period, boolean biased) {
        int n;
        int n2 = n = biased ? period : period - 1;
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        for (int i = period - 1; i < length; ++i) {
            if (x[i] == null) continue;
            double sum = 0.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (x[j] == null) continue;
                sum += x[j].doubleValue();
            }
            double mean = sum == 0.0 ? 0.0 : sum / (double)period;
            double ss = 0.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (x[j] == null) continue;
                ss += Math.pow(mean - x[j].doubleValue(), 2.0);
            }
            results[i] = ss == 0.0 ? 0.0 : ss / (double)n;
        }
        return results;
    }

    public static Number[] var(Number[] x, int period) {
        return TechnicalAnalysis.var(x, period, false);
    }

    public static Number[] varp(Number[] x, int period) {
        return TechnicalAnalysis.var(x, period, true);
    }

    public static Number[] stddev(Number[] x, int period) {
        return TechnicalAnalysis.sqrt(TechnicalAnalysis.var(x, period));
    }

    public static Number[] stddevp(Number[] x, int period) {
        return TechnicalAnalysis.sqrt(TechnicalAnalysis.varp(x, period));
    }

    protected static Number[] covar(Number[] x, Number[] y, int period, boolean biased) {
        int n;
        int n2 = n = biased ? period : period - 1;
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        int length = ArrayDataUtils.getMinLength(x, y);
        Number[] results = new Number[length];
        for (int i = period - 1; i < length; ++i) {
            double sum_x = 0.0;
            double sum_y = 0.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (x[j] != null) {
                    sum_x += x[j].doubleValue();
                }
                if (y[j] == null) continue;
                sum_y += y[j].doubleValue();
            }
            double mean_x = sum_x / (double)period;
            double mean_y = sum_y / (double)period;
            double sum = 0.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (x[j] == null || y[j] == null) continue;
                sum += (mean_x - x[j].doubleValue()) * (mean_y - y[j].doubleValue());
            }
            results[i] = sum == 0.0 ? 0.0 : sum / (double)n;
        }
        return results;
    }

    public static Number[] covar(Number[] x, Number[] y, int period) {
        return TechnicalAnalysis.covar(x, y, period, true);
    }

    public static Number[] covarn(Number[] x, Number[] y, int period) {
        return TechnicalAnalysis.covar(x, y, period, false);
    }

    public static Number[] correl(Number[] x, Number[] y, int period, boolean biased) {
        int n;
        int n2 = n = biased ? period : period - 1;
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        int length = ArrayDataUtils.getMinLength(x, y);
        Number[] results = new Number[length];
        for (int i = period - 1; i < length; ++i) {
            double sum_x = 0.0;
            double sum_y = 0.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (x[j] != null) {
                    sum_x += x[j].doubleValue();
                }
                if (y[j] == null) continue;
                sum_y += y[j].doubleValue();
            }
            double mean_x = sum_x / (double)period;
            double mean_y = sum_y / (double)period;
            double ss_x = 0.0;
            double ss_y = 0.0;
            double sum = 0.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (x[j] != null) {
                    ss_x += Math.pow(mean_x - x[j].doubleValue(), 2.0);
                }
                if (y[j] != null) {
                    ss_y += Math.pow(mean_y - y[j].doubleValue(), 2.0);
                }
                if (x[j] == null || y[j] == null) continue;
                sum += (mean_x - x[j].doubleValue()) * (mean_y - y[j].doubleValue());
            }
            if (sum == 0.0 || ss_x == 0.0 || ss_y == 0.0) {
                results[i] = 0.0;
                continue;
            }
            double cov = sum / (double)n;
            double stddev_x = Math.sqrt(ss_x / (double)n);
            double stddev_y = Math.sqrt(ss_y / (double)n);
            results[i] = cov / (stddev_x * stddev_y);
        }
        return results;
    }

    public static Number[] correl(Number[] x, Number[] y, int period) {
        return TechnicalAnalysis.correl(x, y, period, true);
    }

    public static Number[] pearson(Number[] x, Number[] y, int period) {
        return TechnicalAnalysis.correl(x, y, period, true);
    }

    public static Map<Bands5, Number[]> lr(Number[] x, int period, int reserved) {
        if (period <= 0) {
            throw new IllegalArgumentException();
        }
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] upper2 = new Number[length];
        Number[] upper1 = new Number[length];
        Number[] lr = new Number[length];
        Number[] lower1 = new Number[length];
        Number[] lower2 = new Number[length];
        int end = Math.max(length - reserved, 0);
        int start = Math.max(end - period, 0);
        int y = 0;
        double sum_x = 0.0;
        double sum_y = 0.0;
        for (int i = start; i < end; ++i) {
            if (x[i] != null) {
                sum_x += x[i].doubleValue();
            }
            sum_y += (double)(++y);
        }
        int p = y;
        double mean_x = sum_x / (double)p;
        double mean_y = sum_y / (double)p;
        double sum_xy = 0.0;
        double ss_y = 0.0;
        y = 0;
        for (int i = start; i < end; ++i) {
            double dy = (double)(++y) - mean_y;
            ss_y += Math.pow(dy, 2.0);
            if (x[i] == null) continue;
            double dx = x[i].doubleValue() - mean_x;
            sum_xy += dy * dx;
        }
        double b = sum_xy / ss_y;
        double a = mean_x - b * mean_y;
        double _sum = 0.0;
        double _x = 0.0;
        for (int i = start; i < end; ++i) {
            double value = a + b * (double)(i - start);
            lr[i] = value;
            _x += Math.pow(value, 2.0);
            _sum += value;
        }
        double sd = Math.sqrt(((double)p * _x - Math.pow(_sum, 2.0)) / (double)(p * (p - 1)));
        for (int i = start; i < end; ++i) {
            if (lr[i] == null) continue;
            double value = lr[i].doubleValue();
            upper2[i] = value + sd * 2.0;
            upper1[i] = value + sd;
            lower1[i] = value - sd;
            lower2[i] = value - sd * 2.0;
        }
        EnumMap<Bands5, Number[]> map = new EnumMap<Bands5, Number[]>(Bands5.class);
        map.put(Bands5.UPPER_BAND2, upper2);
        map.put(Bands5.UPPER_BAND1, upper1);
        map.put(Bands5.MIDDLE_BAND, lr);
        map.put(Bands5.LOWER_BAND1, lower1);
        map.put(Bands5.LOWER_BAND2, lower2);
        return map;
    }

    @Deprecated
    protected static Number[] beta(Number[] roc_x, Number[] roc_y, int period, boolean biased) {
        int n;
        int n2 = n = biased ? period : period - 1;
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        int length = ArrayDataUtils.getMinLength(roc_x, roc_y);
        Number[] results = new Number[length];
        for (int i = period - 1; i < length; ++i) {
            double sum_x = 0.0;
            double sum_y = 0.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (roc_x[j] != null) {
                    sum_x += roc_x[j].doubleValue();
                }
                if (roc_y[j] == null) continue;
                sum_y += roc_y[j].doubleValue();
            }
            double mean_x = sum_x / (double)period;
            double mean_y = sum_y / (double)period;
            double ss_y = 0.0;
            double sum = 0.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (roc_y[j] != null) {
                    ss_y += Math.pow(mean_y - roc_y[j].doubleValue(), 2.0);
                }
                if (roc_x[j] == null || roc_y[j] == null) continue;
                sum += (mean_x - roc_x[j].doubleValue()) * (mean_y - roc_y[j].doubleValue());
            }
            if (sum == 0.0 || ss_y == 0.0) {
                results[i] = 0.0;
                continue;
            }
            double cov = sum / (double)n;
            results[i] = cov / (ss_y / (double)n);
        }
        return results;
    }

    @Deprecated
    public static Number[] beta(Number[] x, Number[] y, int period) {
        return TechnicalAnalysis.beta(TechnicalAnalysis.roc(x, 1, PercentageScale.RATE), TechnicalAnalysis.roc(y, 1, PercentageScale.RATE), period, true);
    }

    @Deprecated
    public static Number[] beta2(Number[] x, Number[] y, int period, MovingAverage matype) {
        return TechnicalAnalysis.beta(TechnicalAnalysis.ma(TechnicalAnalysis.roc(x, 1, PercentageScale.RATE), period, matype), TechnicalAnalysis.ma(TechnicalAnalysis.roc(y, 1, PercentageScale.RATE), period, matype), period, true);
    }

    public static Number[] avgprice(Number[] open, Number[] high, Number[] low, Number[] close) {
        return TechnicalAnalysis.avg(open, high, low, close);
    }

    public static Map<FourPrice, Number[]> heikin(Number[] open, Number[] high, Number[] low, Number[] close) {
        if (open == null || high == null || low == null || close == null) {
            return null;
        }
        Number[] o = (Number[])open.clone();
        Number[] h = (Number[])high.clone();
        Number[] l = (Number[])low.clone();
        Number[] c = (Number[])close.clone();
        Object[] avg = TechnicalAnalysis.avg(open, high, low, close);
        int length = avg.length;
        int start = ArrayDataUtils.indexOfNotNull(avg);
        double _o = ((Number)avg[start]).doubleValue();
        double _c = ((Number)avg[start + 1]).doubleValue();
        o[start + 1] = _o;
        c[start + 1] = _c;
        for (int i = start + 2; i < length; ++i) {
            if (avg[i] == null) continue;
            _o = (_o + _c) * 0.5;
            _c = ((Number)avg[i]).doubleValue();
            o[i] = _o;
            c[i] = _c;
        }
        EnumMap<FourPrice, Number[]> results = new EnumMap<FourPrice, Number[]>(FourPrice.class);
        results.put(FourPrice.OPEN, o);
        results.put(FourPrice.HIGH, h);
        results.put(FourPrice.LOW, l);
        results.put(FourPrice.CLOSE, c);
        return results;
    }

    public static Number[] mp(Number[] high, Number[] low) {
        return TechnicalAnalysis.avg(high, low);
    }

    public static Number[] tp(Number[] high, Number[] low, Number[] close) {
        return TechnicalAnalysis.avg(high, low, close);
    }

    public static Number[] wtcl(Number[] high, Number[] low, Number[] close) {
        int length = ArrayDataUtils.getMinLength(high, low, close);
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (high[i] == null || low[i] == null || close[i] == null) continue;
            results[i] = (high[i].doubleValue() + low[i].doubleValue() + close[i].doubleValue() * 2.0) * 0.25;
        }
        return results;
    }

    public static Number[] th(Number[] high, Number[] close) {
        int length = ArrayDataUtils.getMinLength(high, close);
        Number[] results = new Number[length];
        if (high[0] != null) {
            results[0] = high[0].doubleValue();
        }
        for (int i = 1; i < length; ++i) {
            if (high[i] == null) continue;
            results[i] = close[i - 1] == null && high[i] != null ? Double.valueOf(high[i].doubleValue()) : Double.valueOf(Math.max(high[i].doubleValue(), close[i - 1].doubleValue()));
        }
        return results;
    }

    public static Number[] tl(Number[] low, Number[] close) {
        int length = ArrayDataUtils.getMinLength(low, close);
        Number[] results = new Number[length];
        if (low[0] != null) {
            results[0] = low[0].doubleValue();
        }
        for (int i = 1; i < length; ++i) {
            if (low[i] == null) continue;
            results[i] = close[i - 1] == null && low[i] != null ? Double.valueOf(low[i].doubleValue()) : Double.valueOf(Math.min(low[i].doubleValue(), close[i - 1].doubleValue()));
        }
        return results;
    }

    public static Number[] tr(Number[] high, Number[] low, Number[] close) {
        int length = ArrayDataUtils.getMinLength(high, low, close);
        Number[] results = new Number[length];
        if (high[0] != null && low[0] != null) {
            results[0] = high[0].doubleValue() - low[0].doubleValue();
        }
        for (int i = 1; i < length; ++i) {
            int j = i - 1;
            if (high[i] == null || low[i] == null || close[j] == null) continue;
            double _h = high[i].doubleValue();
            double _l = low[i].doubleValue();
            double _c = close[j].doubleValue();
            double hl = _h - _l;
            double hc = _h - _c;
            double cl = _c - _l;
            results[i] = Math.max(Math.max(hl, hc), cl);
        }
        return results;
    }

    public static Number[] ma(Number[] x, int period, MovingAverage matype) {
        switch (matype) {
            case SMA: {
                return TechnicalAnalysis.sma(x, period);
            }
            case SMMA: {
                return TechnicalAnalysis.smma(x, period);
            }
            case GMA: {
                return TechnicalAnalysis.gma(x, period);
            }
            case RMA: {
                return TechnicalAnalysis.rma(x, period);
            }
            case WWMA: {
                return TechnicalAnalysis.wwma(x, period);
            }
            case WMA: {
                return TechnicalAnalysis.wma(x, period);
            }
            case HMA: {
                return TechnicalAnalysis.hma(x, period);
            }
            case TMA: {
                return TechnicalAnalysis.tma(x, period);
            }
            case EMA: {
                return TechnicalAnalysis.ema(x, period);
            }
            case DEMA: {
                return TechnicalAnalysis.dema(x, period);
            }
            case TEMA: {
                return TechnicalAnalysis.tema(x, period);
            }
            case ZLEMA: {
                return TechnicalAnalysis.zlema(x, period);
            }
            case EPMA: {
                return TechnicalAnalysis.epma(x, period);
            }
            case T3: {
                return TechnicalAnalysis.t3(x, period);
            }
        }
        throw new RuntimeException();
    }

    public static Number[] doubleSmooth(Number[] x, int period, MovingAverage matype) {
        return TechnicalAnalysis.doubleSmooth(x, period, matype, period, matype);
    }

    public static Number[] doubleSmooth(Number[] x, int period1, MovingAverage matype1, int period2, MovingAverage matype2) {
        return TechnicalAnalysis.ma(TechnicalAnalysis.ma(x, period1, matype1), period2, matype2);
    }

    public static Number[] tripleSmooth(Number[] x, int period, MovingAverage matype) {
        return TechnicalAnalysis.tripleSmooth(x, period, matype, period, matype, period, matype);
    }

    public static Number[] tripleSmooth(Number[] x, int period1, MovingAverage matype1, int period2, MovingAverage matype2, int period3, MovingAverage matype3) {
        return TechnicalAnalysis.ma(TechnicalAnalysis.ma(TechnicalAnalysis.ma(x, period1, matype1), period2, matype2), period3, matype3);
    }

    public static Number[] dma(Number[] x, int period, int displaced) {
        return TechnicalAnalysis.dma(x, period, MovingAverage.SMA, displaced);
    }

    public static Number[] dma(Number[] x, int period, MovingAverage matype, int displaced) {
        return TechnicalAnalysis.displace(TechnicalAnalysis.ma(x, period, matype), displaced);
    }

    public static Number[] sma(Number[] x, int period) {
        if (period <= 0) {
            throw new IllegalArgumentException();
        }
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        for (int i = period - 1; i < length; ++i) {
            if (x[i] == null) continue;
            double sum = 0.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (x[j] == null) continue;
                sum += x[j].doubleValue();
            }
            results[i] = sum / (double)period;
        }
        return results;
    }

    public static Number[] smma(Number[] x, int period) {
        if (period <= 0) {
            throw new IllegalArgumentException();
        }
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        for (int i = period - 1; i < length; ++i) {
            if (x[i] == null) continue;
            double sum = 0.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (x[j] == null) continue;
                sum += x[j].doubleValue();
            }
            double sma = sum / (double)period;
            results[i] = (sum - sma + x[i].doubleValue()) / (double)period;
        }
        return results;
    }

    @Deprecated
    public static Number[] gma(Number[] x, int period) {
        if (period <= 0) {
            throw new IllegalArgumentException();
        }
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        double n = 1.0 / (double)period;
        for (int i = period - 1; i < length; ++i) {
            if (x[i] == null) continue;
            double sum = 1.0;
            int end = i - period + 1;
            for (int j = i; j >= end; --j) {
                if (x[j] == null) continue;
                sum *= x[j].doubleValue();
            }
            results[i] = Math.pow(sum, n);
        }
        return results;
    }

    public static Number[] rma(Number[] x, int period) {
        if (period <= 0) {
            throw new IllegalArgumentException();
        }
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        Number rma = null;
        for (int i = period - 1; i < length; ++i) {
            if (x[i] == null) continue;
            if (rma == null) {
                double sum = 0.0;
                for (int j = i - period + 1; j <= i; ++j) {
                    if (x[j] == null) continue;
                    sum += x[j].doubleValue();
                }
                results[i] = sum / (double)period;
                rma = results[i];
                continue;
            }
            results[i] = ((double)(period - 1) * rma.doubleValue() + x[i].doubleValue()) / (double)period;
            rma = results[i];
        }
        return results;
    }

    public static Number[] wwma(Number[] x, int period) {
        return TechnicalAnalysis.rma(x, period);
    }

    public static Number[] wma(Number[] x, int period) {
        if (period <= 0) {
            throw new IllegalArgumentException();
        }
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        for (int i = period - 1; i < length; ++i) {
            if (x[i] == null) continue;
            double num = 0.0;
            double den = 0.0;
            double w = 1.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (x[j] != null) {
                    num += w * x[j].doubleValue();
                }
                den += w;
                w += 1.0;
            }
            results[i] = num / den;
        }
        return results;
    }

    public static Number[] hma(Number[] x, int period) {
        Number[] wma1 = TechnicalAnalysis.wma(x, (int)Math.floor((double)period * 0.5));
        Number[] wma2 = TechnicalAnalysis.wma(x, period);
        int length = ArrayDataUtils.getMinLength(wma1, wma2);
        Number[] y = new Number[length];
        for (int i = period - 1; i < length; ++i) {
            if (wma1[i] == null || wma2[i] == null) continue;
            y[i] = 2.0 * wma1[i].doubleValue() - wma2[i].doubleValue();
        }
        return TechnicalAnalysis.wma(y, (int)Math.floor(Math.sqrt(period)));
    }

    public static Number[] tma(Number[] x, int period) {
        return TechnicalAnalysis.doubleSmooth(x, (int)Math.ceil(((double)period + 1.0) * 0.5), MovingAverage.SMA);
    }

    public static Number[] ema(Number[] x, int period) {
        if (period <= 0) {
            throw new IllegalArgumentException();
        }
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        double a = 2.0 / ((double)period + 1.0);
        Number ema = null;
        for (int i = period - 1; i < length; ++i) {
            if (x[i] == null) continue;
            if (ema == null) {
                double sum = 0.0;
                for (int j = i - period + 1; j <= i; ++j) {
                    if (x[j] == null) continue;
                    sum += x[j].doubleValue();
                }
                results[i] = sum / (double)period;
                ema = results[i];
                continue;
            }
            results[i] = ema.doubleValue() + a * (x[i].doubleValue() - ema.doubleValue());
            ema = results[i];
        }
        return results;
    }

    public static Number[] dema(Number[] x, int period) {
        Number[] ema = TechnicalAnalysis.ema(x, period);
        Number[] ema2 = TechnicalAnalysis.ema(ema, period);
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (ema[i] == null || ema2[i] == null) continue;
            results[i] = 2.0 * ema[i].doubleValue() - ema2[i].doubleValue();
        }
        return results;
    }

    public static Number[] tema(Number[] x, int period) {
        Number[] ema = TechnicalAnalysis.ema(x, period);
        Number[] ema2 = TechnicalAnalysis.ema(ema, period);
        Number[] ema3 = TechnicalAnalysis.ema(ema2, period);
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (ema[i] == null || ema2[i] == null || ema3 == null) continue;
            results[i] = 3.0 * ema[i].doubleValue() - 3.0 * ema2[i].doubleValue() + ema3[i].doubleValue();
        }
        return results;
    }

    public static Number[] zlema(Number[] x, int period) {
        if (period <= 0) {
            throw new IllegalArgumentException();
        }
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        double k = 2.0 / ((double)period + 1.0);
        int lag = (period - 1) / 2;
        Double ema = null;
        for (int i = period - 1; i < length; ++i) {
            if (x[i] == null || x[i - lag] == null) continue;
            if (ema == null) {
                double sum = 0.0;
                for (int j = i - period + 1; j <= i; ++j) {
                    if (x[j] == null) continue;
                    sum += x[j].doubleValue();
                }
                ema = sum / (double)period;
            } else {
                ema = k * (2.0 * x[i].doubleValue() - x[i - lag].doubleValue()) + (1.0 - k) * ema;
            }
            results[i] = ema;
        }
        return results;
    }

    public static Number[] epma(Number[] x, int period) {
        if (period <= 0) {
            throw new IllegalArgumentException();
        }
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        double n = 2.0 / ((double)period * ((double)period + 1.0));
        for (int i = period - 1; i < length; ++i) {
            if (x[i] == null) continue;
            double sum = 0.0;
            double pos = 1.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (x[j] != null) {
                    sum += (3.0 * pos - (double)period - 1.0) * x[j].doubleValue();
                }
                pos += 1.0;
            }
            results[i] = n * sum;
        }
        return results;
    }

    public static Number[] t3(Number[] x, int period) {
        return TechnicalAnalysis.t3(x, period, 0.7);
    }

    public static Number[] t3(Number[] x, int period, double a) {
        if (period <= 0) {
            throw new IllegalArgumentException();
        }
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        Number[] e3 = TechnicalAnalysis.tripleSmooth(x, period, MovingAverage.EMA);
        Number[] e4 = TechnicalAnalysis.ema(e3, period);
        Number[] e5 = TechnicalAnalysis.ema(e4, period);
        Number[] e6 = TechnicalAnalysis.ema(e5, period);
        double c1 = -Math.pow(a, 3.0);
        double c2 = 3.0 * Math.pow(a, 2.0) + 3.0 * Math.pow(a, 3.0);
        double c3 = -6.0 * Math.pow(a, 2.0) - 3.0 * a - 3.0 * Math.pow(a, 3.0);
        double c4 = 1.0 + 3.0 * a + Math.pow(a, 3.0) + 3.0 * Math.pow(a, 2.0);
        for (int i = period - 1; i < length; ++i) {
            if (e3[i] == null || e4[i] == null || e5[i] == null || e6[i] == null) continue;
            results[i] = c1 * e6[i].doubleValue() + c2 * e5[i].doubleValue() + c3 * e4[i].doubleValue() + c4 * e3[i].doubleValue();
        }
        return results;
    }

    public static Map<MESA, Number[]> mama(Number[] x) {
        return TechnicalAnalysis.mama(x, 0.5, 0.05);
    }

    public static Map<MESA, Number[]> mama(Number[] x, double limit_fast, double limit_slow) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] mama = new Number[length];
        Number[] fama = new Number[length];
        double[] smooth = new double[length];
        double[] period = new double[length];
        double[] detrender = new double[length];
        double[] q1 = new double[length];
        double[] i1 = new double[length];
        double[] ji = new double[length];
        double[] jq = new double[length];
        double[] i2 = new double[length];
        double[] q2 = new double[length];
        double[] re = new double[length];
        double[] im = new double[length];
        double[] smoothPeriod = new double[length];
        double[] phase = new double[length];
        double _mama = 0.0;
        double _fama = 0.0;
        double rad2deg = 180.0 / (4.0 * Math.atan(1.0));
        for (int i = 6; i < length; ++i) {
            double alpha;
            double deltaPhase;
            if (x[i] == null || x[i - 1] == null || x[i - 2] == null || x[i - 3] == null) continue;
            double p = 0.075 * period[i - 1] + 0.54;
            smooth[i] = (4.0 * x[i].doubleValue() + 3.0 * x[i - 1].doubleValue() + 2.0 * x[i - 2].doubleValue() + x[i - 3].doubleValue()) * 0.1;
            detrender[i] = (0.0962 * smooth[i] + 0.5769 * smooth[i - 2] - 0.5769 * smooth[i - 4] - 0.0962 * smooth[i - 6]) * p;
            q1[i] = (0.0962 * detrender[i] + 0.5769 * detrender[i - 2] - 0.5769 * detrender[i - 4] - 0.0962 * detrender[i - 6]) * p;
            i1[i] = detrender[i - 3];
            ji[i] = (0.0962 * i1[i] + 0.5769 * i1[i - 2] - 0.5769 * i1[i - 4] - 0.0962 * i1[i - 6]) * p;
            jq[i] = (0.0962 * q1[i] + 0.5769 * q1[i - 2] - 0.5769 * q1[i - 4] - 0.0962 * q1[i - 6]) * p;
            i2[i] = i1[i] - jq[i];
            q2[i] = q1[i] + ji[i];
            i2[i] = 0.2 * i2[i] + 0.8 * i2[i - 1];
            q2[i] = 0.2 * q2[i] + 0.8 * q2[i - 1];
            re[i] = i2[i] * i2[i - 1] + q2[i] * q2[i - 1];
            im[i] = i2[i] * q2[i - 1] - q2[i] * i2[i - 1];
            re[i] = 0.2 * re[i] + 0.8 * re[i - 1];
            im[i] = 0.2 * im[i] + 0.8 * im[i - 1];
            if (im[i] != 0.0 && re[i] != 0.0) {
                period[i] = 360.0 / (Math.atan(im[i] / re[i]) * rad2deg);
            }
            if (period[i] > 1.5 * period[i - 1]) {
                period[i] = 1.5 * period[i - 1];
            }
            if (period[i] < 0.67 * period[i - 1]) {
                period[i] = 0.67 * period[i - 1];
            }
            if (period[i] < 6.0) {
                period[i] = 6.0;
            }
            if (period[i] > 50.0) {
                period[i] = 50.0;
            }
            period[i] = 0.2 * period[i] + 0.8 * period[i - 1];
            smoothPeriod[i] = 0.33 * period[i] + 0.67 * smoothPeriod[i - 1];
            if (i1[i] != 0.0) {
                phase[i] = Math.atan(q1[i] / i1[i]) * rad2deg;
            }
            if ((deltaPhase = phase[i - 1] - phase[i]) < 1.0) {
                deltaPhase = 1.0;
            }
            if ((alpha = limit_fast / deltaPhase) < limit_slow) {
                alpha = limit_slow;
            }
            _mama = alpha * x[i].doubleValue() + (1.0 - alpha) * _mama;
            _fama = 0.5 * alpha * _mama + (1.0 - 0.5 * alpha) * _fama;
            mama[i] = _mama;
            fama[i] = _fama;
        }
        EnumMap<MESA, Number[]> map = new EnumMap<MESA, Number[]>(MESA.class);
        map.put(MESA.MAMA, mama);
        map.put(MESA.FAMA, fama);
        return map;
    }

    public static Number[] vwma(Number[] price, Number[] volume, int period) {
        if (period <= 0) {
            throw new IllegalArgumentException();
        }
        int length = ArrayDataUtils.getMinLength(price, volume);
        Number[] results = new Number[length];
        for (int i = period - 1; i < length; ++i) {
            if (price[i] == null || volume[i] == null) continue;
            double num = 0.0;
            double den = 0.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (price[j] == null || volume[j] == null) continue;
                num += price[j].doubleValue() * volume[j].doubleValue();
                den += volume[j].doubleValue();
            }
            results[i] = num / den;
        }
        return results;
    }

    public static CrossSignal[] cross(Number[] fast, Number[] slow) {
        int length = ArrayDataUtils.getMinLength(fast, slow);
        CrossSignal[] results = new CrossSignal[length];
        Number prev_fast = null;
        Number prev_slow = null;
        for (int i = 0; i < length; ++i) {
            if (prev_slow != null && prev_fast != null && slow[i] != null && fast[i] != null) {
                if (prev_slow.doubleValue() < prev_fast.doubleValue() && slow[i].doubleValue() > fast[i].doubleValue()) {
                    results[i] = CrossSignal.DEAD_CROSS;
                } else if (prev_slow.doubleValue() > prev_fast.doubleValue() && slow[i].doubleValue() < fast[i].doubleValue()) {
                    results[i] = CrossSignal.GOLDEN_CROSS;
                }
            }
            prev_fast = fast[i];
            prev_slow = slow[i];
        }
        return results;
    }

    public static CrossSignal[] cross(Number[] fast, double slow) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{fast});
        CrossSignal[] results = new CrossSignal[length];
        Number prev_fast = null;
        for (int i = 0; i < length; ++i) {
            if (prev_fast != null && fast[i] != null) {
                if (slow < prev_fast.doubleValue() && slow > fast[i].doubleValue()) {
                    results[i] = CrossSignal.DEAD_CROSS;
                } else if (slow > prev_fast.doubleValue() && slow < fast[i].doubleValue()) {
                    results[i] = CrossSignal.GOLDEN_CROSS;
                }
            }
            prev_fast = fast[i];
        }
        return results;
    }

    public static final boolean[] gc(Number[] fast, Number[] slow) {
        CrossSignal[] cross = TechnicalAnalysis.cross(fast, slow);
        int length = cross.length;
        boolean[] results = new boolean[length];
        for (int i = 0; i < length; ++i) {
            results[i] = cross[i] != null && cross[i] == CrossSignal.GOLDEN_CROSS;
        }
        return results;
    }

    public static final boolean[] dc(Number[] fast, Number[] slow) {
        CrossSignal[] cross = TechnicalAnalysis.cross(fast, slow);
        int length = cross.length;
        boolean[] results = new boolean[length];
        for (int i = 0; i < length; ++i) {
            results[i] = cross[i] != null && cross[i] == CrossSignal.DEAD_CROSS;
        }
        return results;
    }

    public static Number[] zigzag(Number[] x, double rate) {
        int j;
        double d;
        double r = rate * 0.01;
        int length = x.length;
        Number[] results = new Number[length];
        int start = ArrayDataUtils.indexOfNotNull(x);
        if (start + 1 >= length - 1) {
            return results;
        }
        double highest = x[start].doubleValue();
        int highest_index = start;
        double lowest = x[start].doubleValue();
        int lowest_index = start;
        boolean upTrend = x[start].doubleValue() < x[start + 1].doubleValue();
        results[start] = x[start].doubleValue();
        for (int i = start + 1; i < length; ++i) {
            if (x[i] == null) continue;
            double value = x[i].doubleValue();
            if (upTrend) {
                if (value > highest) {
                    highest = value;
                    highest_index = i;
                    continue;
                }
                if (!(r <= (highest - value) / highest)) continue;
                results[highest_index] = highest;
                d = (highest - lowest) / (double)(highest_index - lowest_index);
                for (j = lowest_index + 1; j < highest_index; ++j) {
                    results[j] = lowest + d * (double)(j - lowest_index);
                }
                lowest = value;
                lowest_index = i;
                upTrend = false;
                continue;
            }
            if (value < lowest) {
                lowest = value;
                lowest_index = i;
                continue;
            }
            if (!(r <= (value - lowest) / lowest)) continue;
            results[lowest_index] = lowest;
            d = (highest - lowest) / (double)(lowest_index - highest_index);
            for (j = highest_index + 1; j < lowest_index; ++j) {
                results[j] = highest - d * (double)(j - highest_index);
            }
            highest = value;
            highest_index = i;
            upTrend = true;
        }
        int last_index = ArrayDataUtils.lastIndexOfNotNull(x);
        double _x = x[last_index].doubleValue();
        results[last_index] = _x;
        if (upTrend) {
            d = (_x - lowest) / (double)(last_index - lowest_index);
            for (j = lowest_index + 1; j < last_index; ++j) {
                results[j] = lowest + d * (double)(j - lowest_index);
            }
        } else {
            d = (highest - _x) / (double)(last_index - highest_index);
            for (j = highest_index + 1; j < last_index; ++j) {
                results[j] = highest - d * (double)(j - highest_index);
            }
        }
        return results;
    }

    public static Map<Bands5, Number[]> bbands(Number[] high, Number[] low, Number[] close, int period, double rate) {
        return TechnicalAnalysis.bbands(TechnicalAnalysis.avg(high, low, close), period, rate);
    }

    public static Map<Bands5, Number[]> bbands(Number[] tp, int period, double rate) {
        if (period <= 0) {
            throw new IllegalArgumentException();
        }
        int length = ArrayDataUtils.getMinLength(new Object[][]{tp});
        Number[] upper2 = new Number[length];
        Number[] upper1 = new Number[length];
        Number[] tpma = new Number[length];
        Number[] lower1 = new Number[length];
        Number[] lower2 = new Number[length];
        for (int i = period; i < length; ++i) {
            if (tp[i] == null) continue;
            double s = 0.0;
            double sum = 0.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (tp[j] == null) continue;
                double _tp = tp[j].doubleValue();
                s += Math.pow(_tp, 2.0);
                sum += _tp;
            }
            double ma = sum / (double)period;
            double sd = Math.sqrt(((double)period * s - Math.pow(sum, 2.0)) / (double)(period * (period - 1)));
            if (Double.isNaN(sd)) {
                sd = 0.0;
            }
            upper2[i] = ma + rate * 2.0 * sd;
            upper1[i] = ma + rate * 1.0 * sd;
            tpma[i] = ma;
            lower1[i] = ma - rate * 1.0 * sd;
            lower2[i] = ma - rate * 2.0 * sd;
        }
        EnumMap<Bands5, Number[]> map = new EnumMap<Bands5, Number[]>(Bands5.class);
        map.put(Bands5.UPPER_BAND2, upper2);
        map.put(Bands5.UPPER_BAND1, upper1);
        map.put(Bands5.MIDDLE_BAND, tpma);
        map.put(Bands5.LOWER_BAND1, lower1);
        map.put(Bands5.LOWER_BAND2, lower2);
        return map;
    }

    public static Map<Bands5, Number[]> envelope(Number[] x, int period, MovingAverage matype, double rate) {
        Number[] ma = TechnicalAnalysis.ma(x, period, matype);
        EnumMap<Bands5, Number[]> map = new EnumMap<Bands5, Number[]>(Bands5.class);
        map.put(Bands5.MIDDLE_BAND, ma);
        map.put(Bands5.UPPER_BAND1, TechnicalAnalysis.envelope(ma, rate * 1.0));
        map.put(Bands5.UPPER_BAND2, TechnicalAnalysis.envelope(ma, rate * 2.0));
        map.put(Bands5.LOWER_BAND1, TechnicalAnalysis.envelope(ma, rate * -1.0));
        map.put(Bands5.LOWER_BAND2, TechnicalAnalysis.envelope(ma, rate * -2.0));
        return map;
    }

    public static Number[] envelope(Number[] ma, double rate) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{ma});
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (ma[i] == null) continue;
            results[i] = ma[i].doubleValue() * (100.0 + rate) / 100.0;
        }
        return results;
    }

    public static Map<Ichimoku, Number[]> ichimoku(Number[] high, Number[] low, Number[] close, int period_kijun, int period_tenkan, int period_span) {
        if (period_kijun <= 0) {
            throw new IllegalArgumentException();
        }
        if (period_tenkan <= 0) {
            throw new IllegalArgumentException();
        }
        if (period_span <= 0) {
            throw new IllegalArgumentException();
        }
        Number[] kijun = TechnicalAnalysis.avg(TechnicalAnalysis.highest(high, period_kijun), TechnicalAnalysis.lowest(low, period_kijun));
        Number[] tenkan = TechnicalAnalysis.avg(TechnicalAnalysis.highest(high, period_tenkan), TechnicalAnalysis.lowest(low, period_tenkan));
        Number[] highest = TechnicalAnalysis.highest(high, period_span * 2);
        Number[] lowest = TechnicalAnalysis.lowest(low, period_span * 2);
        EnumMap<Ichimoku, Number[]> map = new EnumMap<Ichimoku, Number[]>(Ichimoku.class);
        map.put(Ichimoku.KIJUN, kijun);
        map.put(Ichimoku.TENKAN, tenkan);
        map.put(Ichimoku.SENKOU1, TechnicalAnalysis.displace(TechnicalAnalysis.avg(tenkan, kijun), period_span - 1));
        map.put(Ichimoku.SENKOU2, TechnicalAnalysis.displace(TechnicalAnalysis.avg(highest, lowest), period_span - 1));
        map.put(Ichimoku.CHIKOU, TechnicalAnalysis.displace(close, -(period_span - 1)));
        return map;
    }

    public static Number[] displace(Number[] array, int offset) {
        if (array == null) {
            return null;
        }
        int length = array.length;
        Number[] results = new Number[length];
        if (offset > 0) {
            System.arraycopy(array, 0, results, offset, length - offset);
        } else {
            int n = Math.abs(offset);
            System.arraycopy(array, n, results, 0, length - n);
        }
        return results;
    }

    public static Map<Bands7, Number[]> pivot(Number[] high, Number[] low, Number[] close) {
        int length = ArrayDataUtils.getMinLength(high, low, close);
        Number[] r3 = new Number[length];
        Number[] r2 = new Number[length];
        Number[] r1 = new Number[length];
        Number[] pp = new Number[length];
        Number[] s1 = new Number[length];
        Number[] s2 = new Number[length];
        Number[] s3 = new Number[length];
        for (int i = 1; i < length; ++i) {
            if (high[i - 1] == null || low[i - 1] == null || close[i - 1] == null) continue;
            double h = high[i - 1].doubleValue();
            double l = low[i - 1].doubleValue();
            double p = (h + l + close[i - 1].doubleValue()) / 3.0;
            pp[i] = p;
            r3[i] = p * 2.0 + h - l * 2.0;
            r2[i] = p + h - l;
            r1[i] = p * 2.0 - l;
            s1[i] = p * 2.0 - h;
            s2[i] = p - h + l;
            s3[i] = p * 2.0 - h * 2.0 + l;
        }
        EnumMap<Bands7, Number[]> map = new EnumMap<Bands7, Number[]>(Bands7.class);
        map.put(Bands7.UPPER_BAND3, r3);
        map.put(Bands7.UPPER_BAND2, r2);
        map.put(Bands7.UPPER_BAND1, r1);
        map.put(Bands7.MIDDLE_BAND, pp);
        map.put(Bands7.LOWER_BAND1, s1);
        map.put(Bands7.LOWER_BAND2, s2);
        map.put(Bands7.LOWER_BAND3, s3);
        return map;
    }

    public static Number[] sar(Number[] high, Number[] low, Number[] close, double factor) {
        int length = ArrayDataUtils.getMinLength(high, low, close);
        Number[] results = new Number[length];
        double AF_STEP = 0.02;
        double AF_MAX = 0.2;
        int start = ArrayDataUtils.indexOfNotNull(close);
        if (start == -1) {
            return results;
        }
        if (length - start < 2) {
            return results;
        }
        boolean upTrend = close[start].doubleValue() < close[start + 1].doubleValue();
        double sar = upTrend ? low[start].doubleValue() : high[start].doubleValue();
        double ep = upTrend ? high[start + 1].doubleValue() : low[start + 1].doubleValue();
        double af = factor;
        results[1] = sar;
        sar += af * (ep - sar);
        for (int i = start + 2; i < length; ++i) {
            if (low[i] == null || high[i] == null) continue;
            if (upTrend) {
                if (sar > low[i].doubleValue()) {
                    sar = ep;
                    ep = low[i].doubleValue();
                    af = factor;
                    upTrend = false;
                } else if (ep < high[i].doubleValue()) {
                    ep = high[i].doubleValue();
                    af = Math.min(af + 0.02, 0.2);
                }
            } else if (sar < high[i].doubleValue()) {
                sar = ep;
                ep = high[i].doubleValue();
                af = factor;
                upTrend = true;
            } else if (ep > low[i].doubleValue()) {
                ep = low[i].doubleValue();
                af = Math.min(af + 0.02, 0.2);
            }
            results[i] = sar;
            sar += af * (ep - sar);
        }
        return results;
    }

    public static Map<Bands2, Number[]> volatility(Number[] high, Number[] low, Number[] close, int period, double weight) {
        int length = ArrayDataUtils.getMinLength(high, low, close);
        Number[] upper = new Number[length];
        Number[] lower = new Number[length];
        Number[] atr = TechnicalAnalysis.atr(high, low, close, period);
        Number[] hvi = TechnicalAnalysis.highest(close, period);
        Number[] lvi = TechnicalAnalysis.lowest(close, period);
        for (int i = 0; i < length; ++i) {
            if (hvi[i] == null || atr[i] == null) continue;
            double n = atr[i].doubleValue() * weight;
            upper[i] = hvi[i].doubleValue() + n;
            lower[i] = lvi[i].doubleValue() - n;
        }
        EnumMap<Bands2, Number[]> map = new EnumMap<Bands2, Number[]>(Bands2.class);
        map.put(Bands2.UPPER_BAND, upper);
        map.put(Bands2.LOWER_BAND, lower);
        return map;
    }

    public static Number[] atr(Number[] high, Number[] low, Number[] close, int period) {
        return TechnicalAnalysis.sma(TechnicalAnalysis.tr(high, low, close), period);
    }

    public static Number[] chv(Number[] high, Number[] low, int period_ma, int period_roc) {
        return TechnicalAnalysis.chv(high, low, period_ma, period_roc, PercentageScale.PERCENT);
    }

    public static Number[] chv(Number[] high, Number[] low, int period_ma, int period_roc, PercentageScale unit) {
        return TechnicalAnalysis.roc(TechnicalAnalysis.ema(TechnicalAnalysis.sub(high, low), period_ma), period_roc, unit);
    }

    public static Number[] hv(Number[] a, int period, int days) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{a});
        Number[] results = new Number[length];
        for (int i = period; i < length; ++i) {
            if (a[i] == null) continue;
            double sum = 0.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (a[j] == null || a[j - 1] == null) continue;
                double d = a[j].doubleValue() / a[j - 1].doubleValue();
                sum += Math.log(d);
            }
            double ma = sum / (double)period;
            sum = 0.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (a[j] == null || a[j - 1] == null) continue;
                double x = Math.log(a[j].doubleValue() / a[j - 1].doubleValue()) - ma;
                sum += Math.pow(x, 2.0);
            }
            results[i] = Math.sqrt((double)days * (sum / (double)(period - 1))) * 100.0;
        }
        return results;
    }

    public static Number[] natr(Number[] high, Number[] low, Number[] close, int period) {
        return TechnicalAnalysis.natr(high, low, close, period, PercentageScale.PERCENT);
    }

    public static Number[] natr(Number[] high, Number[] low, Number[] close, int period, PercentageScale unit) {
        Number[] atr = TechnicalAnalysis.atr(high, low, close, period);
        int length = atr.length;
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (atr[i] == null || close[i] == null) continue;
            results[i] = atr[i].doubleValue() / close[i].doubleValue() * unit.scale();
        }
        return results;
    }

    public static Number[] apo(Number[] prices, int fast, int slow) {
        return TechnicalAnalysis.apo(prices, fast, slow, MovingAverage.EMA);
    }

    public static Number[] apo(Number[] prices, int fast, int slow, MovingAverage matype) {
        return TechnicalAnalysis.sub(TechnicalAnalysis.ma(prices, Math.min(fast, slow), matype), TechnicalAnalysis.ma(prices, Math.max(fast, slow), matype));
    }

    public static Number[] asi(Number[] open, Number[] high, Number[] low, Number[] close, double t) {
        Number[] si = TechnicalAnalysis.si(open, high, low, close, t);
        int length = si.length;
        Number[] results = new Number[length];
        Number asi = null;
        for (int i = 1; i < length; ++i) {
            if (si[i] == null) continue;
            if (asi == null) {
                asi = si[i];
            }
            results[i] = asi = Double.valueOf(asi.doubleValue() + si[i].doubleValue());
        }
        return results;
    }

    private static Number[] si(Number[] open, Number[] high, Number[] low, Number[] close, double t) {
        int length = ArrayDataUtils.getMinLength(open, high, low, close);
        Number[] results = new Number[length];
        for (int i = 1; i < length; ++i) {
            int yestaday = i - 1;
            if (open[yestaday] == null || high[yestaday] == null || low[yestaday] == null || close[yestaday] == null || open[i] == null || high[i] == null || low[i] == null || close[i] == null) continue;
            double oy = open[i - 1].doubleValue();
            double cy = close[i - 1].doubleValue();
            double o = open[i].doubleValue();
            double h = high[i].doubleValue();
            double l = low[i].doubleValue();
            double c = close[i].doubleValue();
            double hc = h - cy;
            double lc = l - cy;
            double hl = h - l;
            double max = Math.max(Math.max(hc, lc), hl);
            double r = max == hc ? h - cy - 0.5 * (l - cy) + 0.25 * (cy - oy) : (max == lc ? l - cy - 0.5 * (h - cy) + 0.25 * (cy - oy) : (max == hl ? h - l + 0.25 * (cy - oy) : 0.0));
            double k = Math.max(h - cy, l - cy);
            results[i] = 50.0 * (c - cy + 0.5 * (c - o) + 0.25 * (cy - oy) / r) * (k / t);
        }
        return results;
    }

    public static Map<Aroon, Number[]> aroon(Number[] x, int period) {
        return TechnicalAnalysis.aroon(x, period, PercentageScale.PERCENT);
    }

    public static Map<Aroon, Number[]> aroon(Number[] x, int period, PercentageScale unit) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] up = new Number[length];
        Number[] down = new Number[length];
        Number[] aroon = new Number[length];
        Number[] periodH = TechnicalAnalysis.periodsSinceHighest(x, period);
        Number[] periodL = TechnicalAnalysis.periodsSinceLowest(x, period);
        for (int i = 0; i < length; ++i) {
            if (periodH[i] == null || periodL[i] == null) continue;
            up[i] = ((double)period - periodH[i].doubleValue()) / (double)period * unit.scale();
            down[i] = ((double)period - periodL[i].doubleValue()) / (double)period * unit.scale();
            aroon[i] = up[i].doubleValue() - down[i].doubleValue();
        }
        EnumMap<Aroon, Number[]> map = new EnumMap<Aroon, Number[]>(Aroon.class);
        map.put(Aroon.AROON_UP, up);
        map.put(Aroon.AROON_DOWN, down);
        map.put(Aroon.AROON, aroon);
        return map;
    }

    public static Number[] bmp(Number[] open, Number[] high, Number[] low, Number[] close) {
        return TechnicalAnalysis.bmp(open, high, low, close, PercentageScale.PERCENT);
    }

    public static Number[] bmp(Number[] open, Number[] high, Number[] low, Number[] close, PercentageScale unit) {
        return TechnicalAnalysis.bop(open, high, low, close, unit);
    }

    public static Number[] bop(Number[] open, Number[] high, Number[] low, Number[] close) {
        return TechnicalAnalysis.bop(open, high, low, close, PercentageScale.PERCENT);
    }

    public static Number[] bop(Number[] open, Number[] high, Number[] low, Number[] close, PercentageScale unit) {
        int length = ArrayDataUtils.getMinLength(open, high, low, close);
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            double BeRBoOC;
            double BuRBoOC;
            if (open[i] == null || high[i] == null || low[i] == null || close[i] == null) continue;
            double o = open[i].doubleValue();
            double h = high[i].doubleValue();
            double l = low[i].doubleValue();
            double c = close[i].doubleValue();
            double thl = h - l;
            if (thl == 0.0) {
                thl = 1.0E-5;
            }
            double BuRBoO = (h - o) / thl;
            double BeRBoO = (o - l) / thl;
            double BuRBoC = (c - l) / thl;
            double BeRBoC = (h - c) / thl;
            if (c > o) {
                BuRBoOC = (c - o) / thl;
                BeRBoOC = 0.0;
            } else {
                BuRBoOC = 0.0;
                BeRBoOC = (o - c) / thl;
            }
            results[i] = ((BuRBoO + BuRBoC + BuRBoOC) / 3.0 - (BeRBoO + BeRBoC + BeRBoOC) / 3.0) * unit.scale();
        }
        return results;
    }

    public static Number[] cci(Number[] high, Number[] low, Number[] close, int period) {
        int length = ArrayDataUtils.getMinLength(high, low, close);
        Number[] results = new Number[length];
        Number[] avg = TechnicalAnalysis.avg(high, low, close);
        Number[] ma = TechnicalAnalysis.sma(avg, period);
        for (int i = period; i < length; ++i) {
            if (avg[i] == null || ma[i] == null) continue;
            double sum = 0.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (avg[j] == null || ma[j] == null) continue;
                sum += Math.abs(avg[j].doubleValue() - ma[j].doubleValue());
            }
            results[i] = sum == 0.0 ? Double.valueOf(0.0) : Double.valueOf((avg[i].doubleValue() - ma[i].doubleValue()) / (0.015 * (sum / (double)period)));
        }
        return results;
    }

    public static final Number[] chg(Number[] x) {
        return TechnicalAnalysis.mom(x, 1);
    }

    public static Map<Changes, Number[]> chgcnt(Number[] x, PercentageScale unit) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] count = new Number[length];
        Number[] close = new Number[length];
        Number[] change = new Number[length];
        Number[] percent = new Number[length];
        Number[] changes = TechnicalAnalysis.chg(x);
        int base = -1;
        int orientation = 0;
        for (int i = 1; i < length; ++i) {
            double countChange;
            double currentClose;
            double baseClose;
            if (changes[i] == null) {
                base = -1;
                orientation = 0;
                continue;
            }
            double chg = changes[i].doubleValue();
            if (chg > 0.0) {
                if (orientation <= 0) {
                    base = i - 1;
                    orientation = 1;
                }
                count[i] = i - base;
                close[i] = x[base];
                baseClose = x[base].doubleValue();
                currentClose = x[i].doubleValue();
                countChange = currentClose - baseClose;
                change[i] = countChange;
                percent[i] = countChange / baseClose * unit.scale();
                continue;
            }
            if (chg < 0.0) {
                if (orientation >= 0) {
                    base = i - 1;
                    orientation = -1;
                }
                count[i] = (i - base) * -1;
                close[i] = x[base];
                baseClose = x[base].doubleValue();
                currentClose = x[i].doubleValue();
                countChange = currentClose - baseClose;
                change[i] = countChange;
                percent[i] = countChange / baseClose * unit.scale();
                continue;
            }
            base = -1;
            orientation = 0;
            count[i] = 0;
            close[i] = x[i];
            change[i] = 0;
            percent[i] = 0;
        }
        EnumMap<Changes, Number[]> map = new EnumMap<Changes, Number[]>(Changes.class);
        map.put(Changes.COUNT, count);
        map.put(Changes.CLOSE, close);
        map.put(Changes.CHANGE, change);
        map.put(Changes.PERCENT_CHANGE, percent);
        return map;
    }

    public static Number[] cmf(Number[] high, Number[] low, Number[] close, Number[] volume, int period) {
        int length = ArrayDataUtils.getMinLength(high, low, close, volume);
        Number[] results = new Number[length];
        Number[] ad = TechnicalAnalysis.sum(TechnicalAnalysis.ad(high, low, close, volume), period);
        Number[] v = TechnicalAnalysis.sum(volume, period);
        for (int i = period - 1; i < length; ++i) {
            if (ad[i] == null || v[i] == null) continue;
            double _ad = ad[i].doubleValue();
            double _v = v[i].doubleValue();
            results[i] = _ad == 0.0 || _v == 0.0 ? (Number)0 : (Number)(_ad / _v);
        }
        return results;
    }

    public static Number[] cmo(Number[] change, int period) {
        return TechnicalAnalysis.cmo(change, period, PercentageScale.PERCENT);
    }

    public static Number[] cmo(Number[] change, int period, PercentageScale unit) {
        if (period <= 0) {
            throw new IllegalArgumentException();
        }
        int length = ArrayDataUtils.getMinLength(new Object[][]{change});
        Number[] results = new Number[length];
        for (int i = period - 1; i < length; ++i) {
            if (change[i] == null) continue;
            double up = 0.0;
            double down = 0.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (change[j] == null) continue;
                double diff = change[j].doubleValue();
                if (diff > 0.0) {
                    up += diff;
                    continue;
                }
                if (!(diff < 0.0)) continue;
                down -= diff;
            }
            double numerator = up - down;
            double denominator = up + down;
            results[i] = numerator == 0.0 || denominator == 0.0 ? Double.valueOf(unit.scale() * 0.5) : Double.valueOf(numerator / denominator * unit.scale());
        }
        return results;
    }

    public static Number[] coppock(Number[] x, int roc, int ma, MovingAverage matype) {
        return TechnicalAnalysis.ma(TechnicalAnalysis.roc(x, roc, PercentageScale.PERCENT), ma, matype);
    }

    public static Number[] coppock(Number[] x) {
        return TechnicalAnalysis.coppock(x, 11, 14, 10, MovingAverage.WMA);
    }

    public static Number[] coppock(Number[] x, int period_fast_roc, int period_slow_roc, int period_ma, MovingAverage matype) {
        return TechnicalAnalysis.ma(TechnicalAnalysis.add(TechnicalAnalysis.roc(x, period_fast_roc, PercentageScale.PERCENT), TechnicalAnalysis.roc(x, period_slow_roc, PercentageScale.PERCENT)), period_ma, matype);
    }

    public static Number[] crsi(Number[] change, int period, int period2) {
        return TechnicalAnalysis.crsi(change, period, period2, period2, PercentageScale.PERCENT);
    }

    public static Number[] crsi(Number[] change, int period, int period_gain, int period_loss) {
        return TechnicalAnalysis.crsi(change, period, period_gain, period_loss, PercentageScale.PERCENT);
    }

    public static Number[] crsi(Number[] change, int period, int period_gain, int period_loss, PercentageScale unit) {
        if (period <= 0) {
            throw new IllegalArgumentException();
        }
        if (period_gain < period) {
            throw new IllegalArgumentException();
        }
        if (period_loss < period) {
            throw new IllegalArgumentException();
        }
        int length = ArrayDataUtils.getMinLength(new Object[][]{change});
        Number[] results = new Number[length];
        for (int i = period - 1; i < length; ++i) {
            if (change[i] == null) continue;
            double gain = 0.0;
            for (int j = i - period_gain + 1; j <= i; ++j) {
                double diff;
                if (change[j] == null || !((diff = change[j].doubleValue()) > 0.0)) continue;
                gain += diff;
            }
            double loss = 0.0;
            for (int j = i - period_loss + 1; j <= i; ++j) {
                double diff;
                if (change[j] == null || !((diff = change[j].doubleValue()) < 0.0)) continue;
                loss -= diff;
            }
            double updown = gain + loss;
            results[i] = updown <= 0.0 ? Double.valueOf(unit.scale() * 0.5) : Double.valueOf(gain / updown * unit.scale());
        }
        return results;
    }

    public static Number[] csi(Number[] high, Number[] low, Number[] close, int period, int period_adx, double v, double m, double c) {
        Number[] adxr = TechnicalAnalysis.dmi(high, low, close, period, period_adx).get((Object)DMI.ADX_R);
        Number[] atr = TechnicalAnalysis.atr(high, low, close, period);
        double k = v / m * (0.0 + c) * 100.0;
        int length = ArrayDataUtils.getMinLength(high, low, close);
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (adxr[i] == null || atr[i] == null) continue;
            results[i] = adxr[i].doubleValue() * atr[i].doubleValue() * k;
        }
        return results;
    }

    public static Map<DMI, Number[]> dmi(Number[] high, Number[] low, Number[] close, int period_di, int period_adx) {
        return TechnicalAnalysis.dmi(high, low, close, period_di, period_adx, PercentageScale.PERCENT);
    }

    public static Map<DMI, Number[]> dmi(Number[] high, Number[] low, Number[] close, int period_di, int period_adx, PercentageScale unit) {
        if (period_di <= 0) {
            throw new IllegalArgumentException();
        }
        if (period_adx <= 0) {
            throw new IllegalArgumentException();
        }
        int length = ArrayDataUtils.getMinLength(high, low, close);
        if (length < 2) {
            throw new IllegalArgumentException();
        }
        Number[] pdm = new Number[length];
        Number[] mdm = new Number[length];
        Number[] dx = new Number[length];
        for (int i = 1; i < length; ++i) {
            int j = i - 1;
            if (high[i] == null || high[j] == null || low[i] == null || low[j] == null || close[i] == null || close[j] == null) continue;
            double p = high[i].doubleValue() - high[j].doubleValue();
            double m = low[j].doubleValue() - low[i].doubleValue();
            if (p < 0.0 && m < 0.0) {
                p = 0.0;
                m = 0.0;
            } else if (p < m) {
                p = 0.0;
            } else if (p > m) {
                m = 0.0;
            } else {
                p = 0.0;
                m = 0.0;
            }
            pdm[i] = p;
            mdm[i] = m;
        }
        Number[] tr = TechnicalAnalysis.tr(high, low, close);
        Number[] pdi = new Number[length];
        Number[] mdi = new Number[length];
        for (int i = period_di; i < length; ++i) {
            double sum_pdm = 0.0;
            double sum_mdm = 0.0;
            double sum_tr = 0.0;
            for (int j = i - period_di + 1; j <= i; ++j) {
                if (pdm[j] != null) {
                    sum_pdm += pdm[j].doubleValue();
                }
                if (mdm[j] != null) {
                    sum_mdm += mdm[j].doubleValue();
                }
                if (tr[j] == null) continue;
                sum_tr += tr[j].doubleValue();
            }
            pdi[i] = sum_pdm == 0.0 || sum_tr == 0.0 ? (Number)0 : (Number)(sum_pdm / sum_tr * unit.scale());
            mdi[i] = sum_mdm == 0.0 || sum_tr == 0.0 ? (Number)0 : (Number)(sum_mdm / sum_tr * unit.scale());
            double v1 = Math.abs(pdi[i].doubleValue() - mdi[i].doubleValue());
            double v2 = pdi[i].doubleValue() + mdi[i].doubleValue();
            dx[i] = v1 == 0.0 || v2 == 0.0 ? (Number)0 : (Number)(v1 / v2);
        }
        Number[] adx = TechnicalAnalysis.sma(dx, period_adx);
        for (int i = 0; i < length; ++i) {
            if (adx[i] == null) continue;
            adx[i] = adx[i].doubleValue() * unit.scale();
        }
        Number[] adxr = new Number[length];
        for (int i = period_adx - 1; i < length; ++i) {
            int j = i - period_adx + 1;
            if (adx[i] == null || adx[j] == null) continue;
            adxr[i] = (adx[i].doubleValue() + adx[j].doubleValue()) * 0.5;
        }
        EnumMap<DMI, Number[]> map = new EnumMap<DMI, Number[]>(DMI.class);
        map.put(DMI.PLUS_DI, pdi);
        map.put(DMI.MINUS_DI, mdi);
        map.put(DMI.ADX, adx);
        map.put(DMI.ADX_R, adxr);
        return map;
    }

    @Deprecated
    public static Number[] dmi(Number[] x) {
        return TechnicalAnalysis.dmi(x, 5, 10, MovingAverage.SMA, 14, 30.0, 3.0, PercentageScale.PERCENT);
    }

    @Deprecated
    public static Number[] dmi(Number[] x, int period_stddev, int period_ma, MovingAverage matype, int period_dmi, double upper, double lower, PercentageScale unit) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        Number[] sd = TechnicalAnalysis.stddevp(x, period_stddev);
        Number[] asd = TechnicalAnalysis.ma(sd, period_ma, matype);
        for (int i = 9; i < length; ++i) {
            int vl;
            int start;
            if (sd[i] == null || asd[i] == null || x[i] == null || (start = i - (vl = (int)Math.max(Math.min(Math.floor((double)period_dmi / (sd[i].doubleValue() / asd[i].doubleValue())), upper), lower)) + 1) < 0) continue;
            double up = 0.0;
            double down = 0.0;
            for (int j = start; j <= i; ++j) {
                if (x[j] == null) continue;
                double change = x[j].doubleValue();
                if (change > 0.0) {
                    up += change;
                    continue;
                }
                if (!(change < 0.0)) continue;
                down -= change;
            }
            double updown = up + down;
            results[i] = updown <= 0.0 ? Double.valueOf(unit.scale() * 0.5) : Double.valueOf(up / updown * unit.scale());
        }
        return results;
    }

    public static Number[] dpo(Number[] x, int period) {
        return TechnicalAnalysis.dpo(x, period, MovingAverage.SMA);
    }

    public static Number[] dpo(Number[] x, int period, MovingAverage matype) {
        int n;
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        Number[] ma = TechnicalAnalysis.ma(x, period, matype);
        for (int i = n = period / 2 + 1; i < length; ++i) {
            int j = i - n;
            if (x[i] == null || ma[j] == null) continue;
            results[i] = x[i].doubleValue() - ma[j].doubleValue();
        }
        return results;
    }

    public static Number[] emv(Number[] high, Number[] low, Number[] volume, int period) {
        int length = ArrayDataUtils.getMinLength(high, low, volume);
        Number[] results = new Number[length];
        for (int i = period; i < length; ++i) {
            int j = i - period;
            if (high[i] == null || low[i] == null || high[j] == null || low[j] == null || volume[i] == null) continue;
            double h = high[i].doubleValue();
            double l = low[i].doubleValue();
            double h2 = high[j].doubleValue();
            double l2 = low[j].doubleValue();
            double v = volume[i].doubleValue();
            results[i] = ((h + l) * 0.5 - (h2 + l2) * 0.5) / (v / (h - l));
        }
        return results;
    }

    public static Number[] kairi(Number[] x, Number[] ma) {
        return TechnicalAnalysis.kairi(x, ma, PercentageScale.PERCENT);
    }

    public static Number[] kairi(Number[] x, Number[] ma, PercentageScale unit) {
        int length = ArrayDataUtils.getMinLength(x, ma);
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (x[i] == null || ma[i] == null) continue;
            double diff = x[i].doubleValue() - ma[i].doubleValue();
            results[i] = diff == 0.0 || ma[i].doubleValue() == 0.0 ? Double.valueOf(0.0) : Double.valueOf(diff / ma[i].doubleValue() * unit.scale());
        }
        return results;
    }

    public static Map<Histogram, Number[]> macd(Number[] x, int fast, int slow, int period) {
        return TechnicalAnalysis.macd(x, fast, MovingAverage.EMA, slow, MovingAverage.EMA, period, MovingAverage.SMA);
    }

    public static Map<Histogram, Number[]> macd(Number[] x, int fast, int slow, int period, MovingAverage matype) {
        return TechnicalAnalysis.macd(x, fast, MovingAverage.EMA, slow, MovingAverage.EMA, period, matype);
    }

    public static Map<Histogram, Number[]> macd(Number[] x, int fast, MovingAverage matype_fast, int slow, MovingAverage matype_slow, int period, MovingAverage matype_signal) {
        Number[] macd = TechnicalAnalysis.sub(TechnicalAnalysis.ma(x, fast, matype_fast), TechnicalAnalysis.ma(x, slow, matype_slow));
        Number[] signal = TechnicalAnalysis.ma(macd, period, matype_signal);
        Number[] histogram = TechnicalAnalysis.sub(macd, signal);
        EnumMap<Histogram, Number[]> map = new EnumMap<Histogram, Number[]>(Histogram.class);
        map.put(Histogram.INDICATOR, macd);
        map.put(Histogram.SIGNAL, signal);
        map.put(Histogram.HISTOGRAM, histogram);
        return map;
    }

    public static Number[] mfi(Number[] high, Number[] low, Number[] close, Number[] volume, int period) {
        int length = ArrayDataUtils.getMinLength(high, low, close, volume);
        Number[] results = new Number[length];
        Number[] tp = TechnicalAnalysis.avg(high, low, close);
        Number[] mf = TechnicalAnalysis.mult(tp, volume);
        Number[] pmf = new Number[length];
        Number[] nmf = new Number[length];
        for (int i = 1; i < length; ++i) {
            double prev_tp;
            int j = i - 1;
            if (tp[i] == null || tp[j] == null) continue;
            double current_tp = tp[i].doubleValue();
            if (current_tp > (prev_tp = tp[j].doubleValue())) {
                pmf[i] = mf[i].doubleValue();
                nmf[i] = 0;
                continue;
            }
            if (!(current_tp < prev_tp)) continue;
            pmf[i] = 0;
            nmf[i] = mf[i].doubleValue();
        }
        Number[] mr = TechnicalAnalysis.div(TechnicalAnalysis.sum(pmf, period), TechnicalAnalysis.sum(nmf, period));
        for (int i = period - 1; i < length; ++i) {
            if (mr[i] == null) continue;
            results[i] = 100.0 - 100.0 / (1.0 + mr[i].doubleValue());
        }
        return results;
    }

    public static Number[] mi(Number[] high, Number[] low, int period) {
        return TechnicalAnalysis.mi(high, low, period, 9, MovingAverage.EMA);
    }

    public static Number[] mi(Number[] high, Number[] low, int period, int period_ma, MovingAverage matype) {
        Number[] ma = TechnicalAnalysis.ma(TechnicalAnalysis.sub(high, low), period_ma, matype);
        return TechnicalAnalysis.sum(TechnicalAnalysis.div(ma, TechnicalAnalysis.ma(ma, period_ma, matype)), period);
    }

    public static Number[] mom(Number[] x, int period) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        for (int i = period; i < length; ++i) {
            int j = i - period;
            if (x[i] == null || x[j] == null) continue;
            results[i] = x[i].doubleValue() - x[j].doubleValue();
        }
        return results;
    }

    public static Number[] pain(Number[] open, Number[] high, Number[] low, Number[] close) {
        int length = ArrayDataUtils.getMinLength(open, high, low, close);
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (open[i] == null || high[i] == null || low[i] == null || close[i] == null) continue;
            double c = close[i].doubleValue();
            results[i] = (c - open[i].doubleValue() + (c - high[i].doubleValue()) + (c - low[i].doubleValue())) * 0.5;
        }
        return results;
    }

    public static Number[] pchg(Number[] x) {
        return TechnicalAnalysis.roc(x, 1, PercentageScale.PERCENT);
    }

    public static Number[] pchg(Number[] x, PercentageScale unit) {
        return TechnicalAnalysis.roc(x, 1, unit);
    }

    public static Number[] pcr(Number[] x, int period) {
        return TechnicalAnalysis.pcr(x, period, PercentageScale.REVERSE_PERCENT);
    }

    public static Number[] pcr(Number[] x, int period, PercentageScale unit) {
        Number[] highest = TechnicalAnalysis.highest(x, period);
        Number[] lowest = TechnicalAnalysis.lowest(x, period);
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (x[i] == null || highest[i] == null || lowest[i] == null) continue;
            double num = highest[i].doubleValue() - x[i].doubleValue();
            double den = highest[i].doubleValue() - lowest[i].doubleValue();
            results[i] = num == 0.0 || den == 0.0 ? Double.valueOf(0.0) : Double.valueOf(num / den * unit.scale());
        }
        return results;
    }

    public static Number[] performance(Number[] x, int period) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        int start = ArrayDataUtils.indexOfNotNull(x, period);
        if (start == -1) {
            return results;
        }
        double prev = x[start].doubleValue();
        for (int i = start + 1; i < length && x[i] != null; ++i) {
            results[i] = x[i].doubleValue() - prev;
        }
        return results;
    }

    public static Number[] performance(Number[] x, int period, PercentageScale unit) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        int start = ArrayDataUtils.indexOfNotNull(x, period);
        if (start == -1) {
            return results;
        }
        double prev = x[start].doubleValue();
        for (int i = start + 1; i < length && x[i] != null; ++i) {
            results[i] = (x[i].doubleValue() - prev) / prev * unit.scale();
        }
        return results;
    }

    public static Number[] ppo(Number[] prices, int fast, int slow) {
        return TechnicalAnalysis.ppo(prices, fast, slow, MovingAverage.EMA, PercentageScale.PERCENT);
    }

    public static Number[] ppo(Number[] prices, int fast, int slow, MovingAverage matype) {
        return TechnicalAnalysis.ppo(prices, fast, slow, matype, PercentageScale.PERCENT);
    }

    public static Number[] ppo(Number[] prices, int fast, int slow, MovingAverage matype, PercentageScale unit) {
        Number[] ma_fast = TechnicalAnalysis.ma(prices, Math.min(fast, slow), matype);
        Number[] ma_slow = TechnicalAnalysis.ma(prices, Math.max(fast, slow), matype);
        int length = ArrayDataUtils.getMinLength(new Object[][]{prices});
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (ma_fast[i] == null || ma_slow[i] == null) continue;
            results[i] = (ma_fast[i].doubleValue() - ma_slow[i].doubleValue()) / ma_fast[i].doubleValue() * unit.scale();
        }
        return results;
    }

    public static Number[] psy(Number[] change, int period) {
        return TechnicalAnalysis.psy(change, period, PercentageScale.PERCENT);
    }

    public static Number[] psy(Number[] change, int period, PercentageScale unit) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{change});
        Number[] results = new Number[length];
        for (int i = period - 1; i < length; ++i) {
            if (change[i] == null) continue;
            int upCount = 0;
            for (int j = i - period + 1; j <= i; ++j) {
                double chg;
                if (change[j] == null || !((chg = change[j].doubleValue()) > 0.0)) continue;
                ++upCount;
            }
            results[i] = (double)upCount / (double)period * unit.scale();
        }
        return results;
    }

    public static Number[] qstick(Number[] open, Number[] close, int period) {
        return TechnicalAnalysis.qstick(open, close, period, MovingAverage.SMA);
    }

    public static Number[] qstick(Number[] open, Number[] close, int period, MovingAverage matype) {
        return TechnicalAnalysis.ma(TechnicalAnalysis.sub(close, open), period, matype);
    }

    public static Number[] rci(Number[] x, int period) {
        return TechnicalAnalysis.rci(x, period, PercentageScale.PERCENT);
    }

    public static Number[] rci(Number[] x, int period, PercentageScale unit) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        double[] table = new double[period];
        for (int i = period - 1; i < length; ++i) {
            int j;
            if (x[i] == null) continue;
            double d = 0.0;
            for (j = 0; j < period; ++j) {
                table[j] = 1.0;
            }
            for (j = 0; j < period; ++j) {
                for (int k = j + 1; k < period; ++k) {
                    Number n1 = x[i - period + 1 + j];
                    Number n2 = x[i - period + 1 + k];
                    if (n1 == null || n2 == null) continue;
                    if (n1.doubleValue() < n2.doubleValue()) {
                        table[k] = table[k] + 1.0;
                        continue;
                    }
                    if (n1.doubleValue() > n2.doubleValue()) {
                        table[j] = table[j] + 1.0;
                        continue;
                    }
                    table[j] = table[j] + 0.5;
                    table[k] = table[k] + 0.5;
                }
                d += Math.pow((double)(j + 1) - table[j], 2.0);
            }
            results[i] = (1.0 - 6.0 * d / (double)(period * (period * period - 1))) * unit.scale();
        }
        return results;
    }

    public static Number[] roc(Number[] x, int period) {
        return TechnicalAnalysis.roc(x, period, PercentageScale.PERCENT);
    }

    public static Number[] roc(Number[] x, int period, PercentageScale unit) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        for (int i = period; i < length; ++i) {
            int j = i - period;
            if (x[i] == null || x[j] == null) continue;
            double diff = x[i].doubleValue() - x[j].doubleValue();
            results[i] = diff == 0.0 || x[j].doubleValue() == 0.0 ? Double.valueOf(0.0) : Double.valueOf(diff / x[j].doubleValue() * unit.scale());
        }
        return results;
    }

    public static Number[] rsi(Number[] change, int period) {
        return TechnicalAnalysis.rsi(change, period, PercentageScale.PERCENT);
    }

    public static Number[] rsi(Number[] change, int period, PercentageScale unit) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{change});
        Number[] results = new Number[length];
        for (int i = period - 1; i < length; ++i) {
            if (change[i] == null) continue;
            double gain = 0.0;
            double loss = 0.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (change[j] == null) continue;
                double diff = change[j].doubleValue();
                if (diff > 0.0) {
                    gain += diff;
                    continue;
                }
                if (!(diff < 0.0)) continue;
                loss -= diff;
            }
            double updown = gain + loss;
            results[i] = updown <= 0.0 ? Double.valueOf(unit.scale() * 0.5) : Double.valueOf(gain / updown * unit.scale());
        }
        return results;
    }

    public static Number[] rvi(Number[] change, int period) {
        return TechnicalAnalysis.rvi(change, period, PercentageScale.PERCENT);
    }

    public static Number[] rvi(Number[] change, int period, PercentageScale unit) {
        Number[] stddev = TechnicalAnalysis.stddev(change, 10);
        int length = ArrayDataUtils.getMinLength(new Object[][]{change});
        Number[] results = new Number[length];
        for (int i = period - 1; i < length; ++i) {
            double updown;
            if (change[i] == null || stddev[i] == null) continue;
            double up = 0.0;
            double down = 0.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (change[j] == null || stddev[j] == null) continue;
                double chg = change[j].doubleValue();
                if (chg > 0.0) {
                    up += stddev[j].doubleValue();
                    continue;
                }
                if (!(chg < 0.0)) continue;
                down += stddev[j].doubleValue();
            }
            if (up != 0.0) {
                up /= (double)period;
            }
            if (down != 0.0) {
                down /= (double)period;
            }
            results[i] = (updown = up + down) <= 0.0 ? Double.valueOf(unit.scale() * 0.5) : Double.valueOf(up / updown * unit.scale());
        }
        return results;
    }

    public static Map<Shinohara, Number[]> shinohara(Number[] open, Number[] high, Number[] low, Number[] close, int period) {
        return TechnicalAnalysis.shinohara(open, high, low, close, period, PercentageScale.PERCENT);
    }

    public static Map<Shinohara, Number[]> shinohara(Number[] open, Number[] high, Number[] low, Number[] close, int period, PercentageScale unit) {
        int length = ArrayDataUtils.getMinLength(open, high, low, close);
        Number[] a = new Number[length];
        Number[] b = new Number[length];
        for (int i = period; i < length; ++i) {
            if (close[i] == null) continue;
            double bull_energy = 0.0;
            double bear_energy = 0.0;
            double bull_active = 0.0;
            double bear_active = 0.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (open[j] == null || high[j] == null || low[j] == null || close[j - 1] == null) continue;
                double o = open[j].doubleValue();
                double h = high[j].doubleValue();
                double l = low[j].doubleValue();
                double prev_c = close[j - 1].doubleValue();
                bull_energy += h - o;
                bear_energy += o - l;
                bull_active += h - prev_c;
                bear_active += prev_c - l;
            }
            a[i] = bear_energy > 0.0 ? (Number)(bull_energy / bear_energy * unit.scale()) : (Number)1000;
            b[i] = bear_active > 0.0 ? (Number)(bull_active / bear_active * unit.scale()) : (Number)1000;
        }
        EnumMap<Shinohara, Number[]> map = new EnumMap<Shinohara, Number[]>(Shinohara.class);
        map.put(Shinohara.A_RATIO, a);
        map.put(Shinohara.B_RATIO, b);
        map.put(Shinohara.C_RATIO, TechnicalAnalysis.cratio(high, low, period, unit));
        map.put(Shinohara.MAIN_BAND1, TechnicalAnalysis.displace(TechnicalAnalysis.cratio(high, low, 40, unit), 16));
        map.put(Shinohara.MAIN_BAND2, TechnicalAnalysis.displace(TechnicalAnalysis.cratio(high, low, 52, unit), 25));
        map.put(Shinohara.SUB_BAND1, TechnicalAnalysis.displace(TechnicalAnalysis.cratio(high, low, 10, unit), 4));
        map.put(Shinohara.SUB_BAND2, TechnicalAnalysis.displace(TechnicalAnalysis.cratio(high, low, 20, unit), 8));
        return map;
    }

    protected static Number[] cratio(Number[] high, Number[] low, int period, PercentageScale unit) {
        int length = ArrayDataUtils.getMinLength(high, low);
        Number[] results = new Number[length];
        for (int i = period; i < length; ++i) {
            if (high[i] == null || low[i] == null) continue;
            double plus_energy = 0.0;
            double minus_energy = 0.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (high[j] == null || low[j] == null || high[j - 1] == null || low[j - 1] == null) continue;
                double prev_mid = (high[j - 1].doubleValue() + low[j - 1].doubleValue()) * 0.5;
                plus_energy += high[j].doubleValue() - prev_mid;
                minus_energy += prev_mid - low[j].doubleValue();
            }
            results[i] = plus_energy / minus_energy * unit.scale();
        }
        return results;
    }

    public static Map<Stochastics, Number[]> srv(Number[] high, Number[] low, Number[] close, int period_k, int period_d) {
        return TechnicalAnalysis.srv(high, low, close, period_k, period_d, MovingAverage.SMA, PercentageScale.PERCENT);
    }

    public static Map<Stochastics, Number[]> srv(Number[] high, Number[] low, Number[] close, int period_k, int period_d, PercentageScale unit) {
        return TechnicalAnalysis.srv(high, low, close, period_k, period_d, MovingAverage.SMA, unit);
    }

    public static Map<Stochastics, Number[]> srv(Number[] high, Number[] low, Number[] close, int period_k, int period_d, MovingAverage matype, PercentageScale unit) {
        Number[] highest = TechnicalAnalysis.highest(high, period_k);
        Number[] lowest = TechnicalAnalysis.lowest(low, period_k);
        int length = ArrayDataUtils.getMinLength(high, low, close);
        Number[] k = new Number[length];
        Number[] d = new Number[length];
        for (int i = period_k; i < length; ++i) {
            if (close[i] == null || lowest[i] == null || highest[i] == null) continue;
            if (highest[i].doubleValue() > lowest[i].doubleValue()) {
                k[i] = (close[i].doubleValue() - lowest[i].doubleValue()) / (highest[i].doubleValue() - lowest[i].doubleValue()) * 100.0;
            }
            double h3 = 0.0;
            double l3 = 0.0;
            for (int j = i - period_d + 1; j <= i; ++j) {
                if (close[j] == null || lowest[j] == null || highest[j] == null) continue;
                h3 += close[j].doubleValue() - lowest[j].doubleValue();
                l3 += highest[j].doubleValue() - lowest[j].doubleValue();
            }
            d[i] = l3 <= 0.0 ? Double.valueOf(unit.scale() * 0.5) : Double.valueOf(h3 / l3 * unit.scale());
        }
        EnumMap<Stochastics, Number[]> map = new EnumMap<Stochastics, Number[]>(Stochastics.class);
        map.put(Stochastics.K, k);
        map.put(Stochastics.D, d);
        map.put(Stochastics.SD, TechnicalAnalysis.ma(d, period_k, matype));
        return map;
    }

    public static Map<Stochastics, Number[]> srvrsi(Number[] x, int period_rsi, int period_k, int period_d, MovingAverage matype, PercentageScale unit) {
        Number[] rsi = TechnicalAnalysis.rsi(x, period_rsi, unit);
        return TechnicalAnalysis.srv(rsi, rsi, rsi, period_k, period_d, matype, unit);
    }

    public static Number[] tii(Number[] x, int period) {
        return TechnicalAnalysis.tii(x, period, MovingAverage.SMA, PercentageScale.PERCENT);
    }

    public static Number[] tii(Number[] x, int period, MovingAverage matype) {
        return TechnicalAnalysis.tii(x, period, matype, PercentageScale.PERCENT);
    }

    public static Number[] tii(Number[] x, int period, MovingAverage matype, PercentageScale unit) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        Number[] sub = TechnicalAnalysis.sub(x, TechnicalAnalysis.ma(x, period, matype));
        for (int i = period - 1; i < length; ++i) {
            if (sub[i] == null) continue;
            double sdpos = 0.0;
            double sdneg = 0.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (sub[j] == null) continue;
                double diff = sub[j].doubleValue();
                if (diff > 0.0) {
                    sdpos += diff;
                    continue;
                }
                sdneg += Math.abs(diff);
            }
            double sum = sdpos + sdneg;
            results[i] = sum == 0.0 ? Double.valueOf(unit.scale() * 0.5) : Double.valueOf(sdpos / (sdpos + sdneg) * unit.scale());
        }
        return results;
    }

    public static Map<Histogram, Number[]> trix(Number[] x, int period, int period_signal, MovingAverage matype_signal) {
        Number[] trix = TechnicalAnalysis.roc(TechnicalAnalysis.tripleSmooth(x, period, MovingAverage.EMA), 1, PercentageScale.PERCENT);
        Number[] signal = TechnicalAnalysis.ma(trix, period_signal, matype_signal);
        Number[] histogram = TechnicalAnalysis.sub(trix, signal);
        EnumMap<Histogram, Number[]> map = new EnumMap<Histogram, Number[]>(Histogram.class);
        map.put(Histogram.INDICATOR, trix);
        map.put(Histogram.SIGNAL, signal);
        map.put(Histogram.HISTOGRAM, histogram);
        return map;
    }

    public static Map<Histogram, Number[]> tsi(Number[] change, int period1, int period2, int period_signal, MovingAverage matype_signal) {
        return TechnicalAnalysis.tsi(change, period1, MovingAverage.EMA, period2, MovingAverage.EMA, period_signal, matype_signal, PercentageScale.PERCENT);
    }

    public static Map<Histogram, Number[]> tsi(Number[] change, int period1, int period2, MovingAverage matype, int period_signal, MovingAverage matype_signal) {
        return TechnicalAnalysis.tsi(change, period1, matype, period2, matype, period_signal, matype_signal, PercentageScale.PERCENT);
    }

    public static Map<Histogram, Number[]> tsi(Number[] change, int period1, MovingAverage matype1, int period2, MovingAverage matype2, int period_signal, MovingAverage matype_signal, PercentageScale unit) {
        Number[] chg = TechnicalAnalysis.doubleSmooth(change, period1, matype1, period2, matype2);
        Number[] abs = TechnicalAnalysis.doubleSmooth(TechnicalAnalysis.abs(change), period1, matype1, period2, matype2);
        int length = ArrayDataUtils.getMinLength(chg, abs);
        Number[] tsi = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (chg[i] == null || abs[i] == null) continue;
            tsi[i] = chg[i].doubleValue() == 0.0 || abs[i].doubleValue() == 0.0 ? Double.valueOf(0.0) : Double.valueOf(chg[i].doubleValue() / abs[i].doubleValue() * unit.scale());
        }
        Number[] signal = TechnicalAnalysis.ma(tsi, period_signal, matype_signal);
        Number[] histogram = TechnicalAnalysis.sub(tsi, signal);
        EnumMap<Histogram, Number[]> map = new EnumMap<Histogram, Number[]>(Histogram.class);
        map.put(Histogram.INDICATOR, tsi);
        map.put(Histogram.SIGNAL, signal);
        map.put(Histogram.HISTOGRAM, histogram);
        return map;
    }

    public static Number[] ultimate(Number[] high, Number[] low, Number[] close, int period) {
        return TechnicalAnalysis.ultimate(high, low, close, period, PercentageScale.PERCENT);
    }

    public static Number[] ultimate(Number[] high, Number[] low, Number[] close, int period, PercentageScale unit) {
        int length = ArrayDataUtils.getMinLength(high, low, close);
        Number[] results = new Number[length];
        Number[] tl = TechnicalAnalysis.tl(low, close);
        Number[] bp = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (close[i] == null || tl[i] == null) continue;
            bp[i] = close[i].doubleValue() - tl[i].doubleValue();
        }
        Number[] tr = TechnicalAnalysis.tr(high, low, close);
        for (int i = period * 4 - 1; i < length; ++i) {
            if (bp[i] == null || tr[i] == null) continue;
            double bpSum1 = 0.0;
            double trSum1 = 0.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (bp[j] == null || tr[j] == null) continue;
                bpSum1 += bp[j].doubleValue();
                trSum1 += tr[j].doubleValue();
            }
            double bpSum2 = 0.0;
            double trSum2 = 0.0;
            for (int j = i - period * 2 + 1; j <= i; ++j) {
                if (bp[j] == null || tr[j] == null) continue;
                bpSum2 += bp[j].doubleValue();
                trSum2 += tr[j].doubleValue();
            }
            double bpSum3 = 0.0;
            double trSum3 = 0.0;
            for (int j = i - period * 4 + 1; j <= i; ++j) {
                if (bp[j] == null || tr[j] == null) continue;
                bpSum3 += bp[j].doubleValue();
                trSum3 += tr[j].doubleValue();
            }
            double rawUO = 4.0 * (bpSum1 / trSum1) + 2.0 * (bpSum2 / trSum2) + bpSum3 / trSum3;
            results[i] = rawUO / 7.0 * unit.scale();
        }
        return results;
    }

    public static Number[] vidya(Number[] x, int period) {
        return TechnicalAnalysis.vidya(x, period, 9);
    }

    public static Number[] vidya(Number[] x, int period, int period_cmo) {
        int length = ArrayDataUtils.getMinLength(new Object[][]{x});
        Number[] results = new Number[length];
        double sc = 2.0 / ((double)period + 1.0);
        Number[] vi = TechnicalAnalysis.abs(TechnicalAnalysis.cmo(x, period_cmo, PercentageScale.RATE));
        Double vidya = null;
        for (int i = period - 1; i < length; ++i) {
            if (x[i] == null || x[i - 1] == null || vi[i] == null) continue;
            vidya = vidya == null ? Double.valueOf(x[i].doubleValue()) : Double.valueOf(sc * vi[i].doubleValue() * x[i].doubleValue() + (1.0 - sc * vi[i].doubleValue()) * x[i - 1].doubleValue());
            results[i] = vidya;
        }
        return results;
    }

    public static Number[] wad(Number[] high, Number[] low, Number[] close) {
        Number[] trh = TechnicalAnalysis.th(high, close);
        Number[] trl = TechnicalAnalysis.tl(low, close);
        int length = ArrayDataUtils.getMinLength(close, trh, trl);
        Number[] ad = new Number[length];
        Number[] results = new Number[length];
        for (int i = 1; i < length; ++i) {
            int j = i - 1;
            if (close[i] == null || close[j] == null || trh[i] == null || trl[i] == null) continue;
            double today = close[i].doubleValue();
            ad[i] = today > close[j].doubleValue() ? Double.valueOf(today - trl[i].doubleValue()) : (today < close[j].doubleValue() ? Double.valueOf(today - trh[i].doubleValue()) : Double.valueOf(0.0));
            results[i] = results[j] == null ? Double.valueOf(ad[i].doubleValue()) : Double.valueOf(ad[i].doubleValue() + results[j].doubleValue());
        }
        return results;
    }

    public static Number[] wr(Number[] high, Number[] low, Number[] close, int period) {
        return TechnicalAnalysis.wr(high, low, close, period, PercentageScale.REVERSE_PERCENT);
    }

    public static Number[] wr(Number[] high, Number[] low, Number[] close, int period, PercentageScale unit) {
        Number[] highest = TechnicalAnalysis.highest(high, period);
        Number[] lowest = TechnicalAnalysis.lowest(low, period);
        int length = ArrayDataUtils.getMinLength(close, highest, lowest);
        Number[] results = new Number[length];
        for (int i = period - 1; i < length; ++i) {
            if (highest[i] == null || lowest[i] == null || close[i] == null) continue;
            double d = highest[i].doubleValue() - lowest[i].doubleValue();
            results[i] = d > 0.0 ? Double.valueOf((highest[i].doubleValue() - close[i].doubleValue()) / d * unit.scale()) : Double.valueOf(unit.scale() * 0.5);
        }
        return results;
    }

    public static Number[] ad(Number[] high, Number[] low, Number[] close, Number[] volume) {
        Number[] clv = TechnicalAnalysis.clv(high, low, close);
        int length = ArrayDataUtils.getMinLength(clv, volume);
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (clv[i] == null || volume[i] == null) continue;
            results[i] = clv[i].doubleValue() * volume[i].doubleValue();
        }
        return results;
    }

    public static Number[] clv(Number[] high, Number[] low, Number[] close) {
        int length = ArrayDataUtils.getMinLength(high, low, close);
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (high[i] == null || low[i] == null || close[i] == null) continue;
            double h = high[i].doubleValue();
            double l = low[i].doubleValue();
            double c = close[i].doubleValue();
            double clhc = c - l - (h - c);
            double denominator = h - l;
            results[i] = clhc == 0.0 || denominator == 0.0 ? Double.valueOf(0.0) : Double.valueOf(clhc / denominator);
        }
        return results;
    }

    public static Number[] cho(Number[] high, Number[] low, Number[] close, Number[] volume, int period_fast, int period_slow) {
        return TechnicalAnalysis.cho(high, low, close, volume, period_fast, MovingAverage.EMA, period_slow, MovingAverage.EMA);
    }

    public static Number[] cho(Number[] high, Number[] low, Number[] close, Number[] volume, int period_fast, MovingAverage matype_fast, int period_slow, MovingAverage matype_slow) {
        Number[] ad = TechnicalAnalysis.ad(high, low, close, volume);
        return TechnicalAnalysis.sub(TechnicalAnalysis.ma(ad, period_fast, matype_fast), TechnicalAnalysis.ma(ad, period_slow, matype_slow));
    }

    public static Number[] avo(Number[] volume, int fast, int slow) {
        return TechnicalAnalysis.apo(volume, fast, slow);
    }

    public static Number[] avo(Number[] volume, int fast, int slow, MovingAverage matype) {
        return TechnicalAnalysis.apo(volume, fast, slow, matype);
    }

    public static Number[] bwmfi(Number[] high, Number[] low, Number[] volume) {
        return TechnicalAnalysis.bwmfi(high, low, volume, PercentageScale.PERCENT);
    }

    public static Number[] bwmfi(Number[] high, Number[] low, Number[] volume, PercentageScale unit) {
        Number[] bwmfi = TechnicalAnalysis.div(TechnicalAnalysis.sub(high, low), volume);
        int length = bwmfi.length;
        for (int i = 0; i < length; ++i) {
            if (bwmfi[i] == null) continue;
            bwmfi[i] = bwmfi[i].doubleValue() * unit.scale();
        }
        return bwmfi;
    }

    public static Number[] pvo(Number[] volume, int fast, int slow) {
        return TechnicalAnalysis.ppo(volume, fast, slow);
    }

    public static Number[] pvo(Number[] volume, int fast, int slow, MovingAverage matype) {
        return TechnicalAnalysis.ppo(volume, fast, slow, matype, PercentageScale.PERCENT);
    }

    public static Number[] pvo(Number[] volume, int fast, int slow, MovingAverage matype, PercentageScale unit) {
        return TechnicalAnalysis.ppo(volume, fast, slow, matype, unit);
    }

    public static Number[] pvt(Number[] price, Number[] volume) {
        int length = ArrayDataUtils.getMinLength(price, volume);
        Number[] results = new Number[length];
        Number[] chg = TechnicalAnalysis.roc(price, 1, PercentageScale.RATE);
        double pvt = 0.0;
        for (int i = 0; i < length; ++i) {
            if (chg[i] == null || volume[i] == null) continue;
            results[i] = pvt += volume[i].doubleValue() * chg[i].doubleValue();
        }
        return results;
    }

    public static Number[] vao(Number[] high, Number[] low, Number[] close, Number[] volume) {
        int length = ArrayDataUtils.getMinLength(high, low, close, volume);
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (high[i] == null || low[i] == null || close[i] == null || volume[i] == null) continue;
            results[i] = volume[i].doubleValue() * (close[i].doubleValue() - high[i].doubleValue() + low[i].doubleValue()) * 0.5;
        }
        return results;
    }

    public static Number[] vr1(Number[] change, Number[] volume, int period) {
        return TechnicalAnalysis.vr1(change, volume, period, 600.0, 150.0);
    }

    public static Number[] vr1(Number[] change, Number[] volume, int period, double upper, double lower) {
        int length = ArrayDataUtils.getMinLength(change, volume);
        Number[] results = new Number[length];
        for (int i = period - 1; i < length; ++i) {
            if (change[i] == null) continue;
            double up = 0.0;
            double down = 0.0;
            double keep = 0.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (change[j] == null || volume[j] == null) continue;
                double c = change[j].doubleValue();
                double v = volume[j].doubleValue();
                if (c > 0.0) {
                    up += v;
                    continue;
                }
                if (c < 0.0) {
                    down += v;
                    continue;
                }
                keep += v;
            }
            double numerator = up + keep / 2.0;
            double denominator = down + keep / 2.0;
            results[i] = denominator > 0.0 ? Double.valueOf(numerator / denominator * 100.0) : (numerator > 0.0 ? Double.valueOf(upper) : Double.valueOf(lower));
        }
        return results;
    }

    public static Number[] vr2(Number[] change, Number[] volume, int period) {
        return TechnicalAnalysis.vr2(change, volume, period, PercentageScale.PERCENT);
    }

    public static Number[] vr2(Number[] change, Number[] volume, int period, PercentageScale unit) {
        int length = ArrayDataUtils.getMinLength(change, volume);
        Number[] results = new Number[length];
        for (int i = period - 1; i < length; ++i) {
            if (change[i] == null) continue;
            double up = 0.0;
            double down = 0.0;
            double keep = 0.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (change[j] == null || volume[j] == null) continue;
                double c = change[j].doubleValue();
                double v = volume[j].doubleValue();
                if (c > 0.0) {
                    up += v;
                    continue;
                }
                if (c < 0.0) {
                    down += v;
                    continue;
                }
                keep += v;
            }
            double total = up + down + keep;
            results[i] = total <= 0.0 ? Double.valueOf(unit.scale() * 0.5) : Double.valueOf((up + keep * 0.5) / total * unit.scale());
        }
        return results;
    }

    public static Number[] wvr(Number[] change, Number[] volume, int period) {
        return TechnicalAnalysis.wvr(change, volume, period, PercentageScale.PERCENT);
    }

    public static Number[] wvr(Number[] change, Number[] volume, int period, PercentageScale unit) {
        int length = ArrayDataUtils.getMinLength(change, volume);
        Number[] results = new Number[length];
        for (int i = period; i < length; ++i) {
            if (change[i] == null) continue;
            double up = 0.0;
            double down = 0.0;
            double keep = 0.0;
            for (int j = i - period + 1; j <= i; ++j) {
                if (change[j] == null || volume[j] == null) continue;
                double c = change[j].doubleValue();
                double v = volume[j].doubleValue();
                if (c > 0.0) {
                    up += v;
                    continue;
                }
                if (c < 0.0) {
                    down += v;
                    continue;
                }
                keep += v;
            }
            double total = up + down + keep;
            results[i] = total <= 0.0 ? (Number)0 : (Number)((up - down - keep) / total * unit.scale());
        }
        return results;
    }

    public static Number[] pvi(Number[] price, Number[] volume) {
        int length = ArrayDataUtils.getMinLength(price, volume);
        Number[] results = new Number[length];
        double pvi = 1.0;
        for (int i = 1; i < length; ++i) {
            int j = i - 1;
            if (price[i] == null || price[j] == null || volume[i] == null || volume[j] == null) continue;
            if (volume[i].doubleValue() > volume[j].doubleValue()) {
                double prev_price = price[j].doubleValue();
                pvi += (price[i].doubleValue() - prev_price) / prev_price * pvi;
                results[i] = pvi;
                continue;
            }
            results[i] = pvi;
        }
        return results;
    }

    public static Number[] nvi(Number[] price, Number[] volume) {
        int length = ArrayDataUtils.getMinLength(price, volume);
        Number[] results = new Number[length];
        double nvi = 1.0;
        for (int i = 1; i < length; ++i) {
            int j = i - 1;
            if (price[i] == null || price[j] == null || volume[i] == null || volume[j] == null) continue;
            if (volume[i].doubleValue() < volume[j].doubleValue()) {
                double prev_price = price[j].doubleValue();
                nvi += (price[i].doubleValue() - prev_price) / prev_price * nvi;
                results[i] = nvi;
                continue;
            }
            results[i] = nvi;
        }
        return results;
    }

    public static Number[] obv(Number[] change, Number[] volume, int period) {
        int i;
        int length = ArrayDataUtils.getMinLength(change, volume);
        Number[] results = new Number[length];
        double obv = 0.0;
        for (i = 0; i < period; ++i) {
            if (volume[i] == null) continue;
            obv += volume[i].doubleValue();
        }
        for (i = period; i < length; ++i) {
            if (change[i] == null || volume[i] == null) continue;
            double c = change[i].doubleValue();
            double v = volume[i].doubleValue();
            if (c > 0.0) {
                obv += v;
            } else if (c < 0.0) {
                obv -= v;
            }
            results[i] = obv;
        }
        return results;
    }

    public static Map<FourPrice, Number[]> split(Number[] open, Number[] high, Number[] low, Number[] close, Number[] split) {
        if (open == null || high == null || low == null || close == null || split == null) {
            return null;
        }
        Number[] o = (Number[])open.clone();
        Number[] h = (Number[])high.clone();
        Number[] l = (Number[])low.clone();
        Number[] c = (Number[])close.clone();
        int length = ArrayDataUtils.getMinLength(o, h, l, c, split);
        for (int i = 0; i < length; ++i) {
            if (split[i] == null) continue;
            double n = split[i].doubleValue();
            for (int j = 0; j < i; ++j) {
                if (o[j] != null) {
                    o[j] = o[j].doubleValue() / n;
                }
                if (h[j] != null) {
                    h[j] = h[j].doubleValue() / n;
                }
                if (l[j] != null) {
                    l[j] = l[j].doubleValue() / n;
                }
                if (c[j] == null) continue;
                c[j] = c[j].doubleValue() / n;
            }
        }
        EnumMap<FourPrice, Number[]> results = new EnumMap<FourPrice, Number[]>(FourPrice.class);
        results.put(FourPrice.OPEN, o);
        results.put(FourPrice.HIGH, h);
        results.put(FourPrice.LOW, l);
        results.put(FourPrice.CLOSE, c);
        return results;
    }

    public static List<Step> pf(Date[] date, Number[] x, double point, int reversal) {
        int start = TechnicalAnalysis.findStartIndex(date, x);
        if (start + 1 >= date.length - 1) {
            return new ArrayList<Step>(0);
        }
        ArrayList<Step> list = new ArrayList<Step>();
        Step pf = new Step(date[start], x[start].doubleValue());
        boolean upTrend = x[start].doubleValue() < x[start + 1].doubleValue();
        for (int i = start; i < date.length; ++i) {
            if (x[i] == null) continue;
            double value = x[i].doubleValue();
            if (upTrend) {
                if (value > pf.high) {
                    pf.highDate = date[i];
                    pf.high = value;
                } else {
                    double _low = pf.high - Math.floor(pf.high % point) - point * (double)(reversal - 1);
                    if (value < _low && pf.low < _low) {
                        list.add(pf);
                        Date highDate = pf.highDate;
                        double high = pf.high;
                        pf = new Step(highDate, high, 0);
                        pf.lowDate = date[i];
                        pf.low = value;
                        upTrend = false;
                    }
                }
            } else if (value <= pf.low) {
                pf.lowDate = date[i];
                pf.low = value;
            } else {
                double _high = pf.low - Math.floor(pf.low % point) + point * (double)reversal;
                if (value >= _high && pf.high >= _high) {
                    list.add(pf);
                    Date lowDate = pf.lowDate;
                    double low = pf.low;
                    pf = new Step(lowDate, low, 0);
                    pf.highDate = date[i];
                    pf.high = value;
                    upTrend = true;
                }
            }
            pf.closeDate = date[i];
            pf.close = value;
            ++pf.period;
        }
        list.add(pf);
        return list;
    }

    public static List<Step> kagi(Date[] date, Number[] x, double rate) {
        double r = rate * 0.01;
        ArrayList<Step> list = new ArrayList<Step>();
        int start = TechnicalAnalysis.findStartIndex(date, x);
        if (start + 1 >= date.length - 1) {
            return new ArrayList<Step>(0);
        }
        Step kagi = new Step(date[start], x[start].doubleValue());
        boolean upTrend = x[start].doubleValue() < x[start + 1].doubleValue();
        for (int i = start + 1; i < date.length; ++i) {
            if (x[i] == null) continue;
            double value = x[i].doubleValue();
            if (upTrend) {
                if (value > kagi.high) {
                    kagi.highDate = date[i];
                    kagi.high = value;
                } else if (r <= (kagi.high - value) / kagi.high) {
                    list.add(kagi);
                    Date highDate = kagi.highDate;
                    double high = kagi.high;
                    kagi = new Step(date[i], value, 0);
                    kagi.open = high;
                    kagi.highDate = highDate;
                    kagi.high = high;
                    upTrend = false;
                }
            } else if (value < kagi.low) {
                kagi.lowDate = date[i];
                kagi.low = value;
            } else if (r <= (value - kagi.low) / kagi.low) {
                list.add(kagi);
                Date lowDate = kagi.lowDate;
                double low = kagi.low;
                kagi = new Step(date[i], value, 0);
                kagi.open = low;
                kagi.lowDate = lowDate;
                kagi.low = low;
                upTrend = true;
            }
            kagi.closeDate = date[i];
            kagi.close = value;
            ++kagi.period;
        }
        list.add(kagi);
        return list;
    }

    public static List<Step> renkoh(Date[] date, Number[] x, double point) {
        ArrayList<Step> list = new ArrayList<Step>();
        int start = TechnicalAnalysis.findStartIndex(date, x);
        if (start + 1 >= date.length - 1) {
            return new ArrayList<Step>(0);
        }
        Step renkoh = new Step(date[start], x[start].doubleValue(), 0);
        boolean upTrend = x[start].doubleValue() < x[start + 1].doubleValue();
        for (int i = start + 1; i < date.length; ++i) {
            int j;
            if (x[i] == null) continue;
            double value = x[i].doubleValue();
            if (upTrend) {
                if (value > renkoh.high + point) {
                    for (int j2 = 0; j2 < (int)Math.floor((value - renkoh.high) / point); ++j2) {
                        double high = renkoh.high + point;
                        renkoh.highDate = date[i];
                        renkoh.high = high;
                        renkoh.closeDate = date[i];
                        renkoh.close = high;
                        list.add(renkoh);
                        renkoh = new Step(date[i], high, 0);
                    }
                    continue;
                }
                if (!(value < renkoh.low - point * 2.0)) continue;
                double v = renkoh.high - point;
                renkoh = new Step(date[i], v, 0);
                if (list.size() > 0) {
                    Step o = (Step)list.get(list.size() - 1);
                    renkoh.highDate = o.openDate;
                }
                for (j = 0; j < (int)Math.floor((renkoh.high - value) / point); ++j) {
                    double low = renkoh.low - point;
                    renkoh.lowDate = date[i];
                    renkoh.low = low;
                    renkoh.closeDate = date[i];
                    renkoh.close = low;
                    list.add(renkoh);
                    renkoh = new Step(date[i], low, 0);
                }
                upTrend = false;
                continue;
            }
            if (value < renkoh.low - point) {
                for (int j3 = 0; j3 < (int)Math.floor((renkoh.low - value) / point); ++j3) {
                    double low = renkoh.low - point;
                    renkoh.lowDate = date[i];
                    renkoh.low = low;
                    renkoh.closeDate = date[i];
                    renkoh.close = low;
                    list.add(renkoh);
                    renkoh = new Step(date[i], low, 0);
                }
                continue;
            }
            if (!(value > renkoh.high + point * 2.0)) continue;
            double v = renkoh.low + point;
            renkoh = new Step(date[i], v, 0);
            if (list.size() > 0) {
                Step o = (Step)list.get(list.size() - 1);
                renkoh.lowDate = o.openDate;
            }
            for (j = 0; j < (int)Math.floor((value - renkoh.low) / point); ++j) {
                double high = renkoh.high + point;
                renkoh.highDate = date[i];
                renkoh.high = high;
                renkoh.closeDate = date[i];
                renkoh.close = high;
                list.add(renkoh);
                renkoh = new Step(date[i], high, 0);
            }
            upTrend = true;
        }
        return list;
    }

    public static List<Step> shinne(Date[] date, Number[] x, int period) {
        ArrayList<Step> list = new ArrayList<Step>();
        int start = TechnicalAnalysis.findStartIndex(date, x);
        if (start + 1 >= date.length - 1) {
            return new ArrayList<Step>(0);
        }
        Step shinne = new Step(date[start], x[start].doubleValue(), 0);
        boolean upTrend = x[start].doubleValue() < x[start + 1].doubleValue();
        for (int i = start + 1; i < date.length; ++i) {
            if (x[i] == null) continue;
            double value = x[i].doubleValue();
            Double over = null;
            Date overDate = null;
            for (int j = list.size() - period; j < list.size(); ++j) {
                if (j < 0) continue;
                Step prev = (Step)list.get(j);
                if (upTrend) {
                    if (over != null && !(over > prev.low)) continue;
                    over = prev.low;
                    overDate = prev.lowDate;
                    continue;
                }
                if (over != null && !(over < prev.high)) continue;
                over = prev.high;
                overDate = prev.highDate;
            }
            if (over == null) {
                over = shinne.close;
            }
            if (upTrend) {
                if (value > shinne.high) {
                    shinne.highDate = date[i];
                    shinne.high = value;
                    shinne.closeDate = date[i];
                    shinne.close = value;
                    ++shinne.period;
                    list.add(shinne);
                    shinne = new Step(date[i], value, 0);
                    continue;
                }
                if (!(value < over)) continue;
                if (list.size() <= 0) {
                    shinne.open = over;
                    shinne.highDate = overDate;
                    shinne.high = over;
                } else {
                    Step o = (Step)list.get(list.size() - 1);
                    shinne.open = o.open;
                    shinne.highDate = o.openDate;
                    shinne.high = o.open;
                }
                shinne.lowDate = date[i];
                shinne.low = value;
                shinne.closeDate = date[i];
                shinne.close = value;
                ++shinne.period;
                list.add(shinne);
                shinne = new Step(date[i], value, 0);
                upTrend = false;
                continue;
            }
            if (value < shinne.low) {
                shinne.lowDate = date[i];
                shinne.low = value;
                shinne.closeDate = date[i];
                shinne.close = value;
                ++shinne.period;
                list.add(shinne);
                shinne = new Step(date[i], value, 0);
                continue;
            }
            if (!(value > over)) continue;
            if (list.size() <= 0) {
                shinne.open = over;
                shinne.lowDate = overDate;
                shinne.low = over;
            } else {
                Step o = (Step)list.get(list.size() - 1);
                shinne.open = o.open;
                shinne.lowDate = o.openDate;
                shinne.low = o.open;
            }
            shinne.highDate = date[i];
            shinne.high = value;
            shinne.closeDate = date[i];
            shinne.close = value;
            ++shinne.period;
            list.add(shinne);
            shinne = new Step(date[i], value, 0);
            upTrend = true;
        }
        return list;
    }

    private static int findStartIndex(Date[] date, Number[] x) {
        int length = ArrayDataUtils.getMinLength(date, x);
        for (int i = 0; i < length; ++i) {
            if (date[i] == null || x[i] == null) continue;
            return i;
        }
        return -1;
    }
}

