
#include <pekoe.h>
#include <sys/rpcss.h>
#include <OrangePekoe/Devices/IHidInputDevice.h>

namespace	OrangePekoe {
	namespace	Devices {

		class	KeyboardDevice: public IHidInputDevice {
		protected:
			KMODE_SPINLOCK keybd_thread_alive;
			volatile int contflag;
			void ThreadProc();
		public:
			KeyboardDevice(){
//				mts_puts("keybd ctor");
				contflag=1;
				sys_release_spinlock(&keybd_thread_alive);
				crtCreateThread(4080,keybd_thread_stub,this);
			}
			virtual	~KeyboardDevice();
			friend	void keybd_thread_stub(void* dev);
		};

		void keybd_thread_stub(void* dev){
			KeyboardDevice* p=(KeyboardDevice*)dev;
			p->ThreadProc();
		}

		void KeyboardDevice::ThreadProc(){
			int count;
			KEY_PACKET packet;

			sys_acquire_spinlock(&keybd_thread_alive);
			for(;contflag;sys_wait()){
				do{
					count=sys_fs_read(devid_rpcss,port_keybd,0,&packet,1);
					if(count>0){
						if(packet.keycode&0x80000000){
							if(delegate) delegate->OnButtonUp(*this,packet.keycode,packet.shift_state);
						}else{
							if(delegate) delegate->OnButtonDown(*this,packet.keycode,packet.shift_state);
						}
					}
				}while(count);
			}
			sys_release_spinlock(&keybd_thread_alive);
		}

		KeyboardDevice::~KeyboardDevice(){
			contflag=0;
			sys_acquire_spinlock(&keybd_thread_alive);
//			mts_puts("keybd dtor");
		}

		KeyboardDevice	myKeyboard;

		IHidInputDevice& getKeyboardInstance(void){
			return (IHidInputDevice&)myKeyboard;
		}

	}
}
