//
//	IO Library
//

#ifndef	_IO32_H_
#define	_IO32_H_

#include "types.h"

inline	uint8	inportb(word addr){
	uint8 ret;
	asm volatile(
		"inb %%dx,%%al \n"
		:"=a"(ret)
		:"d"(addr)
		);
	return ret;
}
inline	uint16	inportw(word addr){
	uint16 ret;
	asm volatile(
		"inw %%dx,%%ax \n"
		:"=a"(ret)
		:"d"(addr)
		);
	return ret;
}
inline	uint32	inportd(word addr){
	uint32 ret;
	asm volatile(
		"inl %%edx,%%eax \n"
		:"=a"(ret)
		:"d"(addr)
		);
	return ret;
}
#define	inportl(addr)	inportd(addr)
#define	inp8(addr)		inportb(addr)
#define	inp16(addr)		inportw(addr)
#define	inp32(addr)		inportd(addr)
inline	void	outportb(word addr,uint8 data){
	asm volatile(
		"outb %%al,%%dx \n"
		:
		:"a"(data),"d"(addr)
		);
}
inline	void	outportw(word addr,uint16 data){
	asm volatile(
		"outw %%ax,%%dx \n"
		:
		:"a"(data),"d"(addr)
	);
}
inline	void	outportd(word addr,uint32 data){
	asm volatile(
		"outl %%eax,%%dx \n"
		:
		:"a"(data),"d"(addr)
	);
}
#define	outportl(addr,data)	outportd(addr,data)
#define	outp8(addr,data)	outportb(addr,data)
#define	outp16(addr,data)	outportw(addr,data)
#define	outp32(addr,data)	outportd(addr,data)

#endif
