//
//	OrangePekoe Objective Foundation Class
//
#ifndef	__SYSTEM_OBJECT_H__
#define	__SYSTEM_OBJECT_H__

#include <pekoe.h>

namespace System {

	class	Object;
	class	String;
	class	Console;

	class	Object {
	public:
		void*	operator new(size_t);
		void	operator delete(void*);
		void*	operator new[](size_t);
		void	operator delete[](void*);
		inline	Object(){}
		inline	virtual	~Object(){}
		inline	virtual	String	toString() const;
		inline	virtual	int		get_Hash() const { return (int)(intptr)this; }
		inline	virtual	bool	equals(Object& o){ return &o==this; }
		inline	static	bool	equals(Object& o,Object& p){ return o.equals(p); }
	};

	class	String:public Object {
	protected:
		char*	content;
		int		length;
	public:
		inline	String():content(0),length(0) {}
		inline	String(const char* s):content(0),length(0) { set(s); }
		inline	~String(){ delete content; }
		String&	set(const char* s);
		String&	add(const String& o);
		String&	add(const int64 i);
		String&	add(const uint64 i);
		inline	String&	add(signed int i){ return add((int64)i); }
		inline	String&	add(signed long i){ return add((int64)i); }
		inline	String&	add(unsigned int i){ return add((uint64)i); }
		inline	String&	add(unsigned long i){ return add((uint64)i); }
		inline	void	empty(){ set(NULL); }
		inline	String	toString() const { return *this; }
		inline	int		get_Length() const { return length; }
		inline	char*	get_Content() const { return content; }
		inline	char	operator[](int i) const { return content[i]; }
		inline	const	String&	operator=(const char* s){ set(s); return *this; }
	};
	inline	String Object::toString() const { return "[object]"; }

	class	Console: public System::Object {
	public:
		static	void	WriteLine();
		static	void	Write(const System::String&);
		static	void	Write(int64);
		static	void	Write(uint64);
		static	int		Read();

		inline	static	void	Write(const System::Object& o){ Write(o.toString()); }
		inline	static	void	Write(const System::Object* o){ Write(o->toString()); }
		inline	static	void	Write(signed int i){ Write((int64)i); }
		inline	static	void	Write(signed long i){ Write((int64)i); }
		inline	static	void	Write(unsigned int i){ Write((uint64)i); }
		inline	static	void	Write(unsigned long i){ Write((uint64)i); }

		inline	static	void	WriteLine(const System::String& s){ Write(s); WriteLine(); }
		inline	static	void	WriteLine(int64 i){ Write(i); WriteLine(); }
		inline	static	void	WriteLine(uint64 i){ Write(i); WriteLine(); }
		inline	static	void	WriteLine(const System::Object& o){ WriteLine(o.toString()); }
		inline	static	void	WriteLine(const System::Object* o){ WriteLine(o->toString()); }
		inline	static	void	WriteLine(signed int i){ WriteLine((int64)i); }
		inline	static	void	WriteLine(signed long i){ WriteLine((int64)i); }
		inline	static	void	WriteLine(unsigned int i){ WriteLine((uint64)i); }
		inline	static	void	WriteLine(unsigned long i){ WriteLine((uint64)i); }
	};

}

#endif
